/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1887;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class SortSelector {
    public static Comparator<class_1799> getSortTypeComparator(List<class_1799> stacks, SortType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SortType.CATEGORY -> Comparator.comparing(SortSelector::getStringForCategorySort);
            case SortType.NAME -> Comparator.comparing(SortSelector::getStringForNameSort);
            case SortType.COUNT -> SortSelector.getCountTypeComparator(stacks);
        };
    }

    public static Comparator<class_1799> getCountTypeComparator(List<class_1799> stacks) {
        HashMap<class_1792, Integer> counts = SortSelector.calculateCount(stacks);
        ArrayList<class_1792> sortedItems = new ArrayList<class_1792>(counts.keySet());
        sortedItems.sort((item1, item2) -> {
            int countCompare = Integer.compare((Integer)counts.get(item2), (Integer)counts.get(item1));
            if (countCompare != 0) {
                return countCompare;
            }
            return item1.method_7876().compareTo(item2.method_7876());
        });
        return (stack1, stack2) -> {
            if (stack1.method_7960() && stack2.method_7960()) {
                return 0;
            }
            if (stack1.method_7960()) {
                return 1;
            }
            if (stack2.method_7960()) {
                return -1;
            }
            int index1 = sortedItems.indexOf(stack1.method_7909());
            int index2 = sortedItems.indexOf(stack2.method_7909());
            return Integer.compare(index1, index2);
        };
    }

    public static HashMap<class_1792, Integer> calculateCount(List<class_1799> stacks) {
        HashMap<class_1792, Integer> itemCounts = new HashMap<class_1792, Integer>();
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            int count = stack.method_7947();
            itemCounts.put(item, itemCounts.getOrDefault(item, 0) + count);
        }
        return itemCounts;
    }

    public static String getStringForCategorySort(class_1799 stack) {
        String name = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        name = SortSelector.specialCases(stack, name);
        return name;
    }

    public static String getStringForNameSort(class_1799 stack) {
        String key = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        String itemName = key.split(":")[1];
        itemName = SortSelector.specialCases(stack, itemName);
        return itemName;
    }

    private static String specialCases(class_1799 stack, String name) {
        class_1792 item = stack.method_7909();
        name = SortSelector.stackSize(stack, name);
        if (item instanceof class_1772) {
            return SortSelector.enchantedBookNameCase(stack, name);
        }
        if (item instanceof class_1831) {
            return SortSelector.toolDurabilityCase(stack, name);
        }
        return name;
    }

    private static String stackSize(class_1799 stack, String name) {
        int invertedCount = 9999 - stack.method_7947();
        return name + String.format("%04d", invertedCount);
    }

    private static String enchantedBookNameCase(class_1799 stack, String name) {
        class_2499 enchants = class_1772.method_7806((class_1799)stack);
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (int i = 0; i < enchants.size(); ++i) {
            class_1887 enchant;
            class_2487 enchantTag = enchants.method_10602(i);
            class_2960 enchantID = class_2960.method_12829((String)enchantTag.method_10558("id"));
            if (enchantID == null || (enchant = (class_1887)class_7923.field_41176.method_10223(enchantID)) == null) continue;
            names.add(enchant.method_8179(enchantTag.method_10550("lvl")).getString());
        }
        Collections.sort(names);
        for (String enchant : names) {
            enchantNames.append(enchant).append(" ");
        }
        return name + " " + enchants.size() + " " + String.valueOf(enchantNames);
    }

    private static String toolDurabilityCase(class_1799 stack, String name) {
        return name + stack.method_7919();
    }

    public static enum SortType {
        CATEGORY,
        NAME,
        COUNT;


        public SortType next() {
            SortType[] values = SortType.values();
            int nextIndex = (this.ordinal() + 1) % values.length;
            return values[nextIndex];
        }
    }
}

