/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.data.fabric.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;

public class CookingPotRecipeJsonBuilder
implements class_5797 {
    private CookingPotRecipeBookTab tab;
    private final class_1792 output;
    private final int outputCount;
    private final class_1792 container;
    private final List<class_1856> inputs;
    private final float experience;
    private final int cookingTime;
    private final class_161.class_162 advancement = class_161.class_162.method_51698();

    private CookingPotRecipeJsonBuilder(class_1935 output, int outputCount, @Nullable class_1792 container, List<class_1856> inputs, float experience, int cookingTime) {
        this.output = output.method_8389();
        this.outputCount = outputCount;
        this.container = container != null ? container.method_8389() : null;
        this.inputs = inputs;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public static CookingPotRecipeJsonBuilder create(class_1935 output, int outputCount, int cookingTime, float experience, class_1792 container, List<class_1856> inputs) {
        return new CookingPotRecipeJsonBuilder(output, outputCount, container, inputs, experience, cookingTime);
    }

    public static CookingPotRecipeJsonBuilder create(class_1935 output, int outputCount, int cookingTime, float experience, List<class_1856> inputs) {
        return new CookingPotRecipeJsonBuilder(output, outputCount, null, inputs, experience, cookingTime);
    }

    public CookingPotRecipeJsonBuilder input(class_6862<class_1792> tag) {
        return this.input(class_1856.method_8106(tag));
    }

    public CookingPotRecipeJsonBuilder input(class_1935 item) {
        return this.input(item, 1);
    }

    public CookingPotRecipeJsonBuilder input(class_1935 itemProvider, int size) {
        for (int i = 0; i < size; ++i) {
            this.input(class_1856.method_8091((class_1935[])new class_1935[]{itemProvider}));
        }
        return this;
    }

    public CookingPotRecipeJsonBuilder input(class_1856 ingredient) {
        return this.input(ingredient, 1);
    }

    public CookingPotRecipeJsonBuilder input(class_1856 ingredient, int size) {
        for (int i = 0; i < size; ++i) {
            this.inputs.add(ingredient);
        }
        return this;
    }

    public CookingPotRecipeJsonBuilder unlockedBy(String criterionName, class_184 criterionTrigger) {
        this.advancement.method_709(criterionName, criterionTrigger);
        return this;
    }

    public CookingPotRecipeJsonBuilder unlockedBy(String criterionName, class_1935 ... items) {
        return this.unlockedBy(criterionName, (class_184)class_2066.class_2068.method_8959((class_1935[])items));
    }

    public CookingPotRecipeJsonBuilder unlockedByAny(class_1935 ... items) {
        this.advancement.method_709("has_any_ingredient", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(items).method_8976()}));
        return this;
    }

    public CookingPotRecipeJsonBuilder setRecipeBookTab(CookingPotRecipeBookTab tab) {
        this.tab = tab;
        return this;
    }

    public class_5797 method_33529(@Nullable String groupName) {
        return null;
    }

    public class_1792 method_36441() {
        return this.output;
    }

    public void method_17972(Consumer<class_2444> finishedRecipeConsumer, class_2960 recipeId) {
        this.ensureValid(recipeId);
        String fdCookingPrefix = "farmersdelight/cooking/";
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId.method_45138(fdCookingPrefix))).method_703(class_170.class_171.method_753((class_2960)recipeId.method_45138(fdCookingPrefix))).method_704(class_193.field_1257);
        finishedRecipeConsumer.accept(new Result(recipeId.method_45138(fdCookingPrefix), this.tab, this.output, this.outputCount, this.container, this.inputs, this.experience, this.cookingTime, this.advancement, recipeId.method_45138("recipes/food/" + fdCookingPrefix)));
    }

    private void ensureValid(class_2960 id) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final CookingPotRecipeBookTab tab;
        private final class_1792 output;
        private final int outputCount;
        private final class_1792 container;
        private final List<class_1856> inputs;
        private final float experience;
        private final int cookingTime;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;

        public Result(class_2960 id, CookingPotRecipeBookTab tab, class_1792 output, int outputCount, class_1792 container, List<class_1856> inputs, float experience, int cookingTime, class_161.class_162 advancement, class_2960 advancementId) {
            this.id = id;
            this.tab = tab;
            this.output = output;
            this.outputCount = outputCount;
            this.container = container;
            this.inputs = inputs;
            this.experience = experience;
            this.cookingTime = cookingTime;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject json) {
            if (this.tab != null) {
                json.addProperty("recipe_book_tab", this.tab.toString());
            }
            json.addProperty("cookingtime", (Number)this.cookingTime);
            if (this.experience > 0.0f) {
                json.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
            JsonArray arrayIngredients = new JsonArray();
            for (class_1856 input : this.inputs) {
                arrayIngredients.add(input.method_8089());
            }
            json.add("ingredients", (JsonElement)arrayIngredients);
            JsonObject objectResult = new JsonObject();
            objectResult.addProperty("item", class_7923.field_41178.method_10221((Object)this.output).toString());
            if (this.outputCount > 1) {
                objectResult.addProperty("count", (Number)this.outputCount);
            }
            json.add("result", (JsonElement)objectResult);
            if (this.container != null) {
                JsonObject objectContainer = new JsonObject();
                objectContainer.addProperty("item", class_7923.field_41178.method_10221((Object)this.container).toString());
                json.add("container", (JsonElement)objectContainer);
            }
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return (class_1865)ModRecipeSerializers.COOKING.get();
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

