/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.crafting.fabric;

import com.chefmooon.ubesdelight.common.crafting.BakingMatRecipe;
import com.chefmooon.ubesdelight.common.crafting.ingredient.ChanceResult;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeSerializersImpl;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeTypesImpl;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;

public class BakingMatRecipeImpl
extends BakingMatRecipe
implements class_1860<RecipeWrapper> {
    public BakingMatRecipeImpl(class_2960 id, String group, class_2371<class_1856> ingredientList, class_2371<class_1856> processStages, class_1856 tool, class_2371<ChanceResult> resultList, String soundEvent) {
        super(id, group, ingredientList, processStages, tool, resultList, soundEvent);
    }

    public boolean method_8118() {
        return true;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredientList;
    }

    public class_2371<class_1856> getProcessStages() {
        return this.processStages;
    }

    public class_2371<class_1856> getIngredientsAndTool() {
        class_2371 ingredientTool = class_2371.method_10211();
        ingredientTool.addAll((Collection)this.ingredientList);
        ingredientTool.add((Object)this.tool);
        return this.ingredientList;
    }

    public class_1856 getTool() {
        return this.tool;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return ((ChanceResult)this.resultList.get(0)).stack();
    }

    public List<class_1799> getResultList() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public class_1799 getMandatoryResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).findFirst().get();
    }

    public List<class_1799> getMandatoryResults() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).toList();
    }

    public List<ChanceResult> getVariableResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() != 1.0f).toList();
    }

    public class_2371<ChanceResult> getRollableResults() {
        return this.resultList;
    }

    public String getSoundEventID() {
        return this.soundEvent;
    }

    public boolean matches(RecipeWrapper inv, class_1937 level) {
        boolean inputMatch;
        boolean processMatch = false;
        class_1662 inputList = new class_1662();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            class_1799 itemStack = inv.method_5438(j);
            if (itemStack.method_7960()) continue;
            ++i;
            inputList.method_7400(itemStack);
        }
        boolean bl = inputMatch = i == this.ingredientList.size() && inputList.method_7402((class_1860)this, null);
        if (!inputMatch && this.processStages.size() > 0 && !inputList.field_7550.isEmpty()) {
            for (class_1856 ingredient : this.processStages) {
                if (!Arrays.stream(ingredient.method_8105()).findFirst().get().method_31574(inv.method_5438(0).method_7909())) continue;
                processMatch = true;
            }
        }
        return inputMatch || processMatch;
    }

    public class_1799 assemble(RecipeWrapper container, class_5455 registryAccess) {
        return ((ChanceResult)this.resultList.get(0)).stack().method_7972();
    }

    public List<class_1799> getRollResults(class_5819 rand, int fortuneLevel) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        class_2371<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            class_1799 stack = output.chance() == 1.0f ? output.stack() : output.rollStackOutput(rand, fortuneLevel);
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        return results;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredientList.size();
    }

    public class_1865<?> method_8119() {
        return UbesDelightRecipeSerializersImpl.BAKING_MAT.get();
    }

    public class_3956<?> method_17716() {
        return UbesDelightRecipeTypesImpl.BAKING_MAT.get();
    }

    public String getSoundEvent() {
        return this.soundEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakingMatRecipeImpl that = (BakingMatRecipeImpl)o;
        if (!this.method_8114().equals((Object)that.method_8114())) {
            return false;
        }
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (!this.ingredientList.equals((Object)that.ingredientList)) {
            return false;
        }
        if (!this.processStages.equals((Object)that.processStages)) {
            return false;
        }
        if (!this.getTool().equals(that.getTool())) {
            return false;
        }
        if (!this.getResultList().equals(that.getResultList())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        int result = this.method_8114().hashCode();
        result = 31 * result + (this.method_8112() != null ? this.method_8112().hashCode() : 0);
        result = 31 * result + this.ingredientList.hashCode();
        result = 31 * result + this.processStages.hashCode();
        result = 31 * result + this.getTool().hashCode();
        result = 31 * result + this.getResultList().hashCode();
        result = 31 * result + (this.soundEvent != null ? this.soundEvent.hashCode() : 0);
        return result;
    }

    public static class Serializer
    implements class_1865<BakingMatRecipeImpl> {
        public BakingMatRecipeImpl fromJson(class_2960 id, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> ingredientList = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            class_2371<class_1856> processingStages = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"processing_stages"));
            class_1856 tool = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)json, (String)"tool"));
            if (ingredientList.isEmpty()) {
                throw new JsonParseException("No ingredients for baking recipe");
            }
            if (tool.method_8103()) {
                throw new JsonParseException("No tool for baking recipe");
            }
            if (ingredientList.size() > 9) {
                throw new JsonParseException("Too many ingredients for baking recipe! Max ingredients is 9");
            }
            if (processingStages.size() > 5) {
                throw new JsonParseException("Too many processing stages for baking recipe! Max processing stages is 5");
            }
            class_2371<ChanceResult> results = Serializer.readResults(class_3518.method_15261((JsonObject)json, (String)"result"));
            if (results.size() > 4) {
                throw new JsonParseException("Too many results for baking recipe! The maximum quantity of unique results is 4");
            }
            String soundID = class_3518.method_15253((JsonObject)json, (String)"sound", (String)"");
            return new BakingMatRecipeImpl(id, group, ingredientList, processingStages, tool, results, soundID);
        }

        private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)ingredientArray.get(i));
                if (ingredient.method_8103()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static class_2371<ChanceResult> readResults(JsonArray resultArray) {
            class_2371 results = class_2371.method_10211();
            for (JsonElement result : resultArray) {
                results.add((Object)ChanceResult.deserialize(result));
            }
            return results;
        }

        public BakingMatRecipeImpl fromNetwork(class_2960 id, class_2540 buf) {
            String groupIn = buf.method_10800(Short.MAX_VALUE);
            int i = buf.method_10816();
            class_2371 ingredientList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < ingredientList.size(); ++j) {
                ingredientList.set(j, (Object)class_1856.method_8086((class_2540)buf));
            }
            int k = buf.method_10816();
            class_2371 processingStagesList = class_2371.method_10213((int)k, (Object)class_1856.field_9017);
            for (int l = 0; l < processingStagesList.size(); ++l) {
                processingStagesList.set(l, (Object)class_1856.method_8086((class_2540)buf));
            }
            class_1856 tool = class_1856.method_8086((class_2540)buf);
            int m = buf.method_10816();
            class_2371 resultsList = class_2371.method_10213((int)m, (Object)ChanceResult.EMPTY);
            for (int n = 0; n < resultsList.size(); ++n) {
                resultsList.set(n, (Object)ChanceResult.read(buf));
            }
            String soundID = buf.method_19772();
            return new BakingMatRecipeImpl(id, groupIn, (class_2371<class_1856>)ingredientList, (class_2371<class_1856>)processingStagesList, tool, (class_2371<ChanceResult>)resultsList, soundID);
        }

        public void toNetwork(class_2540 buf, BakingMatRecipeImpl recipe) {
            buf.method_10814(recipe.group);
            buf.method_10804(recipe.ingredientList.size());
            for (class_1856 ingredient : recipe.ingredientList) {
                ingredient.method_8088(buf);
            }
            buf.method_10804(recipe.processStages.size());
            for (class_1856 processingStages : recipe.processStages) {
                processingStages.method_8088(buf);
            }
            recipe.tool.method_8088(buf);
            buf.method_10804(recipe.resultList.size());
            for (ChanceResult result : recipe.resultList) {
                result.write(buf);
            }
            buf.method_10814(recipe.soundEvent);
        }
    }
}

