/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.starfish_studios.bbb.block.AbstractBlockBlock;
import com.starfish_studios.bbb.block.BlockBlock;
import com.starfish_studios.bbb.block.WallBlockBlock;
import com.starfish_studios.bbb.block.entity.BlockBlockEntity;
import com.starfish_studios.bbb.client.model.BBBModelLayers;
import com.starfish_studios.bbb.client.model.BlockModel;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_7718;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BlockBlockRenderer
implements class_827<BlockBlockEntity> {
    private final ImmutableMap<BlockBlock.Types, BlockModel> modelByType = BlockBlockRenderer.createBlockRenderers(class_310.method_1551().method_31974());
    private static final Map<BlockBlock.Type, class_2960> TEXTURE_BY_TYPE = (Map)class_156.method_654((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(BlockBlock.Types.STONE, new class_2960("bbb:textures/block/block/stone.png"));
        hashMap.put(BlockBlock.Types.BLACKSTONE, new class_2960("bbb:textures/block/block/blackstone.png"));
        hashMap.put(BlockBlock.Types.DEEPSLATE, new class_2960("bbb:textures/block/block/deepslate.png"));
        hashMap.put(BlockBlock.Types.NETHER_BRICK, new class_2960("bbb:textures/block/block/nether_brick.png"));
        hashMap.put(BlockBlock.Types.SANDSTONE, new class_2960("bbb:textures/block/block/sandstone.png"));
        hashMap.put(BlockBlock.Types.RED_SANDSTONE, new class_2960("bbb:textures/block/block/red_sandstone.png"));
        hashMap.put(BlockBlock.Types.QUARTZ, new class_2960("bbb:textures/block/block/quartz.png"));
    });

    public static ImmutableMap<BlockBlock.Types, BlockModel> createBlockRenderers(class_5599 entityModelSet) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)BlockBlock.Types.STONE, (Object)new BlockModel(entityModelSet.method_32072(BBBModelLayers.STONE_BLOCK)));
        builder.put((Object)BlockBlock.Types.BLACKSTONE, (Object)new BlockModel(entityModelSet.method_32072(BBBModelLayers.BLACKSTONE_BLOCK)));
        builder.put((Object)BlockBlock.Types.DEEPSLATE, (Object)new BlockModel(entityModelSet.method_32072(BBBModelLayers.DEEPSLATE_BLOCK)));
        builder.put((Object)BlockBlock.Types.NETHER_BRICK, (Object)new BlockModel(entityModelSet.method_32072(BBBModelLayers.NETHER_BRICK_BLOCK)));
        builder.put((Object)BlockBlock.Types.SANDSTONE, (Object)new BlockModel(entityModelSet.method_32072(BBBModelLayers.SANDSTONE_BLOCK)));
        builder.put((Object)BlockBlock.Types.RED_SANDSTONE, (Object)new BlockModel(entityModelSet.method_32072(BBBModelLayers.RED_SANDSTONE_BLOCK)));
        builder.put((Object)BlockBlock.Types.QUARTZ, (Object)new BlockModel(entityModelSet.method_32072(BBBModelLayers.QUARTZ_BLOCK)));
        return builder.build();
    }

    public void render(BlockBlockEntity blockBlockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        float g = blockBlockEntity.getAnimation(f);
        class_2680 blockState = blockBlockEntity.method_11010();
        boolean bl = blockState.method_26204() instanceof WallBlockBlock;
        class_2350 direction = bl ? (class_2350)blockState.method_11654((class_2769)WallBlockBlock.FACING) : null;
        int k = bl ? class_7718.method_45481((class_2350)direction.method_10153()) : (Integer)blockState.method_11654((class_2769)BlockBlock.ROTATION);
        float h = class_7718.method_45482((int)k);
        BlockBlock.Type type = ((AbstractBlockBlock)blockState.method_26204()).getType();
        class_1921 renderType = class_1921.method_23576((class_2960)this.getTextureLocation(blockBlockEntity));
        BlockBlockRenderer.renderBlock(direction, h, g, poseStack, multiBufferSource, i, (BlockModel)((Object)this.modelByType.get((Object)type)), renderType);
    }

    private class_2960 getTextureLocation(BlockBlockEntity blockBlockEntity) {
        return TEXTURE_BY_TYPE.get(((AbstractBlockBlock)blockBlockEntity.method_11010().method_26204()).getType());
    }

    public static void renderBlock(@Nullable class_2350 direction, float f, float g, class_4587 poseStack, class_4597 multiBufferSource, int i, BlockModel blockModel, class_1921 renderType) {
        poseStack.method_22903();
        if (direction == null) {
            poseStack.method_46416(0.5f, 0.0f, 0.5f);
        } else {
            poseStack.method_46416(0.5f - (float)direction.method_10148() * 0.25f, 0.25f, 0.5f - (float)direction.method_10165() * 0.25f);
        }
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_46416(0.0f, -1.5f, 0.0f);
        class_4588 vertexConsumer = multiBufferSource.getBuffer(renderType);
        blockModel.method_2821(g, f, 0.0f);
        blockModel.method_2828(poseStack, vertexConsumer, i, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
    }
}

