/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.google.common.collect.Maps;
import com.starfish_studios.bbb.BBBConfig;
import com.starfish_studios.bbb.block.LayerBlock;
import com.starfish_studios.bbb.block.properties.BBBBlockStateProperties;
import com.starfish_studios.bbb.block.properties.FrameStickDirection;
import com.starfish_studios.bbb.registry.BBBTags;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class FrameBlock
extends class_2248
implements class_3737 {
    public static final class_2746 CORNERS = class_2746.method_11825((String)"corners");
    public static final class_2754<FrameStickDirection> FRAME_CENTER = BBBBlockStateProperties.FRAME_CENTER;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 TOP = BBBBlockStateProperties.TOP;
    public static final class_2746 BOTTOM = BBBBlockStateProperties.BOTTOM;
    public static final class_2746 LEFT = BBBBlockStateProperties.LEFT;
    public static final class_2746 RIGHT = BBBBlockStateProperties.RIGHT;
    private static final class_265 NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final class_265 WEST = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 NORTH_CENTER = class_2248.method_9541((double)4.0, (double)0.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_CENTER = class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0);
    private static final class_265 SOUTH_CENTER = class_2248.method_9541((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0);
    private static final class_265 WEST_CENTER = class_2248.method_9541((double)13.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final class_265 FALLBACK = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final class_265[] NORTH_SIDES = new class_265[]{class_2248.method_9541((double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)-1.0, (double)13.0, (double)16.0, (double)0.0, (double)16.0), class_2248.method_9541((double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0, (double)16.0)};
    private static final class_265[] EAST_SIDES = new class_265[]{class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)-1.0, (double)0.0, (double)3.0, (double)0.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0)};
    private static final class_265[] SOUTH_SIDES = new class_265[]{class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), class_2248.method_9541((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)3.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0), class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0)};
    private static final class_265[] WEST_SIDES = new class_265[]{class_2248.method_9541((double)13.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)13.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0), class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), class_2248.method_9541((double)13.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final Map<class_2350, class_265> FULL_SHAPES = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), m -> {
        m.put(class_2350.field_11043, NORTH);
        m.put(class_2350.field_11034, EAST);
        m.put(class_2350.field_11035, SOUTH);
        m.put(class_2350.field_11039, WEST);
    });
    private static final Map<class_2350, class_265> CENTER_SHAPES = Map.of(class_2350.field_11043, NORTH_CENTER, class_2350.field_11034, EAST_CENTER, class_2350.field_11035, SOUTH_CENTER, class_2350.field_11039, WEST_CENTER);
    private static final Map<class_2350, class_265[]> SIDE_SHAPES = Map.of(class_2350.field_11043, NORTH_SIDES, class_2350.field_11034, EAST_SIDES, class_2350.field_11035, SOUTH_SIDES, class_2350.field_11039, WEST_SIDES);
    private static final int TOP_INDEX = 0;
    private static final int BOTTOM_INDEX = 1;
    private static final int LEFT_INDEX = 2;
    private static final int RIGHT_INDEX = 3;

    public FrameBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TOP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BOTTOM, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)RIGHT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)CORNERS, (Comparable)Boolean.valueOf(true))).method_11657(FRAME_CENTER, (Comparable)((Object)FrameStickDirection.NONE)));
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (player.method_5998(hand).method_31573(BBBTags.BBBItemTags.HAMMERS)) {
            FrameStickDirection[] cycle = new FrameStickDirection[]{FrameStickDirection.LEFT, FrameStickDirection.VERTICAL, FrameStickDirection.RIGHT, FrameStickDirection.HORIZONTAL};
            FrameStickDirection current = (FrameStickDirection)((Object)state.method_11654(FRAME_CENTER));
            int index = Arrays.asList(cycle).indexOf((Object)current);
            FrameStickDirection next = cycle[(index + 1) % cycle.length];
            class_2680 updated = (class_2680)state.method_11657(FRAME_CENTER, (Comparable)((Object)next));
            level.method_8652(pos, updated, 3);
            if (state.method_26164(BBBTags.BBBBlockTags.WOODEN_FRAMES)) {
                level.method_8396(player, pos, class_2246.field_16492.method_9564().method_26231().method_10598(), player.method_5634(), 1.0f, 1.0f);
            } else if (state.method_26164(BBBTags.BBBBlockTags.STONE_FRAMES)) {
                level.method_8396(player, pos, class_2246.field_10340.method_9564().method_26231().method_10598(), player.method_5634(), 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9606(class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player) {
        if (state.method_11654(FRAME_CENTER) != FrameStickDirection.NONE) {
            class_2680 reset = (class_2680)state.method_11657(FRAME_CENTER, (Comparable)((Object)FrameStickDirection.NONE));
            level.method_8652(pos, reset, 3);
        }
    }

    private boolean showsFullOutline(class_3726 context, class_2680 state) {
        class_3727 ec;
        class_1297 class_12972;
        if (context instanceof class_3727 && (class_12972 = (ec = (class_3727)context).method_32480()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return player.method_24520(s -> s.method_31573(BBBTags.BBBItemTags.FRAMES) || s.method_31573(BBBTags.BBBItemTags.HAMMERS)) || player.method_5715() && !BBBConfig.disableFrameCrouchHitbox || BBBConfig.alwaysShowFrameHitboxes;
        }
        return false;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        if (this.showsFullOutline(context, state)) {
            return FULL_SHAPES.get(state.method_11654((class_2769)FACING));
        }
        class_265 shape = this.buildShape(state);
        if (shape.method_1110() && context == class_3726.method_16194()) {
            return FALLBACK;
        }
        return shape;
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return this.buildShape(state);
    }

    private class_265 buildShape(class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_265 shape = state.method_11654(FRAME_CENTER) != FrameStickDirection.NONE ? CENTER_SHAPES.get(facing) : class_259.method_1073();
        class_265[] parts = SIDE_SHAPES.get(facing);
        if (((Boolean)state.method_11654((class_2769)TOP)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)parts[0]);
        }
        if (((Boolean)state.method_11654((class_2769)BOTTOM)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)parts[1]);
        }
        if (((Boolean)state.method_11654((class_2769)LEFT)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)parts[2]);
        }
        if (((Boolean)state.method_11654((class_2769)RIGHT)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)parts[3]);
        }
        return shape;
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighbor, @NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return this.getConnectedState(state, level, pos);
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, TOP, BOTTOM, LEFT, RIGHT, CORNERS, FRAME_CENTER});
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public boolean method_9516(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_10 type) {
        return type == class_10.field_50 && (Boolean)state.method_11654((class_2769)TOP) == false && (Boolean)state.method_11654((class_2769)BOTTOM) == false && (Boolean)state.method_11654((class_2769)LEFT) == false && (Boolean)state.method_11654((class_2769)RIGHT) == false;
    }

    private class_2680 getConnectedState(class_2680 state, class_1936 level, class_2338 pos) {
        EnumMap<class_2350, Boolean> connections = new EnumMap<class_2350, Boolean>(class_2350.class);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        for (class_2350 direction : class_2350.values()) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = level.method_8320(neighborPos);
            boolean canConnect = neighborState.method_26204() instanceof FrameBlock ? neighborState.method_11654((class_2769)FACING) == facing : this.validConnection(neighborState, (class_1922)level, neighborPos, direction);
            connections.put(direction, canConnect);
        }
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)TOP, (Comparable)Boolean.valueOf((Boolean)connections.get(class_2350.field_11036) == false))).method_11657((class_2769)BOTTOM, (Comparable)Boolean.valueOf((Boolean)connections.get(class_2350.field_11033) == false))).method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf((Boolean)connections.get(facing.method_10170()) == false))).method_11657((class_2769)RIGHT, (Comparable)Boolean.valueOf((Boolean)connections.get(facing.method_10160()) == false));
    }

    public boolean validConnection(class_2680 state, class_1922 getter, class_2338 pos, class_2350 direction) {
        if (state.method_26204() instanceof LayerBlock) {
            class_2350 layerFacing = (class_2350)state.method_11654((class_2769)LayerBlock.FACING);
            return layerFacing == direction;
        }
        if (state.method_26204() instanceof class_2482) {
            class_2771 type = (class_2771)state.method_11654((class_2769)class_2482.field_11501);
            if (type == class_2771.field_12681 && direction == class_2350.field_11036) {
                return true;
            }
            return type == class_2771.field_12679 && direction == class_2350.field_11033;
        }
        if (state.method_26164(BBBTags.BBBBlockTags.FRAMES)) {
            return true;
        }
        return state.method_26216(getter, pos);
    }
}

