/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.bbb.block;

import com.starfish_studios.bbb.block.properties.BBBBlockStateProperties;
import com.starfish_studios.bbb.block.properties.ColumnType;
import com.starfish_studios.bbb.registry.BBBTags;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class ColumnBlock
extends class_2248
implements class_3737 {
    public static final class_2746 LAYER_1_AABB = BBBBlockStateProperties.LAYER_1;
    public static final class_2746 LAYER_2_AABB = BBBBlockStateProperties.LAYER_2;
    public static final class_2746 LAYER_3_AABB = BBBBlockStateProperties.LAYER_3;
    public static final class_2746 LAYER_4_AABB = BBBBlockStateProperties.LAYER_4;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;
    public static final class_2754<ColumnType> TYPE = BBBBlockStateProperties.COLUMN_TYPE;
    private static final Map<class_2350.class_2351, class_265> CENTER_AABB = new EnumMap<class_2350.class_2351, class_265>(class_2350.class_2351.class);
    private static final Map<class_2350.class_2351, class_265[]> LAYER_AABB = new EnumMap<class_2350.class_2351, class_265[]>(class_2350.class_2351.class);

    public ColumnBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(AXIS, (Comparable)class_2350.class_2351.field_11052)).method_11657(TYPE, (Comparable)((Object)ColumnType.NONE))).method_11657((class_2769)LAYER_1_AABB, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LAYER_2_AABB, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LAYER_3_AABB, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LAYER_4_AABB, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(AXIS, (Comparable)context.method_8038().method_10166())).method_11657(TYPE, (Comparable)((Object)ColumnType.NONE))).method_11657((class_2769)LAYER_1_AABB, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LAYER_2_AABB, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LAYER_3_AABB, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LAYER_4_AABB, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_39360((class_3611)class_3612.field_15910)));
        return ColumnBlock.removeWaterIfFull(state);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
        class_265 shape = CENTER_AABB.get(axis);
        class_265[] layers = LAYER_AABB.get(axis);
        if (((Boolean)state.method_11654((class_2769)LAYER_1_AABB)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)layers[0]);
        }
        if (((Boolean)state.method_11654((class_2769)LAYER_2_AABB)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)layers[1]);
        }
        if (((Boolean)state.method_11654((class_2769)LAYER_3_AABB)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)layers[2]);
        }
        if (((Boolean)state.method_11654((class_2769)LAYER_4_AABB)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)layers[3]);
        }
        return shape;
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, class_2350 direction, @NotNull class_2680 neighbor, @NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2338 neighborPos) {
        if (direction.method_10166() == state.method_11654(AXIS)) {
            class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
            class_2680 above = level.method_8320(pos.method_10093(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056)));
            class_2680 below = level.method_8320(pos.method_10093(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11060)));
            state = (class_2680)state.method_11657(TYPE, (Comparable)((Object)ColumnBlock.determineColumnType(state, above, below)));
        }
        if (((Boolean)(state = ColumnBlock.removeWaterIfFull(state)).method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return state;
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (!player.method_5998(hand).method_31573(BBBTags.BBBItemTags.HAMMERS)) {
            return class_1269.field_5811;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
        double hitFraction = hit.method_17784().method_18043(axis) - (double)pos.method_30558(axis);
        if (axis == class_2350.class_2351.field_11051) {
            hitFraction = 1.0 - hitFraction;
        }
        int layerIndex = Math.min(3, (int)(hitFraction * 4.0));
        class_2746[] layers = new class_2746[]{LAYER_1_AABB, LAYER_2_AABB, LAYER_3_AABB, LAYER_4_AABB};
        state = (class_2680)state.method_28493((class_2769)layers[layerIndex]);
        state = ColumnBlock.removeWaterIfFull(state);
        level.method_8652(pos, state, 3);
        level.method_8396(player, pos, state.method_26231().method_10598(), player.method_5634(), 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    public boolean method_10310(@NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3611 fluid) {
        return !ColumnBlock.isFull(state) && super.method_10310(level, pos, state, fluid);
    }

    public boolean method_10311(@NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3610 fluidState) {
        return !ColumnBlock.isFull(state) && super.method_10311(level, pos, state, fluidState);
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    private static boolean isFull(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LAYER_1_AABB) != false && (Boolean)state.method_11654((class_2769)LAYER_2_AABB) != false && (Boolean)state.method_11654((class_2769)LAYER_3_AABB) != false && (Boolean)state.method_11654((class_2769)LAYER_4_AABB) != false;
    }

    private static class_2680 removeWaterIfFull(class_2680 state) {
        return ColumnBlock.isFull(state) ? (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)) : state;
    }

    private static ColumnType determineColumnType(class_2680 state, class_2680 up, class_2680 down) {
        boolean connectsAbove = ColumnBlock.canConnect(state, up);
        boolean connectsBelow = ColumnBlock.canConnect(state, down);
        if (connectsAbove && !connectsBelow) {
            return ColumnType.BOTTOM;
        }
        if (!connectsAbove && connectsBelow) {
            return ColumnType.TOP;
        }
        if (connectsAbove) {
            return ColumnType.MIDDLE;
        }
        return ColumnType.NONE;
    }

    private static boolean canConnect(class_2680 state, class_2680 other) {
        boolean otherFull;
        if (!(other.method_26204() instanceof ColumnBlock)) {
            return false;
        }
        if (state.method_11654(AXIS) != other.method_11654(AXIS)) {
            return false;
        }
        boolean thisFull = ColumnBlock.isFull(state);
        return thisFull == (otherFull = ColumnBlock.isFull(other));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LAYER_1_AABB, LAYER_2_AABB, LAYER_3_AABB, LAYER_4_AABB, WATERLOGGED, AXIS, TYPE});
    }

    static {
        CENTER_AABB.put(class_2350.class_2351.field_11052, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        CENTER_AABB.put(class_2350.class_2351.field_11048, class_2248.method_9541((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        CENTER_AABB.put(class_2350.class_2351.field_11051, class_2248.method_9541((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
        LAYER_AABB.put(class_2350.class_2351.field_11052, new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), class_2248.method_9541((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        LAYER_AABB.put(class_2350.class_2351.field_11048, new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), class_2248.method_9541((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), class_2248.method_9541((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        LAYER_AABB.put(class_2350.class_2351.field_11051, new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)});
    }
}

