/*
 * Decompiled with CFR 0.152.
 */
package fuzs.horseexpert.client.handler;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.horseexpert.HorseExpert;
import fuzs.horseexpert.config.ClientConfig;
import fuzs.horseexpert.core.CommonAbstractions;
import fuzs.horseexpert.init.ModRegistry;
import fuzs.horseexpert.world.inventory.tooltip.HorseAttributeTooltip;
import fuzs.puzzleslib.api.client.screen.v2.TooltipRenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5134;
import net.minecraft.class_5632;
import net.minecraft.class_918;

public class AttributeOverlayHandler {
    public static void renderAttributeOverlay(class_310 minecraft, class_332 guiGraphics, float tickDelta, int screenWidth, int screenHeight) {
        AttributeOverlayHandler.isRenderingTooltipsAllowed(minecraft).ifPresent(abstractHorse -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AttributeOverlayHandler.actuallyRenderAttributeOverlay(guiGraphics, screenWidth, screenHeight, abstractHorse, minecraft.field_1772, minecraft.method_1480());
        });
    }

    private static Optional<class_1309> isRenderingTooltipsAllowed(class_310 minecraft) {
        block4: {
            class_1309 entity;
            block5: {
                class_1657 player;
                class_1297 class_12972;
                class_1297 class_12973;
                if (minecraft.field_1690.field_1842) {
                    return Optional.empty();
                }
                if (!minecraft.field_1690.method_31044().method_31034() || !((class_12973 = minecraft.field_1692) instanceof class_1309)) break block4;
                entity = (class_1309)class_12973;
                if (!minecraft.field_1692.method_5864().method_20210(ModRegistry.INSPECTABLE_ENTITY_TYPE_TAG) || minecraft.field_1761.method_2920() == class_1934.field_9219 || !((class_12972 = minecraft.field_1719) instanceof class_1657) || !CommonAbstractions.INSTANCE.findEquippedItem((class_1309)(player = (class_1657)class_12972), ModRegistry.INSPECTION_EQUIPMENT_ITEM_TAG).isPresent() || ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).requiresSneaking && !player.method_5715() || player.method_5854() == entity) break block4;
                if (!(entity instanceof class_1496)) break block5;
                class_1496 abstractHorse = (class_1496)entity;
                if (((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).mustBeTamed && !abstractHorse.method_6727()) break block4;
            }
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    private static void actuallyRenderAttributeOverlay(class_332 guiGraphics, int screenWidth, int screenHeight, class_1309 entity, class_327 font, class_918 itemRenderer) {
        List<HorseAttributeTooltip> tooltipComponents = AttributeOverlayHandler.buildTooltipComponents(entity);
        int posX = screenWidth / 2 - 12 + 22 + ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).offsetX;
        int posY = screenHeight / 2 + 15 - (tooltipComponents.size() * 29 - 3) / 2 + ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).offsetY;
        for (int i = 0; i < tooltipComponents.size(); ++i) {
            TooltipRenderHelper.renderTooltip((class_332)guiGraphics, (int)posX, (int)(posY + 29 * i), (class_2561)class_2561.method_43473(), (class_5632)tooltipComponents.get(i));
        }
    }

    private static List<HorseAttributeTooltip> buildTooltipComponents(class_1309 entity) {
        ArrayList tooltipComponents = Lists.newArrayList();
        if (entity.method_6127().method_27306(class_5134.field_23716)) {
            tooltipComponents.add(HorseAttributeTooltip.healthTooltip(entity.method_26825(class_5134.field_23716), entity instanceof class_1496));
        }
        if (!(entity instanceof class_1501) || ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).allLlamaAttributes) {
            if (entity.method_6127().method_27306(class_5134.field_23719)) {
                tooltipComponents.add(HorseAttributeTooltip.speedTooltip(entity.method_26825(class_5134.field_23719), entity instanceof class_1496));
            }
            if (entity.method_6127().method_27306(class_5134.field_23728)) {
                tooltipComponents.add(HorseAttributeTooltip.jumpHeightTooltip(entity.method_26825(class_5134.field_23728), entity instanceof class_1496));
            }
        }
        if (entity instanceof class_1501) {
            class_1501 llama = (class_1501)entity;
            tooltipComponents.add(HorseAttributeTooltip.strengthTooltip(llama.method_6803()));
        }
        return tooltipComponents;
    }
}

