/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.entity.BlazeEntityAccess;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.mixin.BlazeLivingEntityMixin;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1545;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1545.class})
public abstract class BlazeEntityMixin
extends BlazeLivingEntityMixin
implements BlazeEntityAccess {
    private static final String WILDFIRE_UUID_NBT_NAME = "WildfireUuid";
    private Optional<UUID> friendsandfoes_wildfireUuid = Optional.empty();

    protected BlazeEntityMixin(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public void friendsandfoes_writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        if (this.friendsandfoes_getWildfireUuid() != null) {
            nbt.method_25927(WILDFIRE_UUID_NBT_NAME, this.friendsandfoes_getWildfireUuid());
        }
    }

    @Override
    public void friendsandfoes_readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_25928(WILDFIRE_UUID_NBT_NAME)) {
            this.friendsandfoes_setWildfireUuid(nbt.method_25926(WILDFIRE_UUID_NBT_NAME));
        }
    }

    @Override
    public void friendsandfoes_onDeath(class_1282 damageSource, CallbackInfo ci) {
        WildfireEntity wildfireEntity;
        if (this.method_37908() instanceof class_3218 && (wildfireEntity = this.friendsandfoes_getWildfire()) != null) {
            wildfireEntity.setSummonedBlazesCount(wildfireEntity.getSummonedBlazesCount() - 1);
        }
    }

    @Nullable
    public UUID friendsandfoes_getWildfireUuid() {
        return this.friendsandfoes_wildfireUuid.orElse(null);
    }

    public void friendsandfoes_setWildfireUuid(@Nullable UUID uuid) {
        this.friendsandfoes_wildfireUuid = Optional.ofNullable(uuid);
    }

    @Override
    public void friendsandfoes_setWildfire(WildfireEntity wildfire) {
        this.friendsandfoes_setWildfireUuid(wildfire.method_5667());
    }

    @Override
    @Nullable
    public WildfireEntity friendsandfoes_getWildfire() {
        try {
            class_3218 serverWorld = (class_3218)this.method_37908();
            UUID uUID = this.friendsandfoes_getWildfireUuid();
            return uUID == null ? null : (WildfireEntity)serverWorld.method_14190(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }
}

