/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.satisfy.candlelight.registry.ObjectRegistry;
import net.satisfy.candlelight.util.CandlelightIdentifier;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SignedPaperGui
extends class_437 {
    public static final Contents EMPTY_PROVIDER = new Contents(){

        @Override
        public int getPageCount() {
            return 0;
        }

        @Override
        public class_5348 getPageUnchecked(int index) {
            return class_5348.field_25310;
        }
    };
    public static final class_2960 BOOK_TEXTURE = new CandlelightIdentifier("textures/gui/note_paper_gui.png");
    private final Contents contents;
    private int pageIndex;
    private List<class_5481> cachedPage = Collections.emptyList();
    private int cachedPageIndex = -1;

    public SignedPaperGui(Contents contents) {
        super(class_333.field_18967);
        this.contents = contents;
    }

    public boolean setPage(int index) {
        int i = class_3532.method_15340((int)index, (int)0, (int)(this.contents.getPageCount() - 1));
        if (i != this.pageIndex) {
            this.pageIndex = i;
            this.cachedPageIndex = -1;
            return true;
        }
        return false;
    }

    protected boolean jumpToPage(int page) {
        return this.setPage(page);
    }

    protected void method_25426() {
        this.addCloseButton();
    }

    protected void addCloseButton() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(null);
        }).method_46434(this.field_22789 / 2 - 100, 196, 200, 20).method_46431());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        int i = (this.field_22789 - 192) / 2;
        guiGraphics.method_25302(BOOK_TEXTURE, i, 2, 0, 0, 192, 192);
        if (this.cachedPageIndex != this.pageIndex) {
            class_5348 stringVisitable = this.contents.getPage(this.pageIndex);
            this.cachedPage = this.field_22793.method_1728(stringVisitable, 114);
        }
        this.cachedPageIndex = this.pageIndex;
        Objects.requireNonNull(this.field_22793);
        int l = Math.min(14, this.cachedPage.size());
        for (int m = 0; m < l; ++m) {
            class_5481 orderedText = this.cachedPage.get(m);
            int var10003 = i + 36;
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51430(this.field_22793, orderedText, var10003, 32 + m * 9, 0, false);
        }
        class_2583 style = this.getTextStyleAt(mouseX, mouseY);
        if (style != null) {
            guiGraphics.method_51441(this.field_22793, style, mouseX, mouseY);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_2583 style;
        if (button == 0 && (style = this.getTextStyleAt(mouseX, mouseY)) != null && this.method_25430(style)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25430(class_2583 style) {
        assert (style != null);
        class_2558 clickEvent = style.method_10970();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
            String string = clickEvent.method_10844();
            try {
                int i = Integer.parseInt(string) - 1;
                return this.jumpToPage(i);
            }
            catch (Exception var5) {
                return false;
            }
        }
        boolean bl = super.method_25430(style);
        if (bl && clickEvent.method_10845() == class_2558.class_2559.field_11750) {
            this.closeScreen();
        }
        return bl;
    }

    protected void closeScreen() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(null);
    }

    @Nullable
    public class_2583 getTextStyleAt(double x, double y) {
        if (this.cachedPage.isEmpty()) {
            return null;
        }
        int i = class_3532.method_15357((double)(x - (double)((this.field_22789 - 192) / 2) - 36.0));
        int j = class_3532.method_15357((double)(y - 2.0 - 30.0));
        if (i >= 0 && j >= 0) {
            Objects.requireNonNull(this.field_22793);
            int k = Math.min(14, this.cachedPage.size());
            if (i <= 114) {
                Objects.requireNonNull(this.field_22787.field_1772);
                if (j < 9 * k + k) {
                    Objects.requireNonNull(this.field_22787.field_1772);
                    int l = j / 9;
                    if (l < this.cachedPage.size()) {
                        class_5481 orderedText = this.cachedPage.get(l);
                        return this.field_22787.field_1772.method_27527().method_30876(orderedText, i);
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    static List<String> readPages(class_2487 nbt) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        SignedPaperGui.filterPages(nbt, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void filterPages(class_2487 nbt, Consumer<String> pageConsumer) {
        IntFunction<Object> intFunction;
        class_2499 nbtList = nbt.method_10554("text", 8).method_10612();
        if (class_310.method_1551().method_33883() && nbt.method_10573("filtered_pages", 10)) {
            class_2487 nbtCompound = nbt.method_10562("filtered_pages");
            intFunction = page -> {
                String string = String.valueOf(page);
                return nbtCompound.method_10545(string) ? nbtCompound.method_10558(string) : nbtList.method_10608(page);
            };
        } else {
            Objects.requireNonNull(nbtList);
            intFunction = arg_0 -> ((class_2499)nbtList).method_10608(arg_0);
        }
        for (int i = 0; i < nbtList.size(); ++i) {
            pageConsumer.accept((String)intFunction.apply(i));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Contents {
        public int getPageCount();

        public class_5348 getPageUnchecked(int var1);

        default public class_5348 getPage(int index) {
            return index >= 0 && index < this.getPageCount() ? this.getPageUnchecked(index) : class_5348.field_25310;
        }

        public static Contents create(class_1799 stack) {
            if (stack.method_31574((class_1792)ObjectRegistry.NOTE_PAPER_WRITEABLE.get())) {
                return new WrittenPaperContents(stack);
            }
            return stack.method_31574((class_1792)ObjectRegistry.NOTE_PAPER_WRITEABLE.get()) ? new WritablePaperContents(stack) : EMPTY_PROVIDER;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class WrittenPaperContents
    implements Contents {
        private final List<String> pages;

        public WrittenPaperContents(class_1799 stack) {
            this.pages = WrittenPaperContents.getPages(stack);
        }

        private static List<String> getPages(class_1799 stack) {
            class_2487 nbtCompound = stack.method_7969();
            return WrittenPaperContents.makeSureTagIsValid(nbtCompound) ? SignedPaperGui.readPages(nbtCompound) : ImmutableList.of((Object)class_2561.class_2562.method_10867((class_2561)class_2561.method_43471((String)"book.invalid.tag").method_27692(class_124.field_1079)));
        }

        private static boolean makeSureTagIsValid(class_2487 nbtCompound) {
            if (nbtCompound == null) {
                return false;
            }
            if (!nbtCompound.method_10573("text", 9)) {
                return false;
            }
            class_2499 listTag = nbtCompound.method_10554("text", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                String string = listTag.method_10608(i);
                if (string.length() <= Short.MAX_VALUE) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        public class_5348 getPageUnchecked(int index) {
            String string = this.pages.get(index);
            try {
                class_5250 stringVisitable = class_2561.class_2562.method_10877((String)string);
                if (stringVisitable != null) {
                    return stringVisitable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return class_5348.method_29430((String)string);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class WritablePaperContents
    implements Contents {
        private final List<String> pages;

        public WritablePaperContents(class_1799 stack) {
            this.pages = WritablePaperContents.getPages(stack);
        }

        private static List<String> getPages(class_1799 stack) {
            class_2487 nbtCompound = stack.method_7969();
            return nbtCompound != null ? SignedPaperGui.readPages(nbtCompound) : ImmutableList.of();
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        public class_5348 getPageUnchecked(int index) {
            return class_5348.method_29430((String)this.pages.get(index));
        }
    }
}

