/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbessentials.FTBEssentialsEvents;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DimensionFilter;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2191;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class TeleportCommands {
    public static final class_6862<class_2248> IGNORE_RTP_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("ftbessentials", "ignore_rtp"));
    public static final class_6862<class_1959> IGNORE_RTP_BIOMES = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("ftbessentials", "ignore_rtp"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.BACK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"back").requires((Predicate)FTBEConfig.BACK)).executes(context -> TeleportCommands.back(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.SPAWN.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").requires((Predicate)FTBEConfig.SPAWN)).executes(context -> TeleportCommands.spawn(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.RTP.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rtp").requires((Predicate)FTBEConfig.RTP)).executes(context -> TeleportCommands.rtp(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.TPL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport_last").requires(FTBEConfig.TPL.enabledAndOp())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(context -> TeleportCommands.tpLast(((class_2168)context.getSource()).method_9207(), (GameProfile)class_2191.method_9330((CommandContext)context, (String)"player").iterator().next()))));
        }
        if (FTBEConfig.TPX.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpx").requires(FTBEConfig.TPX.enabledAndOp())).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> TeleportCommands.tpx(((class_2168)context.getSource()).method_9207(), class_2181.method_9289((CommandContext)context, (String)"dimension")))));
        }
        if (FTBEConfig.JUMP.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"jump").requires(FTBEConfig.JUMP.enabledAndOp())).executes(ctx -> TeleportCommands.jump((class_2168)ctx.getSource())));
        }
    }

    private static int jump(class_2168 source) {
        try {
            class_1937 level;
            class_3222 player = source.method_9207();
            class_3965 res = BlockUtil.getFocusedBlock(player, player.method_5682().method_3760().method_14568() * 16).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            class_2338.class_2339 mPos = res.method_17777().method_10084().method_25503();
            while (!(TeleportCommands.isEmptyShape(level = player.method_37908(), mPos.method_10084()) && TeleportCommands.isEmptyShape(level, mPos.method_10086(2)) || mPos.method_10264() >= level.method_31600())) {
                mPos.method_10104(class_2350.field_11036, 2);
            }
            class_243 vec = class_243.method_24955((class_2382)mPos);
            player.method_5859(vec.method_10216(), vec.method_10214(), vec.method_10215());
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Can't jump: " + e.getMessage())));
        }
        return 0;
    }

    private static boolean isEmptyShape(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26220((class_1922)level, pos).method_1110();
    }

    public static int back(class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            if (data.teleportHistory.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Teleportation history is empty!").method_27692(class_124.field_1061), false);
                return 0;
            }
            if (data.backTeleporter.teleport(player, serverPlayerEntity -> data.teleportHistory.getLast()).runCommand(player) != 0) {
                data.markDirty();
                return 1;
            }
            return 0;
        }).orElse(0);
    }

    public static int spawn(class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            class_3218 level = player.field_13995.method_3847(player.method_26281());
            if (level == null) {
                return 0;
            }
            class_2338 pos = Objects.requireNonNullElse(player.method_26280(), level.method_43126());
            return data.spawnTeleporter.teleport(player, p -> new TeleportPos((class_1937)level, pos, Float.valueOf(player.method_30631()), Float.valueOf(0.0f))).runCommand(player);
        }).orElse(0);
    }

    public static int rtp(class_3222 player) {
        if (!player.method_5687(2) && !DimensionFilter.isDimensionOK((class_5321<class_1937>)player.method_37908().method_27983())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You may not use /rtp in this dimension!").method_27692(class_124.field_1061), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> data.rtpTeleporter.teleport(player, p -> {
            p.method_7353((class_2561)class_2561.method_43470((String)"Looking for random location..."), false);
            return TeleportCommands.findBlockPos((class_3218)player.method_37908(), p);
        }).runCommand(player)).orElse(0);
    }

    private static TeleportPos findBlockPos(class_3218 world, class_3222 player) {
        for (int attempt = 0; attempt < (Integer)FTBEConfig.RTP_MAX_TRIES.get(); ++attempt) {
            EventResult res;
            double dist = (double)((Integer)FTBEConfig.RTP_MIN_DISTANCE.get()).intValue() + world.field_9229.method_43058() * (double)((Integer)FTBEConfig.RTP_MAX_DISTANCE.get() - (Integer)FTBEConfig.RTP_MIN_DISTANCE.get());
            double angle = world.field_9229.method_43058() * Math.PI * 2.0;
            int x = class_3532.method_15357((double)(Math.cos(angle) * dist));
            int y = 256;
            int z = class_3532.method_15357((double)(Math.sin(angle) * dist));
            class_2338 currentPos = new class_2338(x, y, z);
            if (!world.method_8621().method_11952(currentPos) || world.method_23753(currentPos).method_40220(IGNORE_RTP_BIOMES) || (res = ((FTBEssentialsEvents.RTP)FTBEssentialsEvents.RTP_EVENT.invoker()).teleport(world, player, currentPos, attempt)).isFalse()) continue;
            world.method_8500(currentPos);
            class_2338 hmPos = world.method_8598(class_2902.class_2903.field_13203, currentPos);
            if (hmPos.method_10264() <= 0) continue;
            class_2338 goodPos = null;
            if (hmPos.method_10264() < world.method_32819()) {
                goodPos = hmPos;
            } else {
                for (class_2338 newPos : class_2338.method_30512((class_2338)new class_2338(hmPos.method_10263(), world.method_8615(), hmPos.method_10260()), (int)16, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
                    class_2680 bs = world.method_8320(newPos);
                    if (!bs.method_51366() || bs.method_26164(IGNORE_RTP_BLOCKS) || !world.method_22347(newPos.method_10086(1)) || !world.method_22347(newPos.method_10086(2)) || !world.method_22347(newPos.method_10086(3))) continue;
                    goodPos = newPos;
                }
            }
            if (goodPos == null) continue;
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("Found good location after %d " + (attempt == 1 ? "attempt" : "attempts") + " @ [x %d, z %d]", attempt, goodPos.method_10263(), goodPos.method_10260())), false);
            return new TeleportPos((class_5321<class_1937>)world.method_27983(), goodPos.method_10084());
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"Could not find a valid location to teleport to!").method_27692(class_124.field_1061), false);
        return new TeleportPos((class_1297)player);
    }

    public static int tpLast(class_3222 player, GameProfile to) {
        class_3222 toPlayer = player.field_13995.method_3760().method_14602(to.getId());
        if (toPlayer != null) {
            FTBEPlayerData.addTeleportHistory(player);
            new TeleportPos((class_1297)toPlayer).teleport(player);
            return 1;
        }
        return FTBEPlayerData.getOrCreate(to).map(dataTo -> {
            FTBEPlayerData.addTeleportHistory(player);
            dataTo.getLastSeenPos().teleport(player);
            return 1;
        }).orElse(0);
    }

    public static int tpx(class_3222 player, class_3218 to) {
        player.method_14251(to, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        return 1;
    }
}

