/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.FTBEssentialsPlatform;
import dev.ftb.mods.ftbessentials.command.FTBEssentialsCommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.OtherPlayerInventory;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_156;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5134;
import net.minecraft.class_5218;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class CheatCommands {
    private static final UUID ESSENTIALS_SPEED_UUID = UUID.fromString("3a8a9187-94ab-4272-99c0-ca764a19f8f1");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.HEAL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"heal").requires(FTBEConfig.HEAL.enabledAndOp())).executes(context -> CheatCommands.heal(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.heal(class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.FEED.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"feed").requires(FTBEConfig.FEED.enabledAndOp())).executes(context -> CheatCommands.feed(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.feed(class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.EXTINGUISH.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"extinguish").requires(FTBEConfig.EXTINGUISH.enabledAndOp())).executes(context -> CheatCommands.extinguish(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.extinguish(class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.FLY.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fly").requires(FTBEConfig.FLY.enabledAndOp())).executes(context -> CheatCommands.fly(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.fly(class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.SPEED.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"speed").executes(context -> CheatCommands.speed((class_2168)context.getSource(), class_5134.field_23719, ((class_2168)context.getSource()).method_9207()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"boost_percent", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)2000)).requires(FTBEConfig.SPEED.enabledAndOp())).executes(context -> CheatCommands.speed((class_2168)context.getSource(), class_5134.field_23719, ((class_2168)context.getSource()).method_9207(), IntegerArgumentType.getInteger((CommandContext)context, (String)"boost_percent")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.speed((class_2168)context.getSource(), class_5134.field_23719, class_2186.method_9315((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"boost_percent"))))));
        }
        if (FTBEConfig.GOD.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"god").requires(FTBEConfig.GOD.enabledAndOp())).executes(context -> CheatCommands.god(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.god(class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.INVSEE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"invsee").requires(FTBEConfig.INVSEE.enabledAndOp())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.viewInventory(((class_2168)context.getSource()).method_9207(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.NICK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nicknamefor").requires(FTBEConfig.NICK.enabledAndOp())).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(context -> CheatCommands.nicknameFor((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), ""))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.method_9259(2))).executes(context -> CheatCommands.nicknameFor((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"nickname"))))));
        }
        if (FTBEConfig.MUTE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mute").requires(FTBEConfig.MUTE.enabledAndOp())).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.mute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), ""))).then(class_2170.method_9244((String)"until", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> FTBEssentialsCommands.suggestDurations(builder)).executes(context -> CheatCommands.mute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"until"))))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unmute").requires(FTBEConfig.MUTE.enabledAndOp())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> CheatCommands.unmute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.TP_OFFLINE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tp_offline").requires(FTBEConfig.TP_OFFLINE.enabledAndOp())).then(class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(ctx -> CheatCommands.tpOffline((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), ((class_2168)ctx.getSource()).method_9225(), class_2277.method_9734((CommandContext)ctx, (String)"pos"))))))).then(class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"player_id", (ArgumentType)class_5242.method_27643()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(ctx -> CheatCommands.tpOffline((class_2168)ctx.getSource(), class_5242.method_27645((CommandContext)ctx, (String)"player_id"), ((class_2168)ctx.getSource()).method_9225(), class_2277.method_9734((CommandContext)ctx, (String)"pos")))))));
        }
    }

    private static int speed(class_2168 source, class_1320 attr, class_3222 player) {
        class_1324 attrInstance = player.method_5996(attr);
        CheatCommands.showSpeed(source, player, attrInstance);
        return 1;
    }

    private static int speed(class_2168 source, class_1320 attr, class_3222 target, int boostPct) {
        class_1324 attrInstance = target.method_5996(attr);
        if (attrInstance != null) {
            float speedMult = (float)boostPct / 100.0f;
            attrInstance.method_6200(ESSENTIALS_SPEED_UUID);
            if (speedMult != 0.0f) {
                attrInstance.method_26837(new class_1322(ESSENTIALS_SPEED_UUID, "FTB Essentials speed boost", (double)speedMult, class_1322.class_1323.field_6330));
            }
            CheatCommands.showSpeed(source, target, attrInstance);
        }
        return 1;
    }

    private static void showSpeed(class_2168 source, class_3222 target, class_1324 attrInstance) {
        class_5250 msg;
        if (attrInstance != null && attrInstance.method_6199(ESSENTIALS_SPEED_UUID) != null) {
            double speedMult = attrInstance.method_6199(ESSENTIALS_SPEED_UUID).method_6186();
            int boostPct = (int)(speedMult * 100.0);
            msg = class_2561.method_43470((String)"Speed boost for ").method_10852(target.method_5476()).method_27693(" (").method_10852((class_2561)class_2561.method_43471((String)attrInstance.method_6198().method_26830())).method_27693(") = " + boostPct + "%");
        } else {
            msg = class_2561.method_43470((String)"No speed boost for ").method_10852(target.method_5476());
        }
        source.method_9226(() -> CheatCommands.lambda$showSpeed$24((class_2561)msg), false);
        if (!source.method_43737() || source.method_44023() != target) {
            target.method_7353((class_2561)msg, false);
        }
    }

    public static int heal(class_3222 player) {
        player.method_6033(player.method_6063());
        player.method_7344().method_7585(40, 40.0f);
        player.method_5646();
        FTBEssentialsPlatform.curePotionEffects(player);
        return 1;
    }

    public static int feed(class_3222 player) {
        player.method_7344().method_7585(40, 40.0f);
        return 1;
    }

    public static int extinguish(class_3222 player) {
        player.method_5646();
        return 1;
    }

    public static int fly(class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            class_1656 abilities = player.method_31549();
            if (data.canFly()) {
                data.setCanFly(false);
                abilities.field_7478 = false;
                abilities.field_7479 = false;
                player.method_7353((class_2561)class_2561.method_43470((String)"Flight disabled"), true);
            } else {
                data.setCanFly(true);
                abilities.field_7478 = true;
                player.method_7353((class_2561)class_2561.method_43470((String)"Flight enabled"), true);
            }
            player.method_7355();
            return 1;
        }).orElse(0);
    }

    public static int god(class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            class_1656 abilities = player.method_31549();
            if (data.isGod()) {
                data.setGod(false);
                abilities.field_7480 = false;
                player.method_7353((class_2561)class_2561.method_43470((String)"God mode disabled"), true);
            } else {
                data.setGod(true);
                abilities.field_7480 = true;
                player.method_7353((class_2561)class_2561.method_43470((String)"God mode enabled"), true);
            }
            player.method_7355();
            return 1;
        }).orElse(0);
    }

    public static int viewInventory(class_3222 source, final class_3222 player) {
        source.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return player.method_5476();
            }

            public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 p) {
                return new class_1707(class_3917.field_18667, id, playerInventory, (class_1263)new OtherPlayerInventory(player), 5);
            }
        });
        return 1;
    }

    public static int nicknameFor(class_2168 source, class_3222 player, String nick) {
        if (nick.length() > 30) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Nickname too long!"), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            data.setNick(nick.trim());
            data.markDirty();
            PlayerDisplayNameUtil.refreshDisplayName((class_1657)player);
            if (data.getNick().isEmpty()) {
                source.method_9226(() -> class_2561.method_43470((String)"Nickname reset!"), true);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)("Nickname changed to '" + data.getNick() + "'")), true);
            }
            data.sendTabName(source.method_9211());
            return 1;
        }).orElse(0);
    }

    public static int mute(class_2168 source, class_3222 player, String duration) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            try {
                DurationInfo info = DurationInfo.fromString(duration);
                data.setMuted(true);
                FTBEWorldData.instance.setMuteTimeout(player, info.until());
                class_5250 msg = player.method_5476().method_27661().method_27693(" has been muted by ").method_10852(source.method_9223()).method_27693(", ").method_27693(info.desc());
                CheatCommands.notifyMuting(source, (class_1657)player, (class_2561)msg);
                return 1;
            }
            catch (IllegalArgumentException e) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Invalid duration syntax: '" + duration + "': " + e.getMessage())));
                return 0;
            }
        }).orElse(0);
    }

    public static int unmute(class_2168 source, class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            data.setMuted(false);
            FTBEWorldData.instance.setMuteTimeout(player, -1L);
            class_5250 msg = player.method_5476().method_27661().method_27693(" has been unmuted by ").method_10852(source.method_9223());
            CheatCommands.notifyMuting(source, (class_1657)player, (class_2561)msg);
            return 1;
        }).orElse(0);
    }

    private static void notifyMuting(class_2168 source, class_1657 target, class_2561 msg) {
        source.method_9211().method_3760().method_14571().forEach(p -> {
            if (p.method_5687(2) || p == target) {
                p.method_7353(msg, false);
            }
        });
        if (!source.method_43737()) {
            source.method_9226(() -> msg, true);
        }
    }

    private static int tpOffline(class_2168 source, String playerName, class_3218 level, class_2267 dest) {
        source.method_9211().method_3793().method_37156(playerName, profileOpt -> source.method_9211().method_40000(() -> profileOpt.ifPresentOrElse(profile -> CheatCommands.tpOffline(source, profile.getId(), level, dest), () -> source.method_9213((class_2561)class_2561.method_43470((String)("Unknown player: " + playerName))))));
        return 1;
    }

    private static int tpOffline(class_2168 source, UUID playerId, class_3218 level, class_2267 dest) {
        MinecraftServer server = source.method_9211();
        Path playerDir = server.method_27050(class_5218.field_24182);
        File datFile = playerDir.resolve(String.valueOf(playerId) + ".dat").toFile();
        if (server.method_3760().method_14602(playerId) != null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Player is online! Use regular /tp command instead"));
            return 0;
        }
        try {
            class_2487 tag = class_2507.method_30613((File)datFile);
            class_243 vec = dest.method_9708(source);
            class_2499 newPos = new class_2499();
            newPos.add((Object)class_2489.method_23241((double)vec.field_1352));
            newPos.add((Object)class_2489.method_23241((double)vec.field_1351));
            newPos.add((Object)class_2489.method_23241((double)vec.field_1350));
            tag.method_10566("Pos", (class_2520)newPos);
            tag.method_10582("Dimension", level.method_27983().method_29177().toString());
            File tempFile = File.createTempFile(String.valueOf(playerId) + "-", ".dat", playerDir.toFile());
            class_2507.method_30614((class_2487)tag, (File)tempFile);
            File backupFile = new File(playerDir.toFile(), String.valueOf(playerId) + ".dat_old");
            class_156.method_27760((File)datFile, (File)tempFile, (File)backupFile);
            source.method_9226(() -> class_2561.method_43470((String)String.format("Offline player %s moved to [%.2f,%.2f,%.2f] in %s", playerId, vec.field_1352, vec.field_1351, vec.field_1350, source.method_9225().method_27983().method_29177())), false);
            return 1;
        }
        catch (IOException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Can't update dat file: " + e.getMessage())));
            return 0;
        }
    }

    private static /* synthetic */ class_2561 lambda$showSpeed$24(class_2561 msg) {
        return msg;
    }
}

