/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.satisfy.vinery.platform.PlatformHelper;

public class WineYears {
    public static final int YEARS_START = 0;
    public static final int MAX_LEVEL = PlatformHelper.getWineMaxLevel();
    public static final int START_DURATION = PlatformHelper.getWineStartDuration();
    public static final int DURATION_PER_YEAR = PlatformHelper.getWineDurationPerYear();
    public static final int DAYS_PER_YEAR = PlatformHelper.getWineDaysPerYear();
    public static final int YEARS_PER_EFFECT_LEVEL = PlatformHelper.getWineYearsPerEffectLevel();
    public static final int MAX_DURATION = PlatformHelper.getWineMaxDuration();
    public static final String TAG_YEAR = "Year";
    public static final String TAG_EFFECT_LEVEL = "EffectAmplifier";
    public static final String TAG_EFFECT_DURATION = "EffectDuration";

    public static int getYear(class_1937 world) {
        return world != null ? 0 + (int)(world.method_8510() / 24000L / (long)DAYS_PER_YEAR) : 0;
    }

    public static int getDays(class_1937 world) {
        return world != null ? (int)(world.method_8510() / 24000L) : 0;
    }

    public static int getWineAge(class_1799 wine, class_1937 world) {
        int y = WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0;
        return Math.max(0, WineYears.getYear(world) - y);
    }

    public static int getWineAgeDays(class_1799 wine, class_1937 world) {
        int y = WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0;
        return Math.max(0, WineYears.getDays(world) - y * DAYS_PER_YEAR);
    }

    public static int getEffectLevel(class_1799 wine, class_1937 world) {
        int age = WineYears.getWineAge(wine, world);
        return Math.max(0, Math.min(MAX_LEVEL, YEARS_PER_EFFECT_LEVEL > 0 ? age / YEARS_PER_EFFECT_LEVEL : 0));
    }

    public static int getEffectDuration(class_1799 wine, class_1937 world) {
        int age = WineYears.getWineAge(wine, world);
        return Math.min(MAX_DURATION, Math.max(0, START_DURATION + DURATION_PER_YEAR * age));
    }

    public static void setWineYear(class_1799 wine, class_1937 world) {
        int year = world != null ? WineYears.getYear(world) : 0;
        wine.method_7948().method_10569(TAG_YEAR, year);
        WineYears.refreshCached(wine, world);
    }

    public static void refreshCached(class_1799 wine, class_1937 world) {
        int amplifier = WineYears.getEffectLevel(wine, world);
        int duration = WineYears.getEffectDuration(wine, world);
        class_2487 tag = wine.method_7948();
        tag.method_10569(TAG_EFFECT_LEVEL, amplifier);
        tag.method_10569(TAG_EFFECT_DURATION, duration);
    }

    public static int getWineYear(class_1799 wine) {
        return wine.method_7948().method_10550(TAG_YEAR);
    }

    public static boolean hasWineYear(class_1799 wine) {
        return wine.method_7948().method_10545(TAG_YEAR);
    }
}

