/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.TagRegistry;

public class JuiceUtil {
    public static final Map<class_6862<class_1792>, String> RED_JUICE_TAGS = new HashMap<class_6862<class_1792>, String>();
    public static final Map<class_6862<class_1792>, String> WHITE_JUICE_TAGS = new HashMap<class_6862<class_1792>, String>();
    public static final Map<class_1792, String> APPLE_JUICES = new HashMap<class_1792, String>();

    private static void addRedJuice(class_6862<class_1792> tag, String region) {
        RED_JUICE_TAGS.put(tag, region);
    }

    private static void addWhiteJuice(class_6862<class_1792> tag, String region) {
        WHITE_JUICE_TAGS.put(tag, region);
    }

    private static void addAppleJuice(class_1792 item) {
        APPLE_JUICES.put(item, "apple");
    }

    public static boolean isJuice(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return JuiceUtil.isRedJuice(stack) || JuiceUtil.isWhiteJuice(stack) || JuiceUtil.isAppleJuice(stack);
    }

    private static boolean isRedJuice(class_1799 stack) {
        for (class_6862<class_1792> tag : RED_JUICE_TAGS.keySet()) {
            if (!stack.method_31573(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhiteJuice(class_1799 stack) {
        for (class_6862<class_1792> tag : WHITE_JUICE_TAGS.keySet()) {
            if (!stack.method_31573(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAppleJuice(class_1799 stack) {
        return APPLE_JUICES.containsKey(stack.method_7909());
    }

    public static String getJuiceType(class_1799 stack) {
        if (!JuiceUtil.isJuice(stack)) {
            return "";
        }
        for (Map.Entry<class_6862<class_1792>, String> entry : RED_JUICE_TAGS.entrySet()) {
            if (!stack.method_31573(entry.getKey())) continue;
            return "red_" + entry.getValue();
        }
        for (Map.Entry<class_6862<class_1792>, String> entry : WHITE_JUICE_TAGS.entrySet()) {
            if (!stack.method_31573(entry.getKey())) continue;
            return "white_" + entry.getValue();
        }
        String region = APPLE_JUICES.get(stack.method_7909());
        if (region != null) {
            return region;
        }
        return "";
    }

    static {
        JuiceUtil.addRedJuice(TagRegistry.RED_GRAPEJUICE, "general");
        JuiceUtil.addRedJuice(TagRegistry.RED_SAVANNA_GRAPEJUICE, "savanna");
        JuiceUtil.addRedJuice(TagRegistry.RED_TAIGA_GRAPEJUICE, "taiga");
        JuiceUtil.addRedJuice(TagRegistry.RED_JUNGLE_GRAPEJUICE, "jungle");
        JuiceUtil.addRedJuice(TagRegistry.CRIMSON_GRAPEJUICE, "crimson");
        JuiceUtil.addWhiteJuice(TagRegistry.WHITE_GRAPEJUICE, "general");
        JuiceUtil.addWhiteJuice(TagRegistry.WHITE_SAVANNA_GRAPEJUICE, "savanna");
        JuiceUtil.addWhiteJuice(TagRegistry.WHITE_TAIGA_GRAPEJUICE, "taiga");
        JuiceUtil.addWhiteJuice(TagRegistry.WHITE_JUNGLE_GRAPEJUICE, "jungle");
        JuiceUtil.addWhiteJuice(TagRegistry.WARPED_GRAPEJUICE, "warped");
        JuiceUtil.addAppleJuice((class_1792)ObjectRegistry.APPLE_JUICE.get());
    }
}

