/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3542;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class GrapeType
implements Comparable<GrapeType>,
class_3542 {
    private final String id;
    private final boolean lattice;
    private final boolean red;
    private Supplier<class_1792> fruit;
    private Supplier<class_1792> seeds;
    private Supplier<class_1792> bottle;

    public GrapeType(String id, boolean lattice, boolean red) {
        this(id, () -> class_1802.field_8162, () -> class_1802.field_8162, () -> class_1802.field_8162, lattice, red);
    }

    private GrapeType(String id, Supplier<class_1792> fruit, Supplier<class_1792> seeds, Supplier<class_1792> bottle, boolean lattice, boolean red) {
        this.id = id;
        this.fruit = fruit;
        this.seeds = seeds;
        this.bottle = bottle;
        this.lattice = lattice;
        this.red = red;
    }

    public static GrapeType fromString(String id) {
        for (GrapeType type : GrapeTypeRegistry.GRAPE_TYPE_TYPES) {
            if (!type.method_15434().equals(id)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public String method_15434() {
        return this.id;
    }

    public class_1792 getFruit() {
        return this.fruit.get();
    }

    public class_1792 getSeeds() {
        return this.seeds.get();
    }

    public class_1792 getBottle() {
        return this.bottle.get();
    }

    public boolean isLattice() {
        return this.lattice;
    }

    public boolean isRed() {
        return this.red;
    }

    public boolean isWhite() {
        return !this.red;
    }

    public void setItems(Supplier<class_1792> fruit, Supplier<class_1792> seeds, Supplier<class_1792> bottle) {
        this.fruit = fruit;
        this.seeds = seeds;
        this.bottle = bottle;
    }

    @Override
    public int compareTo(@NotNull GrapeType grapeType) {
        return this.id.compareTo(grapeType.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrapeType)) {
            return false;
        }
        GrapeType grapeType = (GrapeType)o;
        return Objects.equals(this.id, grapeType.id);
    }
}

