/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.satisfy.vinery.core.entity.ChairEntity;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class GeneralUtil {
    public static final class_2754<LineConnectingType> LINE_CONNECTING_TYPE = class_2754.method_11850((String)"type", LineConnectingType.class);
    private static final Map<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>> CHAIRS = new HashMap<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>>();

    public static class_2465 logBlock() {
        return new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10431));
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithItem(DeferredRegister<class_2248> registerB, Registrar<class_2248> registrarB, DeferredRegister<class_1792> registerI, Registrar<class_1792> registrarI, class_2960 name, Supplier<T> block) {
        RegistrySupplier toReturn = GeneralUtil.registerWithoutItem(registerB, registrarB, name, block);
        GeneralUtil.registerItem(registerI, registrarI, name, () -> new class_1747((class_2248)toReturn.get(), new class_1792.class_1793()));
        return toReturn;
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithoutItem(DeferredRegister<class_2248> register, Registrar<class_2248> registrar, class_2960 path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.method_12832(), block) : registrar.register(path, block);
    }

    public static <T extends class_1792> RegistrySupplier<T> registerItem(DeferredRegister<class_1792> register, Registrar<class_1792> registrar, class_2960 path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.method_12832(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static Collection<class_3222> tracking(class_3218 world, class_1923 pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.method_14178().field_17254.method_17210(pos, false);
    }

    public static Collection<class_3222> tracking(class_3218 world, class_2338 pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return GeneralUtil.tracking(world, new class_1923(pos));
    }

    public static void popResourceFromFace(class_1937 level, class_2338 blockPos, class_2350 side, class_1799 itemStack) {
        class_2680 blockState = level.method_8320(blockPos);
        double itemWidth = class_1299.field_6052.method_17685();
        double itemHeight = class_1299.field_6052.method_17686();
        class_265 shape = blockState.method_26220((class_1922)level, blockPos);
        double posX = (double)blockPos.method_10263() + 0.5;
        double posY = (double)blockPos.method_10264() + 0.5;
        double posZ = (double)blockPos.method_10260() + 0.5;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        switch (side) {
            case field_11033: {
                posY = (double)blockPos.method_10264() - shape.method_1091(class_2350.class_2351.field_11052);
                offsetY = -itemHeight * 2.0;
                break;
            }
            case field_11036: {
                posY = (double)blockPos.method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
                break;
            }
            case field_11043: {
                posZ = (double)blockPos.method_10260() + shape.method_1091(class_2350.class_2351.field_11051);
                offsetZ = -itemWidth;
                break;
            }
            case field_11035: {
                posZ = (double)blockPos.method_10260() + shape.method_1105(class_2350.class_2351.field_11051);
                offsetZ = itemWidth;
                break;
            }
            case field_11039: {
                posX = (double)blockPos.method_10263() + shape.method_1091(class_2350.class_2351.field_11048);
                offsetX = -itemWidth;
                break;
            }
            case field_11034: {
                posX = (double)blockPos.method_10263() + shape.method_1105(class_2350.class_2351.field_11048);
                offsetX = itemWidth;
            }
        }
        int i = side.method_10148();
        int j = side.method_10164();
        int k = side.method_10165();
        double deltaX = i == 0 ? class_3532.method_15366((class_5819)level.field_9229, (double)-0.1, (double)0.1) : (double)i * 0.1;
        double deltaY = j == 0 ? class_3532.method_15366((class_5819)level.field_9229, (double)0.0, (double)0.1) : (double)j * 0.1 + 0.1;
        double deltaZ = k == 0 ? class_3532.method_15366((class_5819)level.field_9229, (double)-0.1, (double)0.1) : (double)k * 0.1;
        GeneralUtil.popResource(level, new class_1542(level, posX + offsetX, posY + offsetY, posZ + offsetZ, itemStack, deltaX, deltaY, deltaZ), itemStack);
    }

    private static void popResource(class_1937 level, class_1542 itemEntity, class_1799 itemStack) {
        if (!level.field_9236 && !itemStack.method_7960() && level.method_8450().method_8355(class_1928.field_19392)) {
            itemEntity.method_6988();
            level.method_8649((class_1297)itemEntity);
        }
    }

    public static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1082((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (class_247)class_247.field_1366);
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    public static Optional<class_3545<Float, Float>> getRelativeHitCoordinatesForBlockFace(class_3965 blockHitResult, class_2350 direction, class_2350[] unAllowedDirections) {
        class_2350 hitDirection = blockHitResult.method_17780();
        for (class_2350 unAllowed : unAllowedDirections) {
            if (unAllowed != hitDirection) continue;
            return Optional.empty();
        }
        if (hitDirection != direction && hitDirection != class_2350.field_11036 && hitDirection != class_2350.field_11033) {
            return Optional.empty();
        }
        class_2338 adjacentPos = blockHitResult.method_17777().method_10093(hitDirection);
        class_243 hitLocation = blockHitResult.method_17784().method_1023((double)adjacentPos.method_10263(), (double)adjacentPos.method_10264(), (double)adjacentPos.method_10260());
        float x = (float)hitLocation.method_10216();
        float z = (float)hitLocation.method_10215();
        float y = (float)hitLocation.method_10214();
        class_2350 effectiveDirection = hitDirection == class_2350.field_11036 || hitDirection == class_2350.field_11033 ? direction : hitDirection;
        return switch (effectiveDirection) {
            case class_2350.field_11043 -> Optional.of(new class_3545((Object)Float.valueOf(1.0f - x), (Object)Float.valueOf(y)));
            case class_2350.field_11035 -> Optional.of(new class_3545((Object)Float.valueOf(x), (Object)Float.valueOf(y)));
            case class_2350.field_11039 -> Optional.of(new class_3545((Object)Float.valueOf(z), (Object)Float.valueOf(y)));
            case class_2350.field_11034 -> Optional.of(new class_3545((Object)Float.valueOf(1.0f - z), (Object)Float.valueOf(y)));
            default -> Optional.empty();
        };
    }

    public static class_2371<class_1856> deserializeIngredients(JsonArray json) {
        class_2371 ingredients = class_2371.method_10211();
        for (int i = 0; i < json.size(); ++i) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)json.get(i));
            if (ingredient.method_8103()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static class_1799 convertStackAfterFinishUsing(class_1309 entity, class_1799 used, class_1792 returnItem, class_1792 usedItem) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            class_174.field_1198.method_8821(serverPlayer, used);
            serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)usedItem));
        }
        if (used.method_7960()) {
            return new class_1799((class_1935)returnItem);
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!((class_1657)entity).method_31549().field_7477) {
                class_1799 itemStack2 = new class_1799((class_1935)returnItem);
                if (!player.method_31548().method_7394(itemStack2)) {
                    player.method_7328(itemStack2, false);
                }
            }
        }
        return used;
    }

    public static class_1269 onUse(class_1937 world, class_1657 player, class_1268 hand, class_3965 hit, double extraHeight) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (player.method_5715()) {
            return class_1269.field_5811;
        }
        if (GeneralUtil.isPlayerSitting(player)) {
            return class_1269.field_5811;
        }
        if (hit.method_17780() == class_2350.field_11033) {
            return class_1269.field_5811;
        }
        class_2338 hitPos = hit.method_17777();
        if (!GeneralUtil.isOccupied(world, hitPos) && player.method_5998(hand).method_7960()) {
            ChairEntity chair = (ChairEntity)((class_1299)EntityTypeRegistry.CHAIR.get()).method_5883(world);
            assert (chair != null);
            chair.method_5808((double)hitPos.method_10263() + 0.5, (double)hitPos.method_10264() + 0.25 + extraHeight, (double)hitPos.method_10260() + 0.5, 0.0f, 0.0f);
            if (GeneralUtil.addChairEntity(world, hitPos, chair, player.method_24515())) {
                world.method_8649((class_1297)chair);
                player.method_5804((class_1297)chair);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static void onStateReplaced(class_1937 world, class_2338 pos) {
        ChairEntity entity;
        if (!world.field_9236 && (entity = GeneralUtil.getChairEntity(world, pos)) != null) {
            GeneralUtil.removeChairEntity(world, pos);
            entity.method_5772();
        }
    }

    public static boolean addChairEntity(class_1937 world, class_2338 blockPos, ChairEntity entity, class_2338 playerPos) {
        if (!world.field_9236) {
            class_2960 id = GeneralUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, class_2338>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static void removeChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.field_9236 && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
        }
    }

    public static ChairEntity getChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.method_8608() && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static class_2338 getPreviousPlayerPosition(class_1657 player, ChairEntity chairEntity) {
        class_2960 id;
        if (!player.method_37908().method_8608() && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(player.method_37908()))) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (class_2338)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(class_1937 world, class_2338 pos) {
        class_2960 id = GeneralUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(class_1657 player) {
        for (class_2960 i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).method_5626((class_1297)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static class_2960 getDimensionTypeId(class_1937 world) {
        return world.method_44013().method_29177();
    }

    public static enum LineConnectingType implements class_3542
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }
}

