/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.satisfy.vinery.core.block.entity.FermentationBarrelBlockEntity;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelRecipe
implements class_1860<FermentationBarrelBlockEntity> {
    private final class_2960 identifier;
    private final class_2371<class_1856> inputs;
    private final String juiceType;
    private final int juiceAmount;
    private final class_1799 output;
    private final boolean wineBottleRequired;

    public FermentationBarrelRecipe(class_2960 identifier, class_2371<class_1856> inputs, String juiceType, int juiceAmount, class_1799 output, boolean wineBottleRequired) {
        this.identifier = identifier;
        this.inputs = inputs;
        this.juiceType = juiceType;
        this.juiceAmount = juiceAmount;
        this.output = output;
        this.wineBottleRequired = wineBottleRequired;
    }

    public String getJuiceType() {
        return this.juiceType;
    }

    public int getJuiceAmount() {
        return this.juiceAmount;
    }

    public boolean isWineBottleRequired() {
        return this.wineBottleRequired;
    }

    public boolean matches(FermentationBarrelBlockEntity blockEntity, class_1937 world) {
        class_1799 wineBottle;
        if (this.juiceAmount > 0) {
            if (blockEntity.getFluidLevel() < this.juiceAmount) {
                return false;
            }
            if (!this.juiceType.equals(blockEntity.getJuiceType())) {
                return false;
            }
        }
        if (this.wineBottleRequired && ((wineBottle = blockEntity.method_5438(4)).method_7960() || !wineBottle.method_31574((class_1792)ObjectRegistry.WINE_BOTTLE.get()))) {
            return false;
        }
        class_1662 recipeMatcher = new class_1662();
        int matchingStacks = 0;
        for (int i = 1; i < 4; ++i) {
            class_1799 itemStack = blockEntity.method_5438(i);
            if (itemStack.method_7960()) continue;
            ++matchingStacks;
            recipeMatcher.method_20478(itemStack, 1);
        }
        return matchingStacks == this.inputs.size() && recipeMatcher.method_7402((class_1860)this, null);
    }

    @NotNull
    public class_1799 assemble(FermentationBarrelBlockEntity blockEntity, class_5455 registryAccess) {
        return this.output.method_7972();
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.output.method_7972();
    }

    @NotNull
    public class_2960 method_8114() {
        return this.identifier;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get();
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<FermentationBarrelRecipe> {
        @NotNull
        public FermentationBarrelRecipe fromJson(class_2960 id, JsonObject json) {
            class_2371 ingredients = class_2371.method_10211();
            if (json.has("ingredients")) {
                JsonArray jsonArray = class_3518.method_15261((JsonObject)json, (String)"ingredients");
                for (int i = 0; i < jsonArray.size() && i < 3; ++i) {
                    ingredients.add((Object)class_1856.method_52177((JsonElement)jsonArray.get(i)));
                }
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Fermentation Barrel recipe");
            }
            String juiceType = "white_general";
            int juiceAmount = 10;
            if (json.has("juice")) {
                JsonObject juiceObject = class_3518.method_15296((JsonObject)json, (String)"juice");
                juiceType = class_3518.method_15253((JsonObject)juiceObject, (String)"type", (String)"white_general");
                juiceAmount = class_3518.method_15282((JsonObject)juiceObject, (String)"amount", (int)10);
            }
            boolean wineBottleRequired = false;
            if (json.has("wine_bottle")) {
                JsonObject wineBottleObject = class_3518.method_15296((JsonObject)json, (String)"wine_bottle");
                wineBottleRequired = class_3518.method_15258((JsonObject)wineBottleObject, (String)"required", (boolean)false);
            }
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new FermentationBarrelRecipe(id, (class_2371<class_1856>)ingredients, juiceType, juiceAmount, result, wineBottleRequired);
        }

        @NotNull
        public FermentationBarrelRecipe fromNetwork(class_2960 id, class_2540 buf) {
            int ingredientCount = buf.method_10816();
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < ingredientCount && i < 3; ++i) {
                ingredients.add((Object)class_1856.method_8086((class_2540)buf));
            }
            String juiceType = buf.method_19772();
            int juiceAmount = buf.method_10816();
            boolean wineBottleRequired = buf.readBoolean();
            class_1799 result = buf.method_10819();
            return new FermentationBarrelRecipe(id, (class_2371<class_1856>)ingredients, juiceType, juiceAmount, result, wineBottleRequired);
        }

        public void toNetwork(class_2540 buf, FermentationBarrelRecipe recipe) {
            buf.method_10804(recipe.inputs.size());
            for (class_1856 ingredient : recipe.inputs) {
                ingredient.method_8088(buf);
            }
            buf.method_10814(recipe.juiceType);
            buf.method_10804(recipe.juiceAmount);
            buf.writeBoolean(recipe.wineBottleRequired);
            buf.method_10793(recipe.output);
        }
    }
}

