/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.satisfy.vinery.core.util.WineYears;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WineDebugCommands {
    private static final Logger LOGGER = LogManager.getLogger((String)"Vinery");

    public static void init() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, selection) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wine").requires(src -> true)).then(class_2170.method_9247((String)"age").then(class_2170.method_9244((String)"years", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100000)).executes(ctx -> WineDebugCommands.ageHeld((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"years")))))).then(class_2170.method_9247((String)"info").executes(ctx -> WineDebugCommands.infoHeld((class_2168)ctx.getSource()))));
            LOGGER.info("Registered /wine command");
        });
    }

    private static int ageHeld(class_2168 source, int years) {
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Player required"));
            return 0;
        }
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"No item in main hand"));
            return 0;
        }
        class_3218 level = player.method_51469();
        int targetYear = WineYears.getYear((class_1937)level) - years;
        stack.method_7948().method_10569("Year", targetYear);
        WineYears.refreshCached(stack, (class_1937)level);
        source.method_9226(() -> class_2561.method_43470((String)("Wine age set to " + years + " years")), false);
        return 1;
    }

    private static int infoHeld(class_2168 source) {
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Player required"));
            return 0;
        }
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"No item in main hand"));
            return 0;
        }
        class_3218 level = player.method_51469();
        int age = WineYears.getWineAge(stack, (class_1937)level);
        int days = WineYears.getWineAgeDays(stack, (class_1937)level);
        int amplifier = WineYears.getEffectLevel(stack, (class_1937)level);
        int duration = WineYears.getEffectDuration(stack, (class_1937)level);
        source.method_9226(() -> class_2561.method_43470((String)("Age: " + age + "y, " + days + "d | Amp: " + amplifier + " | Dur: " + duration + " ticks")), false);
        return 1;
    }
}

