/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.satisfy.vinery.core.block.StemBlock;
import net.satisfy.vinery.core.block.entity.LatticeBlockEntity;
import net.satisfy.vinery.core.item.GrapeBushSeedItem;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatticeBlock
extends StemBlock
implements class_2343 {
    public static final class_2746 SUPPORT = class_2746.method_11825((String)"support");
    public static final class_2746 BOTTOM = class_2746.method_11825((String)"bottom");
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<GeneralUtil.LineConnectingType> TYPE = GeneralUtil.LINE_CONNECTING_TYPE;
    protected static final class_265 EAST = LatticeBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final class_265 WEST = LatticeBlock.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH = LatticeBlock.method_9541((double)0.0, (double)0.0, (double)0.01, (double)16.0, (double)16.0, (double)2.0);
    protected static final class_265 NORTH = LatticeBlock.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 FLOOR = LatticeBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final class_3414 BREAK_SOUND_EVENT = class_3417.field_17615;
    private static final class_3414 PLACE_SOUND_EVENT = class_3417.field_17616;

    public LatticeBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SUPPORT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BOTTOM, (Comparable)Boolean.valueOf(false))).method_11657(TYPE, (Comparable)((Object)GeneralUtil.LineConnectingType.NONE)));
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350 clickedFacingFace;
        class_1937 level = context.method_8045();
        class_2350 facing = context.method_8042().method_10153();
        class_2338 clickedPos = context.method_8037();
        class_2350 clickedFace = context.method_8038();
        class_2338 clickedFacingPos = clickedPos.method_10093(clickedFace.method_10153());
        class_2680 clickedFacingState = level.method_8320(clickedFacingPos);
        if (context.method_8036() != null && !context.method_8036().method_18276() && clickedFacingState.method_26204() instanceof LatticeBlock && (clickedFacingFace = (class_2350)clickedFacingState.method_11654((class_2769)FACING)) != clickedFace && clickedFacingFace.method_10153() != clickedFace) {
            facing = clickedFacingFace;
        }
        boolean bottom = clickedFace == class_2350.field_11033 || clickedFace == class_2350.field_11036;
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)BOTTOM, (Comparable)Boolean.valueOf(bottom));
        if (!bottom) {
            state = this.getConnection(state, (class_1936)level, clickedPos);
        }
        return state;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        if (Boolean.TRUE.equals(state.method_11654((class_2769)BOTTOM))) {
            return FLOOR;
        }
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
            case class_2350.field_11035 -> SOUTH;
            default -> NORTH;
        };
    }

    @Override
    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        LatticeBlockEntity lattice;
        class_2586 be;
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (stack.method_7909() instanceof class_1743) {
            class_2680 newState = (class_2680)state.method_11657((class_2769)SUPPORT, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)SUPPORT) == false));
            class_2680 updateState = this.getConnection(newState, (class_1936)world, pos);
            world.method_8652(pos, updateState, 3);
            return class_1269.field_5812;
        }
        class_1792 updateState = stack.method_7909();
        if (updateState instanceof GrapeBushSeedItem) {
            GrapeBushSeedItem seedItem = (GrapeBushSeedItem)updateState;
            GrapeType type = seedItem.getType();
            if (age == 0 && type.isLattice()) {
                class_2680 newState = this.withAge(state, 1, type);
                world.method_8652(pos, newState, 3);
                class_2586 be2 = world.method_8321(pos);
                if (be2 instanceof LatticeBlockEntity) {
                    LatticeBlockEntity lattice2 = (LatticeBlockEntity)be2;
                    lattice2.setAge(1);
                    lattice2.setGrapeType(type);
                }
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                world.method_8396(null, pos, PLACE_SOUND_EVENT, class_3419.field_15245, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
        }
        if (age > 0 && stack.method_7909() == class_1802.field_8868) {
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            if (age > 2) {
                this.dropGrapes(world, state, pos, hit.method_17780());
            }
            this.dropGrapeSeeds(world, state, pos, hit.method_17780());
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)), 3);
            be = world.method_8321(pos);
            if (be instanceof LatticeBlockEntity) {
                lattice = (LatticeBlockEntity)be;
                lattice.setAge(0);
            }
            world.method_8396(player, pos, BREAK_SOUND_EVENT, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (age > 2) {
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            this.dropGrapes(world, state, pos, hit.method_17780());
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(1)), 3);
            be = world.method_8321(pos);
            if (be instanceof LatticeBlockEntity) {
                lattice = (LatticeBlockEntity)be;
                lattice.setAge(1);
            }
            world.method_8396(player, pos, BREAK_SOUND_EVENT, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        Random rand = new Random();
        if (rand.nextInt(100) >= 98 || this.isMature(state)) {
            return;
        }
        int age = (Integer)state.method_11654((class_2769)AGE);
        GrapeType type = (GrapeType)state.method_11654((class_2769)GRAPE);
        class_2680 newState = this.withAge(state, age + 1, type);
        world.method_8652(pos, newState, 2);
        class_2586 be = world.method_8321(pos);
        if (be instanceof LatticeBlockEntity) {
            LatticeBlockEntity lattice = (LatticeBlockEntity)be;
            lattice.setAge(age + 1);
            lattice.setGrapeType(type);
        }
        super.method_9514(state, world, pos, random);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184((class_4538)world, pos)) {
            if ((Integer)state.method_11654((class_2769)AGE) > 0) {
                this.dropGrapeSeeds((class_1937)world, state, pos, null);
            }
            if ((Integer)state.method_11654((class_2769)AGE) > 2) {
                this.dropGrapes((class_1937)world, state, pos, null);
            }
            world.method_22352(pos, true);
        }
    }

    public boolean method_9542(class_2680 state) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        return !this.isMature(state) && age > 0 && age < 4;
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184((class_4538)world, pos)) {
            world.method_39279(pos, (class_2248)this, 1);
        }
        return this.getConnection(state, world, pos);
    }

    @Override
    public boolean method_9651(class_4538 levelReader, class_2338 pos, class_2680 state, boolean isClient) {
        return !this.isMature(state) && (Integer)state.method_11654((class_2769)AGE) > 0;
    }

    public class_2680 getConnection(class_2680 state, class_1936 level, class_2338 currentPos) {
        boolean sideR;
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        boolean bottom = (Boolean)state.method_11654((class_2769)BOTTOM);
        class_2680 stateL = level.method_8320(currentPos.method_10093(facing.method_10170()));
        class_2680 stateR = level.method_8320(currentPos.method_10093(facing.method_10160()));
        boolean sideL = stateL.method_26204() instanceof LatticeBlock && stateL.method_11654((class_2769)FACING) == facing && (Boolean)stateL.method_11654((class_2769)BOTTOM) == bottom;
        boolean bl = sideR = stateR.method_26204() instanceof LatticeBlock && stateR.method_11654((class_2769)FACING) == facing && (Boolean)stateR.method_11654((class_2769)BOTTOM) == bottom;
        GeneralUtil.LineConnectingType type = sideL && sideR ? GeneralUtil.LineConnectingType.MIDDLE : (sideR ? GeneralUtil.LineConnectingType.LEFT : (sideL ? GeneralUtil.LineConnectingType.RIGHT : GeneralUtil.LineConnectingType.NONE));
        return (class_2680)state.method_11657(TYPE, (Comparable)((Object)type));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, TYPE, SUPPORT, BOTTOM});
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new LatticeBlockEntity(pos, state);
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 state) {
        return class_2464.field_11455;
    }
}

