/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.render.block;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2508;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_8242;
import net.minecraft.class_827;
import net.satisfy.vinery.core.block.entity.ModSignBlockEntity;

@Environment(value=EnvType.CLIENT)
public class ModSignRenderer<T extends ModSignBlockEntity>
implements class_827<T> {
    private static final String STICK = "stick";
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = class_3532.method_34954((int)16);
    private static final float RENDER_SCALE = 0.6666667f;
    private static final class_243 TEXT_OFFSET = new class_243(0.0, 0.3333333432674408, 0.046666666865348816);
    private final Map<class_4719, SignModel> signModels = (Map)class_4719.method_24026().collect(ImmutableMap.toImmutableMap(woodType -> woodType, woodType -> new SignModel(context.method_32140(class_5602.method_32078((class_4719)woodType)))));
    private final class_327 font;

    public ModSignRenderer(class_5614.class_5615 context) {
        this.font = context.method_32143();
    }

    public void render(ModSignBlockEntity signBlockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        class_2680 blockState = signBlockEntity.method_11010();
        class_2478 signBlock = (class_2478)blockState.method_26204();
        class_4719 woodType = class_2478.method_45459((class_2248)signBlock);
        SignModel signModel = this.signModels.get(woodType);
        signModel.stick.field_3665 = blockState.method_26204() instanceof class_2508;
        this.renderSignWithText(signBlockEntity, poseStack, multiBufferSource, i, j, blockState, signBlock, woodType, signModel);
    }

    public float getSignModelRenderScale() {
        return 0.6666667f;
    }

    public float getSignTextRenderScale() {
        return 0.6666667f;
    }

    void renderSignWithText(ModSignBlockEntity signBlockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, class_2680 blockState, class_2478 signBlock, class_4719 woodType, class_3879 model) {
        poseStack.method_22903();
        this.translateSign(poseStack, -signBlock.method_49814(blockState), blockState);
        this.renderSign(poseStack, multiBufferSource, i, j, woodType, model);
        this.renderSignText(signBlockEntity.method_11016(), signBlockEntity.method_49853(), poseStack, multiBufferSource, i, signBlockEntity.method_45469(), signBlockEntity.method_45470(), true);
        this.renderSignText(signBlockEntity.method_11016(), signBlockEntity.method_49854(), poseStack, multiBufferSource, i, signBlockEntity.method_45469(), signBlockEntity.method_45470(), false);
        poseStack.method_22909();
    }

    void translateSign(class_4587 poseStack, float f, class_2680 blockState) {
        poseStack.method_46416(0.5f, 0.75f * this.getSignModelRenderScale(), 0.5f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(f));
        if (!(blockState.method_26204() instanceof class_2508)) {
            poseStack.method_46416(0.0f, -0.3125f, -0.4375f);
        }
    }

    void renderSign(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, class_4719 woodType, class_3879 model) {
        poseStack.method_22903();
        float f = this.getSignModelRenderScale();
        poseStack.method_22905(f, -f, -f);
        class_4730 material = this.getSignMaterial(woodType);
        Objects.requireNonNull(model);
        class_4588 vertexConsumer = material.method_24145(multiBufferSource, arg_0 -> ((class_3879)model).method_23500(arg_0));
        this.renderSignModel(poseStack, i, j, model, vertexConsumer);
        poseStack.method_22909();
    }

    void renderSignModel(class_4587 poseStack, int i, int j, class_3879 model, class_4588 vertexConsumer) {
        SignModel signModel = (SignModel)model;
        signModel.root.method_22698(poseStack, vertexConsumer, i, j);
    }

    class_4730 getSignMaterial(class_4719 woodType) {
        return class_4722.method_33082((class_4719)woodType);
    }

    void renderSignText(class_2338 blockPos, class_8242 signText, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, int k, boolean bl) {
        int o;
        boolean bl2;
        int n;
        poseStack.method_22903();
        this.translateSignText(poseStack, bl, this.getTextOffset());
        int l = ModSignRenderer.getDarkColor(signText);
        int m = 4 * j / 2;
        class_5481[] formattedCharSequences = signText.method_49868(class_310.method_1551().method_33883(), component -> {
            List list = this.font.method_1728((class_5348)component, k);
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (signText.method_49856()) {
            n = signText.method_49872().method_16357();
            bl2 = ModSignRenderer.isOutlineVisible(blockPos, n);
            o = 0xF000F0;
        } else {
            n = l;
            bl2 = false;
            o = i;
        }
        for (int p = 0; p < 4; ++p) {
            class_5481 formattedCharSequence = formattedCharSequences[p];
            float f = -this.font.method_30880(formattedCharSequence) / 2;
            if (bl2) {
                this.font.method_37296(formattedCharSequence, f, (float)(p * j - m), n, l, poseStack.method_23760().method_23761(), multiBufferSource, o);
                continue;
            }
            this.font.method_22942(formattedCharSequence, f, (float)(p * j - m), n, false, poseStack.method_23760().method_23761(), multiBufferSource, class_327.class_6415.field_33995, 0, o);
        }
        poseStack.method_22909();
    }

    private void translateSignText(class_4587 poseStack, boolean bl, class_243 vec3) {
        if (!bl) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
        float f = 0.015625f * this.getSignTextRenderScale();
        poseStack.method_22904(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        poseStack.method_22905(f, -f, f);
    }

    class_243 getTextOffset() {
        return TEXT_OFFSET;
    }

    static boolean isOutlineVisible(class_2338 blockPos, int i) {
        if (i == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        class_746 localPlayer = minecraft.field_1724;
        if (localPlayer != null && minecraft.field_1690.method_31044().method_31034() && localPlayer.method_31550()) {
            return true;
        }
        class_1297 entity = minecraft.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)blockPos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    static int getDarkColor(class_8242 signText) {
        int i = signText.method_49872().method_16357();
        if (i == class_1767.field_7963.method_16357() && signText.method_49856()) {
            return -988212;
        }
        double d = 0.4;
        int j = (int)((double)class_5253.class_5254.method_27765((int)i) * 0.4);
        int k = (int)((double)class_5253.class_5254.method_27766((int)i) * 0.4);
        int l = (int)((double)class_5253.class_5254.method_27767((int)i) * 0.4);
        return class_5253.class_5254.method_27764((int)0, (int)j, (int)k, (int)l);
    }

    public static SignModel createSignModel(class_5599 entityModelSet, class_4719 woodType) {
        return new SignModel(entityModelSet.method_32072(class_5602.method_32078((class_4719)woodType)));
    }

    public static class_5607 createSignLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("sign", class_5606.method_32108().method_32101(0, 0).method_32097(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f), class_5603.field_27701);
        partDefinition.method_32117(STICK, class_5606.method_32108().method_32101(0, 14).method_32097(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), class_5603.field_27701);
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)32);
    }

    @Environment(value=EnvType.CLIENT)
    public static final class SignModel
    extends class_3879 {
        public final class_630 root;
        public final class_630 stick;

        public SignModel(class_630 modelPart) {
            super(class_1921::method_23578);
            this.root = modelPart;
            this.stick = modelPart.method_32086(ModSignRenderer.STICK);
        }

        public void method_2828(class_4587 poseStack, class_4588 vertexConsumer, int i, int j, float f, float g, float h, float k) {
            this.root.method_22699(poseStack, vertexConsumer, i, j, f, g, h, k);
        }
    }
}

