/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.entity.rope;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.entity.rope.IRopeEntity;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.util.rope.RopeConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RopeKnotEntity
extends class_1530
implements IRopeEntity {
    private static final int MAX_RANGE = 32;
    private static final byte GRACE_PERIOD = 100;
    private final Set<RopeConnection> connections = new HashSet<RopeConnection>();
    private final ObjectList<class_2520> incompleteConnections = new ObjectArrayList();
    private int checkTimer = 0;
    private byte graceTicks = (byte)100;

    public RopeKnotEntity(class_1299<? extends RopeKnotEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    private RopeKnotEntity(class_1937 level, class_2338 blockPos) {
        super((class_1299)EntityRegistry.ROPE_KNOT.get(), level, blockPos);
        this.method_5814(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public static RopeKnotEntity create(@NotNull class_1937 level, @NotNull class_2338 blockPos) {
        return new RopeKnotEntity(level, blockPos);
    }

    public Set<RopeConnection> getConnections() {
        return this.connections;
    }

    public void addConnection(@NotNull RopeConnection connection) {
        if (!connection.from().equals(connection.to())) {
            this.connections.add(connection);
        }
    }

    public boolean sameConnectionExist(@NotNull RopeConnection connection) {
        for (RopeConnection ropeConnection : this.connections) {
            if (!connection.equals(ropeConnection)) continue;
            return true;
        }
        return false;
    }

    public static boolean canAttachTo(class_2680 blockState) {
        return blockState != null && (blockState.method_26164(class_3481.field_16584) || blockState.method_27852(class_2246.field_10348));
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        class_1799 handStack = player.method_5998(interactionHand);
        if (this.method_37908().method_8608()) {
            if (handStack.method_31574((class_1792)ObjectRegistry.ROPE.get())) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        boolean madeConnection = this.tryAttachHeldRope(player);
        if (madeConnection) {
            this.method_6894();
            return class_1269.field_21466;
        }
        boolean broke = false;
        for (RopeConnection connection : this.connections) {
            if (connection.to() != player) continue;
            broke = true;
            connection.destroy(true);
        }
        if (broke) {
            return class_1269.field_21466;
        }
        if (handStack.method_31574((class_1792)ObjectRegistry.ROPE.get())) {
            this.method_6894();
            RopeConnection.create(this, (class_1297)player);
            if (!player.method_7337()) {
                handStack.method_7934(1);
            }
            return class_1269.field_21466;
        }
        if (IRopeEntity.canDestroyWith(handStack)) {
            this.destroyConnections(!player.method_7337());
            this.graceTicks = 0;
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    private boolean tryAttachHeldRope(class_1657 player) {
        boolean hasMadeConnection = false;
        List<RopeConnection> attachableRopes = RopeKnotEntity.getHeldRopesInRange(player, this.method_19538());
        for (RopeConnection connection : attachableRopes) {
            RopeConnection newConnection;
            if (connection.from() == this || (newConnection = RopeConnection.create(connection.from(), (class_1297)this)) == null) continue;
            connection.destroy(false);
            connection.removeSilently = true;
            hasMadeConnection = true;
        }
        return hasMadeConnection;
    }

    public static List<RopeConnection> getHeldRopesInRange(class_1657 player, class_243 target) {
        class_238 searchBox = class_238.method_30048((class_243)target, (double)64.0, (double)64.0, (double)64.0);
        List otherKnots = player.method_37908().method_18467(RopeKnotEntity.class, searchBox);
        ArrayList<RopeConnection> attachableRopes = new ArrayList<RopeConnection>();
        for (RopeKnotEntity source : otherKnots) {
            for (RopeConnection connection : source.getConnections()) {
                if (connection.to() != player) continue;
                attachableRopes.add(connection);
            }
        }
        return attachableRopes;
    }

    @Nullable
    public static RopeKnotEntity getHopRopeKnotEntity(class_1937 level, class_2338 pos) {
        List results = level.method_18467(RopeKnotEntity.class, class_238.method_30048((class_243)class_243.method_24954((class_2382)pos), (double)2.0, (double)2.0, (double)2.0));
        for (RopeKnotEntity current : results) {
            if (!new class_2338((class_2382)current.field_7100).equals((Object)pos)) continue;
            return current;
        }
        return null;
    }

    public boolean method_5698(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.method_5643(this.method_48923().method_48802(player), 0.0f);
        } else {
            this.method_5783(class_3417.field_14628, 0.5f, 1.0f);
        }
        return true;
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        class_1269 result = IRopeEntity.onDamageFrom((class_1297)this, damageSource);
        if (result.method_23665()) {
            this.destroyConnections(result == class_1269.field_5812);
            return true;
        }
        return false;
    }

    public void method_5773() {
        if (this.method_37908().method_8608()) {
            this.connections.removeIf(RopeConnection::dead);
            return;
        }
        this.method_31473();
        boolean anyConverted = this.convertIncompleteConnections();
        this.updateConnections();
        this.removeDeadConnections();
        if (this.graceTicks < 0 || anyConverted && this.incompleteConnections.isEmpty()) {
            this.graceTicks = 0;
        } else if (this.graceTicks > 0) {
            this.graceTicks = (byte)(this.graceTicks - 1);
        }
    }

    private boolean convertIncompleteConnections() {
        if (!this.incompleteConnections.isEmpty()) {
            return this.incompleteConnections.removeIf(this::deserializeChainTag);
        }
        return false;
    }

    private void updateConnections() {
        double squaredMaxRange = 1024.0;
        for (RopeConnection connection : this.connections) {
            if (connection.dead()) continue;
            if (!this.method_5805()) {
                connection.destroy(true);
                continue;
            }
            if (connection.from() != this || !(connection.getSquaredDistance() > squaredMaxRange)) continue;
            connection.destroy(true);
        }
        if (this.checkTimer++ == 100) {
            this.checkTimer = 0;
            if (!this.method_6888()) {
                this.destroyConnections(true);
            }
        }
    }

    public boolean method_6888() {
        class_2680 blockState = this.method_37908().method_8320(this.method_6896());
        return RopeKnotEntity.canAttachTo(blockState);
    }

    private void removeDeadConnections() {
        boolean playBreakSound = false;
        for (RopeConnection connection : this.connections) {
            if (connection.needsBeDestroyed()) {
                connection.destroy(true);
            }
            if (!connection.dead() || connection.removeSilently) continue;
            playBreakSound = true;
        }
        if (playBreakSound) {
            this.method_6889(null);
        }
        this.connections.removeIf(RopeConnection::dead);
        if (this.connections.isEmpty() && this.incompleteConnections.isEmpty() && this.graceTicks <= 0) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    @Override
    public void destroyConnections(boolean mayDrop) {
        for (RopeConnection connection : this.connections) {
            connection.destroy(mayDrop);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2499 connectionTag = new class_2499();
        for (RopeConnection connection : this.connections) {
            if (connection.dead() || connection.from() != this) continue;
            class_1297 toEntity = connection.to();
            class_2487 compoundTag = new class_2487();
            if (toEntity instanceof class_1657) {
                UUID uuid = toEntity.method_5667();
                compoundTag.method_25927("UUID", uuid);
            } else if (toEntity instanceof RopeKnotEntity) {
                RopeKnotEntity ropeKnotEntity = (RopeKnotEntity)toEntity;
                class_2338 fromPos = this.method_6896();
                class_2338 toPos = ropeKnotEntity.method_6896();
                class_2338 relPos = toPos.method_10059((class_2382)fromPos);
                class_2350 inverseFacing = class_2350.method_10150((double)(class_2350.field_11035.method_10144() - this.method_36454()));
                relPos = this.getBlockPosAsFacingRelative(relPos, inverseFacing);
                compoundTag.method_10569("RelX", relPos.method_10263());
                compoundTag.method_10569("RelY", relPos.method_10264());
                compoundTag.method_10569("RelZ", relPos.method_10260());
                compoundTag.method_10569("Active", connection.activeHangingRopes());
            }
            connectionTag.add((Object)compoundTag);
        }
        connectionTag.addAll(this.incompleteConnections);
        if (!connectionTag.isEmpty()) {
            nbt.method_10566("ropes", (class_2520)connectionTag);
        }
    }

    private class_2338 getBlockPosAsFacingRelative(class_2338 relPos, class_2350 facing) {
        class_2470 rotation = class_2470.values()[facing.method_10161()];
        return relPos.method_10070(rotation);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("ropes")) {
            this.incompleteConnections.addAll((Collection)nbt.method_10554("ropes", 10));
        }
    }

    private boolean deserializeChainTag(class_2520 element) {
        if (element == null || this.method_37908().method_8608()) {
            return true;
        }
        if (element instanceof class_2487) {
            class_2487 tag = (class_2487)element;
            if (tag.method_10545("UUID")) {
                UUID uuid = tag.method_25926("UUID");
                class_1297 toEntity = ((class_3218)this.method_37908()).method_14190(uuid);
                if (toEntity != null) {
                    RopeConnection.create(this, toEntity);
                    return true;
                }
            } else if (tag.method_10545("RelX") || tag.method_10545("RelY") || tag.method_10545("RelZ")) {
                class_2338 blockPos = new class_2338(tag.method_10550("RelX"), tag.method_10550("RelY"), tag.method_10550("RelZ"));
                blockPos = this.getBlockPosAsFacingRelative(blockPos, class_2350.method_10150((double)this.method_36454()));
                RopeKnotEntity entity = RopeKnotEntity.getHopRopeKnotEntity(this.method_37908(), blockPos.method_10081((class_2382)this.method_6896()));
                if (entity != null) {
                    int activeRopes = tag.method_10545("Active") ? tag.method_10550("Active") : 0;
                    RopeConnection.create(this, (class_1297)entity, activeRopes);
                    return true;
                }
            } else {
                Brewery.LOGGER.warn("Chain knot NBT is missing UUID or relative position.");
            }
        }
        if (this.graceTicks <= 0) {
            this.method_5706((class_1935)ObjectRegistry.ROPE.get());
            this.method_6889(null);
            return true;
        }
        return false;
    }

    public boolean shouldRenderKnot() {
        return !this.method_37908().method_8320(this.field_7100).method_26215();
    }

    private double getYOffset(double x, double y, double z) {
        class_2680 blockState = this.method_37908().method_8320(class_2338.method_49637((double)x, (double)y, (double)z));
        return blockState.method_27852(class_2246.field_10348) ? 0.375 : 0.625;
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814((double)class_3532.method_15357((double)x) + 0.5, (double)class_3532.method_15357((double)y) + this.getYOffset(x, y, z), (double)class_3532.method_15357((double)z) + 0.5);
    }

    protected void method_6892(class_2350 direction) {
    }

    public int method_6897() {
        return 9;
    }

    public int method_6891() {
        return 9;
    }

    public void method_6889(@Nullable class_1297 entity) {
        this.method_5783(class_3417.field_15184, 1.0f, 1.0f);
    }

    public void method_6894() {
        this.method_5783(class_3417.field_15062, 1.0f, 1.0f);
    }

    protected void method_6895() {
        int x = this.field_7100.method_10263();
        int y = this.field_7100.method_10264();
        int z = this.field_7100.method_10260();
        this.method_23327((double)x + 0.5, (double)y + this.getYOffset(x, y, z), (double)z + 0.5);
        double w = (double)this.method_5864().method_17685() / 2.0;
        double h = this.method_5864().method_17686();
        this.method_5857(new class_238(this.method_23317() - w, this.method_23318(), this.method_23321() - w, this.method_23317() + w, this.method_23318() + h, this.method_23321() + w));
    }

    public float method_5763(class_2415 mirror) {
        if (mirror != class_2415.field_11302) {
            for (class_2520 element : this.incompleteConnections) {
                class_2487 tag;
                if (!(element instanceof class_2487) || !(tag = (class_2487)element).method_10545("RelX")) continue;
                tag.method_10569("RelX", -tag.method_10550("RelX"));
            }
        }
        float yaw = class_3532.method_15393((float)this.method_36454());
        return switch (mirror) {
            case class_2415.field_11300 -> 180.0f - yaw;
            case class_2415.field_11301 -> -yaw;
            default -> yaw;
        };
    }

    @NotNull
    public class_243 method_29919() {
        return new class_243(0.0, (double)(((class_1299)EntityRegistry.ROPE_KNOT.get()).method_17686() / 2.0f), 0.0);
    }

    @Environment(value=EnvType.CLIENT)
    @NotNull
    public class_243 method_30951(float f) {
        return this.method_30950(f).method_1019(this.method_29919());
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return ((class_1299)EntityRegistry.ROPE_KNOT.get()).method_17686() / 2.0f;
    }

    @NotNull
    public class_3419 method_5634() {
        return class_3419.field_15245;
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }
}

