/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.brewingstation;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.satisfy.brewery.block.brewingstation.BrewingstationBlock;
import net.satisfy.brewery.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.block.property.Liquid;
import net.satisfy.brewery.registry.BlockStateRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewKettleBlock
extends BrewingstationBlock
implements class_2343 {
    public static final class_2754<Liquid> LIQUID = BlockStateRegistry.LIQUID;
    private static final Supplier<class_265> voxelShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)1.0));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.125));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.875, (double)0.125, (double)0.125, (double)1.0, (double)1.0, (double)1.0));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)1.0));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.125, (double)0.9375, (double)0.875, (double)1.0, (double)1.0));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.5625, (double)0.09375, (double)0.875, (double)0.5625, (double)0.96875));
        return shape;
    };
    public static final Map<class_2350, class_265> SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            map.put(direction, GeneralUtil.rotateShape((class_2350)class_2350.field_11043, (class_2350)direction, (class_265)voxelShapeSupplier.get()));
        }
    });
    private final BrewMaterial brewMaterial;

    public BrewKettleBlock(BrewMaterial brewMaterial, class_4970.class_2251 properties) {
        super(properties);
        this.brewMaterial = brewMaterial;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)MATERIAL, (Comparable)((Object)brewMaterial))).method_11657(LIQUID, (Comparable)((Object)Liquid.EMPTY)));
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE.get(state.method_11654((class_2769)field_11177));
    }

    @NotNull
    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (interactionHand == class_1268.field_5810) {
            return class_1269.field_21466;
        }
        if (level.field_9236) {
            return class_1269.field_21466;
        }
        class_1799 itemStack = player.method_5998(interactionHand);
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof BrewstationBlockEntity) {
            BrewstationBlockEntity brewKettleEntity = (BrewstationBlockEntity)class_25862;
            if (itemStack.method_7960()) {
                class_1799 returnStack = brewKettleEntity.removeIngredient();
                if (returnStack != null) {
                    player.method_7270(returnStack);
                    level.method_8396(null, blockPos, class_3417.field_15197, class_3419.field_15248, 1.0f, 1.0f);
                    level.method_8413(blockPos, blockState, blockState, 2);
                    return class_1269.field_5812;
                }
                return class_1269.field_21466;
            }
            if (itemStack.method_7909() == ((class_2248)ObjectRegistry.BEER_MUG.get()).method_8389()) {
                if (blockState.method_11654(LIQUID) == Liquid.BEER) {
                    class_1799 beerStack = brewKettleEntity.getBeer();
                    if (beerStack != null) {
                        player.method_7270(beerStack);
                        if (!player.method_7337()) {
                            itemStack.method_7934(1);
                            if (itemStack.method_7960()) {
                                player.method_31548().method_7378(itemStack);
                            }
                            level.method_8396(null, blockPos, class_3417.field_15197, class_3419.field_15248, 1.0f, 1.0f);
                            level.method_8413(blockPos, blockState, blockState, 2);
                        }
                        return class_1269.field_5812;
                    }
                    return class_1269.field_21466;
                }
                return class_1269.field_5811;
            }
            if (itemStack.method_7909() == class_1802.field_8705) {
                if (blockState.method_11654(LIQUID) == Liquid.EMPTY || blockState.method_11654(LIQUID) == Liquid.DRAINED) {
                    level.method_8501(blockPos, (class_2680)blockState.method_11657(LIQUID, (Comparable)((Object)Liquid.FILLED)));
                    level.method_8396(null, blockPos, class_3417.field_14834, class_3419.field_15248, 1.0f, 1.0f);
                    if (!player.method_7337()) {
                        player.method_6122(interactionHand, new class_1799((class_1935)class_1802.field_8550));
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_21466;
            }
            if (itemStack.method_7909() == class_1802.field_8550) {
                Liquid liquid = (Liquid)((Object)blockState.method_11654(LIQUID));
                if (liquid == Liquid.FILLED || liquid == Liquid.OVERFLOWING) {
                    level.method_8501(blockPos, (class_2680)blockState.method_11657(LIQUID, (Comparable)((Object)(liquid == Liquid.OVERFLOWING ? Liquid.FILLED : Liquid.EMPTY))));
                    level.method_8396(null, blockPos, class_3417.field_15126, class_3419.field_15248, 1.0f, 1.0f);
                    if (!player.method_7337()) {
                        player.method_6122(interactionHand, new class_1799((class_1935)class_1802.field_8705));
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_21466;
            }
            if (blockState.method_11654(LIQUID) != Liquid.BEER) {
                class_1269 interactionResult = brewKettleEntity.addIngredient(itemStack);
                if (interactionResult == class_1269.field_5812) {
                    level.method_8396(null, blockPos, class_3417.field_14667, class_3419.field_15248, 1.0f, 1.0f);
                    level.method_8413(blockPos, blockState, blockState, 2);
                }
                return interactionResult;
            }
        }
        return super.method_9534(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 randomSource) {
        if (blockState.method_11654(LIQUID) == Liquid.OVERFLOWING) {
            double x = (double)blockPos.method_10263() + 0.5;
            double y = (double)blockPos.method_10264() + 0.95;
            double z = (double)blockPos.method_10260() + 0.5;
            if (randomSource.method_43058() < 0.3) {
                level.method_8486(x, y, z, (class_3414)DoApiSoundEventRegistry.BREWSTATION_KETTLE.get(), class_3419.field_15245, 1.0f, 1.0f, false);
            }
            double offset = 0.2;
            double offsetX = randomSource.method_43058() * offset - offset / 2.0;
            double offsetY = randomSource.method_43058() * 0.1;
            double offsetZ = randomSource.method_43058() * offset - offset / 2.0;
            level.method_8406((class_2394)class_2398.field_11247, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            level.method_8406((class_2394)class_2398.field_11241, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof BrewstationBlockEntity) {
                BrewstationBlockEntity brewstationEntity = (BrewstationBlockEntity)blockEntity;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)brewstationEntity);
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @Override
    @NotNull
    public class_1799 method_9574(class_1922 getter, class_2338 pos, class_2680 state) {
        BrewMaterial material = (BrewMaterial)((Object)state.method_11654((class_2769)MATERIAL));
        switch (material) {
            case COPPER: {
                return new class_1799((class_1935)ObjectRegistry.COPPER_BREWINGSTATION.get());
            }
            case WOOD: {
                return new class_1799((class_1935)ObjectRegistry.WOODEN_BREWINGSTATION.get());
            }
            case NETHERITE: {
                return new class_1799((class_1935)ObjectRegistry.NETHERITE_BREWINGSTATION.get());
            }
        }
        return super.method_9574(getter, pos, state);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_1937 level = blockPlaceContext.method_8045();
        class_2338 mainPos = blockPlaceContext.method_8037();
        class_2680 blockState = super.method_9605(blockPlaceContext);
        if (blockState == null) {
            return null;
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)field_11177);
        class_2338 backPos = mainPos.method_10093(facing.method_10153());
        class_2338 sidePos = mainPos.method_10093(facing.method_10160());
        class_2338 diagonalPos = sidePos.method_10093(facing.method_10153());
        class_2338 topPos = diagonalPos.method_10084();
        boolean placeable = this.canPlace(level, backPos, sidePos, diagonalPos, topPos);
        return placeable ? blockState : null;
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 livingEntity, class_1799 itemStack) {
        super.method_9567(level, blockPos, blockState, livingEntity, itemStack);
        if (level.field_9236) {
            return;
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)field_11177);
        class_2338 backPos = blockPos.method_10093(facing.method_10153());
        class_2338 sidePos = blockPos.method_10093(facing.method_10160());
        class_2338 diagonalPos = sidePos.method_10093(facing.method_10153());
        class_2338 topPos = diagonalPos.method_10084();
        if (!this.canPlace(level, backPos, sidePos, diagonalPos, topPos)) {
            return;
        }
        level.method_8652(backPos, (class_2680)((class_2680)((class_2248)ObjectRegistry.BREW_TIMER.get()).method_9564().method_11657((class_2769)field_11177, (Comparable)facing)).method_11657((class_2769)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        level.method_8652(sidePos, (class_2680)((class_2680)((class_2248)ObjectRegistry.BREW_WHISTLE.get()).method_9564().method_11657((class_2769)field_11177, (Comparable)facing)).method_11657((class_2769)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        level.method_8652(diagonalPos, (class_2680)((class_2680)((class_2248)ObjectRegistry.BREW_OVEN.get()).method_9564().method_11657((class_2769)field_11177, (Comparable)facing)).method_11657((class_2769)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof BrewstationBlockEntity) {
            BrewstationBlockEntity brewKettleEntity = (BrewstationBlockEntity)blockEntity;
            brewKettleEntity.setComponents(blockPos, backPos, sidePos, diagonalPos);
        }
    }

    private boolean canPlace(class_1937 level, class_2338 ... blockPoses) {
        for (class_2338 blockPos : blockPoses) {
            if (level.method_8320(blockPos).method_26215()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new BrewstationBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558) {
                ((class_5558)blockEntity).tick(world, pos, state1, blockEntity);
            }
        };
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LIQUID});
    }
}

