/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.multistate;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_6328;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@class_6328
public interface IMultiStateCopycatBlockEntity
extends ICopycatBlockEntity {
    public MaterialItemStorage getMaterialItemStorage();

    @ApiStatus.OverrideOnly
    public void setMaterialItemStorageInternal(MaterialItemStorage var1);

    @Override
    default public void init() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)class_22482;
            Set<String> properties = copycatBlock.storageProperties();
            this.setMaterialItemStorageInternal(MaterialItemStorage.create(properties));
        } else {
            this.setMaterialItemStorageInternal(MaterialItemStorage.create(Set.of("block")));
        }
    }

    @Override
    default public class_2680 getMaterial() {
        return this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).material();
    }

    @Override
    default public class_1799 getConsumedItem() {
        return this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).consumedItem();
    }

    @Override
    default public boolean isCTEnabled() {
        return this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).enableCT();
    }

    @Override
    default public void setMaterialInternal(class_2680 material) {
        this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).setMaterial(material);
    }

    @Override
    default public void setConsumedItemInternal(class_1799 consumedItem) {
        this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).setConsumedItem(consumedItem);
    }

    @Override
    default public void setCTEnabledInternal(boolean value) {
        this.getMaterialItemStorage().getMaterialItem(this.getBlock().defaultProperty()).setEnableCT(value);
    }

    @Override
    default public IMultiStateCopycatBlock getBlock() {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            return copycatBlock;
        }
        return new IMultiStateCopycatBlock(){

            @Override
            public String defaultProperty() {
                return IMultiStateCopycatBlockEntity.this.getMaterialItemStorage().getAllProperties().stream().findFirst().orElse("material");
            }

            @Override
            public class_2382 vectorScale(class_2680 state) {
                return new class_2382(1, 1, 1);
            }

            @Override
            public Set<String> storageProperties() {
                return Set.of(this.defaultProperty());
            }

            @Override
            public int getColorIndex(String property) {
                return 0;
            }

            @Override
            public boolean partExists(class_2680 state, String property) {
                return false;
            }

            @Override
            public class_2382 getVectorFromProperty(class_2680 state, String property) {
                return new class_2382(0, 0, 0);
            }

            @Override
            public String getPropertyFromInteraction(class_2680 state, class_1922 level, class_2382 hitLocation, class_2338 blockPos, class_2350 facing, class_243 unscaledHit) {
                return this.defaultProperty();
            }

            @Override
            public class_265 getPartialFaceShape(class_1922 level, class_2680 state, String property, class_2350 face) {
                return state.method_26173(level, class_2338.field_10980, face);
            }

            @Override
            public void transformStorage(class_2680 state, IMultiStateCopycatBlockEntity be, StructureTransform transform) {
            }

            @Override
            public boolean isIgnoredConnectivitySide(class_1920 reader, class_2680 state, class_2350 face, class_2338 fromPos, class_2338 toPos, class_2680 toState) {
                return true;
            }

            @Override
            public boolean canConnectTexturesToward(String property, class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 state) {
                return false;
            }
        };
    }

    @Override
    default public boolean hasCustomMaterial() {
        return !this.getMaterialItemStorage().getAllMaterials().stream().allMatch(state -> state.method_27852((class_2248)AllBlocks.COPYCAT_BASE.get()));
    }

    default public void setMaterial(String property, class_2680 blockState) {
        class_2680 wrapperState = this.method_11010();
        class_2680 finalMaterial = blockState;
        if (!this.getMaterialItemStorage().getMaterialItem(property).material().method_27852(finalMaterial.method_26204())) {
            for (class_2350 side : Iterate.directions) {
                IMultiStateCopycatBlockEntity cbe;
                class_2680 otherMaterial;
                class_2586 class_25862;
                class_2338 neighbour = this.method_11016().method_10093(side);
                class_2680 neighbourState = this.method_10997().method_8320(neighbour);
                if (neighbourState != wrapperState || !((class_25862 = this.method_10997().method_8321(neighbour)) instanceof IMultiStateCopycatBlockEntity) || !(otherMaterial = (cbe = (IMultiStateCopycatBlockEntity)class_25862).getMaterialItemStorage().getMaterialItem(property).material()).method_27852(blockState.method_26204())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        MaterialItemStorage.MaterialItem materialItem = this.getMaterialItemStorage().getMaterialItem(property);
        materialItem.setMaterial(blockState);
        this.getMaterialItemStorage().storeMaterialItem(property, materialItem);
        BlockEntityUtils.redraw((class_2586)this);
    }

    default public boolean cycleMaterial(String property) {
        class_2680 material = this.getMaterialItemStorage().getMaterialItem(property).material();
        if (material.method_28498((class_2769)class_2533.field_11625) && material.method_28500((class_2769)class_2533.field_11631).orElse(false).booleanValue()) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2533.field_11625));
        } else if (material.method_28498((class_2769)class_2741.field_12525)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2741.field_12525));
        } else if (material.method_28498((class_2769)class_2741.field_12481)) {
            this.setMaterial(property, (class_2680)material.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)material.method_11654((class_2769)class_2741.field_12481)).method_10170()));
        } else if (material.method_28498((class_2769)class_2741.field_12496)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2741.field_12496));
        } else if (material.method_28498((class_2769)class_2741.field_12529)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2741.field_12529));
        } else if (material.method_28498((class_2769)class_2741.field_12548)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2741.field_12548));
        } else if (material.method_28498((class_2769)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    default public void setConsumedItem(String property, class_1799 itemStack) {
        this.getMaterialItemStorage().getMaterialItem(property).setConsumedItem(itemStack);
        this.notifyUpdate();
    }

    default public void setEnableCT(String property, boolean value) {
        this.getMaterialItemStorage().getMaterialItem(property).setEnableCT(value);
        this.notifyUpdate();
    }

    @Override
    default public ItemRequirement getRequiredItems(class_2680 state) {
        return new ItemRequirement(this.getMaterialItemStorage().getAllConsumedItems().stream().map(stack -> new ItemRequirement.StackRequirement(stack, ItemRequirement.ItemUseType.CONSUME)).toList());
    }

    @Override
    default public void transform(StructureTransform transform) {
        this.getBlock().transformStorage(this.method_11010(), this, transform);
        for (String key : this.getMaterialItemStorage().getAllProperties()) {
            this.getMaterialItemStorage().getMaterialItem(key).setMaterial(transform.apply(this.getMaterialItemStorage().getMaterialItem(key).material()));
        }
        this.notifyUpdate();
    }

    public static void read(IMultiStateCopycatBlockEntity self, class_2487 tag, boolean clientPacket) {
        boolean anyUpdated;
        if (self.method_11010().method_26204() instanceof IMultiStateCopycatBlock && (anyUpdated = self.getMaterialItemStorage().deserialize(tag.method_10562("material_data")))) {
            BlockEntityUtils.redraw((class_2586)self);
        }
    }

    public static void writeSafe(IMultiStateCopycatBlockEntity self, class_2487 tag) {
        BlockEntityUtils.saveMetadata((class_2586)self, tag);
        tag.method_10566("material_data", (class_2520)self.getMaterialItemStorage().serializeSafe());
    }

    public static void write(IMultiStateCopycatBlockEntity self, class_2487 tag, boolean clientPacket) {
        tag.method_10566("material_data", (class_2520)self.getMaterialItemStorage().serialize());
    }
}

