/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.serverbound;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.IPacket;

public class SingleNotePacket
implements IPacket {
    public static final class_2960 ID = new class_2960("xercamusic", "single_note");
    private int note;
    private IItemInstrument instrumentItem;
    private boolean isStop;
    private float volume;
    private boolean messageIsValid;

    public SingleNotePacket(int note, IItemInstrument itemInstrument, boolean isStop, float volume) {
        this.note = note;
        this.instrumentItem = itemInstrument;
        this.isStop = isStop;
        this.volume = volume;
    }

    public SingleNotePacket() {
        this.messageIsValid = false;
    }

    public static SingleNotePacket decode(class_2540 buf) {
        SingleNotePacket result = new SingleNotePacket();
        try {
            result.note = buf.readInt();
            int instrumentId = buf.readInt();
            result.isStop = buf.readBoolean();
            result.volume = buf.readFloat();
            if (instrumentId < 0 || instrumentId >= Items.instruments.length) {
                throw new IndexOutOfBoundsException("Invalid instrumentId: " + instrumentId);
            }
            result.instrumentItem = Items.instruments[instrumentId];
        }
        catch (IndexOutOfBoundsException ioe) {
            XercaMusic.LOGGER.error("Exception while reading SingleNotePacket: {}", (Throwable)ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(this.note);
        buf.writeInt(this.instrumentItem.getInstrumentId());
        buf.writeBoolean(this.isStop());
        buf.writeFloat(this.getVolume());
        return buf;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public int getNote() {
        return this.note;
    }

    public void setNote(int note) {
        this.note = note;
    }

    public IItemInstrument getInstrumentItem() {
        return this.instrumentItem;
    }

    public void setInstrumentItem(IItemInstrument instrumentItem) {
        this.instrumentItem = instrumentItem;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public void setStop(boolean stop) {
        this.isStop = stop;
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    public float getVolume() {
        return this.volume;
    }
}

