/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.serverbound;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.packets.IPacket;

public class SendNotesPartToServerPacket
implements IPacket {
    public static final class_2960 ID = new class_2960("xercamusic", "send_notes_part_to_server");
    private UUID uuid;
    private int partsCount;
    private int partId;
    private List<NoteEvent> notes;
    private boolean messageIsValid;

    public SendNotesPartToServerPacket(UUID uuid, int partsCount, int partId, List<NoteEvent> notes) {
        this.uuid = uuid;
        this.partsCount = partsCount;
        this.partId = partId;
        this.notes = notes;
    }

    public SendNotesPartToServerPacket() {
        this.messageIsValid = false;
    }

    public static SendNotesPartToServerPacket decode(class_2540 buf) {
        SendNotesPartToServerPacket result = new SendNotesPartToServerPacket();
        try {
            result.uuid = buf.method_10790();
            result.partsCount = buf.readInt();
            result.partId = buf.readInt();
            int eventCount = buf.readInt();
            if (eventCount > 0) {
                result.notes = new ArrayList<NoteEvent>(eventCount);
                for (int i = 0; i < eventCount; ++i) {
                    result.notes.add(NoteEvent.fromBuffer(buf));
                }
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading SendNotesPartToServerPacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(this.uuid);
        buf.writeInt(this.partsCount);
        buf.writeInt(this.partId);
        buf.writeInt(this.notes.size());
        for (NoteEvent event : this.notes) {
            event.encodeToBuffer(buf);
        }
        return buf;
    }

    public List<NoteEvent> getNotes() {
        return this.notes;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public int getPartsCount() {
        return this.partsCount;
    }

    public void setPartsCount(int partsCount) {
        this.partsCount = partsCount;
    }

    public int getPartId() {
        return this.partId;
    }

    public void setPartId(int partId) {
        this.partId = partId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public class_2960 getID() {
        return ID;
    }
}

