/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.serverbound;

import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.packets.IPacket;

public class ImportMusicSendPacket
implements IPacket {
    public static final class_2960 ID = new class_2960("xercamusic", "import_music_send");
    private UUID uuid;
    private class_2487 tag;
    private ArrayList<NoteEvent> notes;
    private boolean messageIsValid;

    public ImportMusicSendPacket(class_2487 tag) throws NotesTooLargeException {
        this.tag = tag;
        if (this.tag.method_10545("id")) {
            this.uuid = tag.method_25926("id");
        }
        if (this.tag.method_10545("notes")) {
            this.notes = new ArrayList();
            NoteEvent.fillArrayFromNBT(this.notes, this.tag);
            this.tag.method_10551("notes");
            if (this.notes.size() > 5000) {
                throw new NotesTooLargeException(this.notes, this.uuid);
            }
        }
    }

    public ImportMusicSendPacket() {
        this.messageIsValid = false;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        if (this.notes != null) {
            buf.writeInt(this.notes.size());
            for (NoteEvent event : this.notes) {
                event.encodeToBuffer(buf);
            }
        } else {
            buf.writeInt(0);
        }
        buf.method_10794(this.tag);
        return buf;
    }

    public static ImportMusicSendPacket decode(class_2540 buf) {
        ImportMusicSendPacket result = new ImportMusicSendPacket();
        try {
            int eventCount = buf.readInt();
            if (eventCount > 0) {
                result.notes = new ArrayList(eventCount);
                for (int i = 0; i < eventCount; ++i) {
                    result.notes.add(NoteEvent.fromBuffer(buf));
                }
            }
            result.tag = buf.method_10798();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading ImportMusicSendPacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public ArrayList<NoteEvent> getNotes() {
        return this.notes;
    }

    public void deleteNotes() {
        this.notes = null;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    public static class NotesTooLargeException
    extends Exception {
        public ArrayList<NoteEvent> notes;
        public UUID id;

        public NotesTooLargeException(ArrayList<NoteEvent> notes, UUID id) {
            this.notes = notes;
            this.id = id;
        }
    }
}

