/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.clientbound;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.IPacket;

public class TripleNoteClientPacket
implements IPacket {
    public static final class_2960 ID = new class_2960("xercamusic", "triple_note_client");
    private int note1;
    private int note2;
    private int note3;
    private IItemInstrument instrumentItem;
    private class_1297 entity;
    private boolean messageIsValid;

    public TripleNoteClientPacket(int note1, int note2, int note3, IItemInstrument itemInstrument, class_1297 entity) {
        this.note1 = note1;
        this.note2 = note2;
        this.note3 = note3;
        this.instrumentItem = itemInstrument;
        this.entity = entity;
    }

    public TripleNoteClientPacket() {
        this.messageIsValid = false;
    }

    public static TripleNoteClientPacket decode(class_2540 buf) {
        TripleNoteClientPacket result = new TripleNoteClientPacket();
        try {
            result.note1 = buf.readInt();
            result.note2 = buf.readInt();
            result.note3 = buf.readInt();
            int instrumentId = buf.readInt();
            int entityId = buf.readInt();
            if (instrumentId < 0 || instrumentId >= Items.instruments.length) {
                throw new IndexOutOfBoundsException("Invalid instrumentId: " + instrumentId);
            }
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return null;
            }
            result.entity = level.method_8469(entityId);
            result.instrumentItem = Items.instruments[instrumentId];
        }
        catch (IndexOutOfBoundsException ioe) {
            XercaMusic.LOGGER.error("Exception while reading SingleNotePacket: {}", (Throwable)ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        int instrumentId = this.getInstrumentItem().getInstrumentId();
        int entityId = this.getEntity().method_5628();
        buf.writeInt(this.getNote1());
        buf.writeInt(this.getNote2());
        buf.writeInt(this.getNote3());
        buf.writeInt(instrumentId);
        buf.writeInt(entityId);
        return buf;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public int getNote1() {
        return this.note1;
    }

    public void setNote1(int note) {
        this.note1 = note;
    }

    public int getNote2() {
        return this.note2;
    }

    public void setNote2(int note) {
        this.note2 = note;
    }

    public int getNote3() {
        return this.note3;
    }

    public void setNote3(int note) {
        this.note3 = note;
    }

    public IItemInstrument getInstrumentItem() {
        return this.instrumentItem;
    }

    public void setInstrumentItem(IItemInstrument instrumentItem) {
        this.instrumentItem = instrumentItem;
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    public void setEntity(class_1297 entity) {
        this.entity = entity;
    }

    @Override
    public class_2960 getID() {
        return ID;
    }
}

