/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.clientbound;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.IPacket;

public class SingleNoteClientPacket
implements IPacket {
    public static final class_2960 ID = new class_2960("xercamusic", "single_note_client");
    private int note;
    private IItemInstrument instrumentItem;
    private class_1657 playerEntity;
    private boolean isStop;
    private float volume;
    private boolean messageIsValid;

    public SingleNoteClientPacket(int note, IItemInstrument itemInstrument, class_1657 playerEntity, boolean isStop, float volume) {
        this.note = note;
        this.instrumentItem = itemInstrument;
        this.playerEntity = playerEntity;
        this.isStop = isStop;
        this.volume = volume;
    }

    public SingleNoteClientPacket() {
        this.messageIsValid = false;
    }

    public static SingleNoteClientPacket decode(class_2540 buf) {
        SingleNoteClientPacket result = new SingleNoteClientPacket();
        try {
            result.note = buf.readInt();
            int instrumentId = buf.readInt();
            int playerId = buf.readInt();
            result.isStop = buf.readBoolean();
            result.volume = buf.readFloat();
            if (instrumentId < 0 || instrumentId >= Items.instruments.length) {
                throw new IndexOutOfBoundsException("Invalid instrumentId: " + instrumentId);
            }
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return null;
            }
            class_1297 entity = level.method_8469(playerId);
            if (!(entity instanceof class_1657)) {
                throw new IndexOutOfBoundsException("Invalid playerId: " + playerId);
            }
            result.playerEntity = (class_1657)entity;
            result.instrumentItem = Items.instruments[instrumentId];
        }
        catch (IndexOutOfBoundsException ioe) {
            XercaMusic.LOGGER.error("Exception while reading SingleNotePacket: {}", (Throwable)ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        int instrumentId = this.getInstrumentItem().getInstrumentId();
        int playerId = this.getPlayerEntity().method_5628();
        buf.writeInt(this.getNote());
        buf.writeInt(instrumentId);
        buf.writeInt(playerId);
        buf.writeBoolean(this.isStop());
        buf.writeFloat(this.getVolume());
        return buf;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public int getNote() {
        return this.note;
    }

    public void setNote(int note) {
        this.note = note;
    }

    public IItemInstrument getInstrumentItem() {
        return this.instrumentItem;
    }

    public void setInstrumentItem(IItemInstrument instrumentItem) {
        this.instrumentItem = instrumentItem;
    }

    public class_1657 getPlayerEntity() {
        return this.playerEntity;
    }

    public void setPlayerEntity(class_1657 playerEntity) {
        this.playerEntity = playerEntity;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public void setStop(boolean stop) {
        this.isStop = stop;
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    public float getVolume() {
        return this.volume;
    }
}

