/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.entity;

import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.client.SoundController;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockInstrument;
import xerca.xercamusic.common.entity.Entities;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemBlockInstrument;
import xerca.xercamusic.common.item.Items;

public class EntityMusicSpirit
extends class_1297 {
    public static final class_2960 spawnPacketId = new class_2960("xercamusic", "spawn_music_spirit");
    private class_1657 body;
    private class_1799 note;
    private IItemInstrument instrument;
    private final ArrayList<NoteEvent> notes = new ArrayList();
    private int mLengthBeats;
    private float mVolume;
    private byte mBPS;
    private boolean isPlaying = true;
    private BlockInstrument blockInstrument = null;
    private class_2338 blockInsPos = null;
    private SoundController soundController = null;

    public EntityMusicSpirit(class_1937 worldIn) {
        super(Entities.MUSIC_SPIRIT, worldIn);
    }

    public EntityMusicSpirit(class_1937 worldIn, class_1657 body, IItemInstrument instrument) {
        this(worldIn);
        this.body = body;
        this.instrument = instrument;
        this.setNoteFromBody();
        this.method_5814(body.method_23317(), body.method_23318(), body.method_23321());
    }

    public EntityMusicSpirit(class_1937 worldIn, class_1657 body, class_2338 blockInsPos, IItemInstrument instrument) {
        this(worldIn, body, instrument);
        this.setBlockPosAndInstrument(blockInsPos, instrument.getInstrumentId());
    }

    public EntityMusicSpirit(class_1299<EntityMusicSpirit> type, class_1937 world) {
        super(type, world);
    }

    private void setBlockPosAndInstrument(class_2338 pos, int instrumentId) {
        IItemInstrument instrument;
        if (instrumentId < Items.instruments.length && (instrument = Items.instruments[instrumentId]) instanceof ItemBlockInstrument) {
            ItemBlockInstrument itemBlockInstrument = (ItemBlockInstrument)instrument;
            this.blockInstrument = (BlockInstrument)itemBlockInstrument.method_7711();
            this.blockInsPos = pos;
            this.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() - 0.5, (double)pos.method_10260() + 0.5);
            return;
        }
        XercaMusic.LOGGER.warn("Got invalid block as instrument");
        this.blockInstrument = null;
        this.blockInsPos = null;
    }

    private boolean isBodyHandLegit() {
        class_1799 mainStack = this.body.method_6047();
        class_1799 offStack = this.body.method_6079();
        if (this.blockInstrument != null && this.blockInsPos != null) {
            return mainStack.method_7909() == Items.MUSIC_SHEET || offStack.method_7909() == Items.MUSIC_SHEET;
        }
        return offStack.method_7909() == Items.MUSIC_SHEET && mainStack.method_7909() == this.instrument;
    }

    private void setNoteFromBody() {
        if (this.body == null) {
            XercaMusic.LOGGER.warn("Body is null in MusicSpirit setNoteFromBody");
            return;
        }
        class_1799 mainStack = this.body.method_6047();
        class_1799 offStack = this.body.method_6079();
        if (mainStack.method_7909() == Items.MUSIC_SHEET) {
            this.note = mainStack;
        } else if (offStack.method_7909() == Items.MUSIC_SHEET) {
            this.note = offStack;
        } else {
            XercaMusic.LOGGER.warn("No music sheet found on body");
        }
    }

    protected void method_5749(@NotNull class_2487 tag) {
        NoteEvent.fillArrayFromNBT(this.notes, tag);
        this.mLengthBeats = tag.method_10550("l");
        this.mBPS = tag.method_10571("bps");
        this.mVolume = tag.method_10583("vol");
        this.isPlaying = tag.method_10577("playing");
        if (tag.method_10545("bX") && tag.method_10545("bY") && tag.method_10545("bZ") && tag.method_10545("bIns")) {
            this.setBlockPosAndInstrument(new class_2338(tag.method_10550("bX"), tag.method_10550("bY"), tag.method_10550("bZ")), tag.method_10550("bIns"));
        }
    }

    protected void method_5652(@NotNull class_2487 tag) {
        NoteEvent.fillNBTFromArray(this.notes, tag);
        tag.method_10569("l", this.mLengthBeats);
        tag.method_10567("bps", this.mBPS);
        tag.method_10548("vol", this.mVolume);
        tag.method_10556("playing", this.isPlaying);
        if (this.blockInstrument != null && this.blockInsPos != null) {
            tag.method_10569("bX", this.blockInsPos.method_10263());
            tag.method_10569("bY", this.blockInsPos.method_10264());
            tag.method_10569("bZ", this.blockInsPos.method_10260());
            tag.method_10569("bIns", this.blockInstrument.getItemInstrument().getInstrumentId());
        }
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        class_2540 buffer = PacketByteBufs.create();
        class_2604 pack = new class_2604((class_1297)this);
        pack.method_11052(buffer);
        this.writeSpawnData(buffer);
        return ServerPlayNetworking.createS2CPacket((class_2960)spawnPacketId, (class_2540)buffer);
    }

    public void writeSpawnData(class_2540 buffer) {
        buffer.writeInt(this.body != null ? this.body.method_5628() : -1);
        if (this.blockInstrument != null && this.blockInsPos != null) {
            buffer.writeInt(this.blockInsPos.method_10263());
            buffer.writeInt(this.blockInsPos.method_10264());
            buffer.writeInt(this.blockInsPos.method_10260());
            buffer.writeInt(this.blockInstrument.getItemInstrument().getInstrumentId());
        } else {
            buffer.writeInt(-1);
            buffer.writeInt(-1000);
            buffer.writeInt(-1);
            buffer.writeInt(-1);
        }
    }

    public void readSpawnData(class_2540 buffer) {
        int entityId = buffer.readInt();
        class_1297 ent = this.method_37908().method_8469(entityId);
        if (ent instanceof class_1657) {
            this.body = (class_1657)ent;
        }
        int bx = buffer.readInt();
        int by = buffer.readInt();
        int bz = buffer.readInt();
        int bIns = buffer.readInt();
        if (by > -1000) {
            this.setBlockPosAndInstrument(new class_2338(bx, by, bz), bIns);
        }
        if (this.blockInsPos != null) {
            this.instrument = this.blockInstrument.getItemInstrument();
            this.setNoteFromBody();
        } else if (this.body != null) {
            class_1792 item = this.body.method_6047().method_7909();
            if (item instanceof IItemInstrument) {
                IItemInstrument ins;
                this.instrument = ins = (IItemInstrument)item;
                this.note = this.body.method_6079();
                this.method_5814(this.body.method_23317(), this.body.method_23318(), this.body.method_23321());
            } else {
                XercaMusic.LOGGER.warn("Could not find instrument when spawning music spirit!");
                return;
            }
        }
        if (this.note != null && this.note.method_7985() && this.note.method_7969() != null && this.note.method_7969().method_10545("id") && this.note.method_7969().method_10545("ver") && this.note.method_7969().method_10545("l")) {
            class_2487 comp = this.note.method_7969();
            this.mLengthBeats = comp.method_10550("l");
            this.mBPS = (byte)(comp.method_10545("bps") ? (int)comp.method_10571("bps") : 8);
            this.mVolume = comp.method_10545("vol") ? comp.method_10583("vol") : 1.0f;
            UUID id = comp.method_25926("id");
            int ver = comp.method_10550("ver");
            if (this.method_37908().field_9236) {
                MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                    if (data != null) {
                        this.notes.addAll(data.notes);
                    }
                    this.soundController = new SoundController(this.notes, this.method_23317(), this.method_23318(), this.method_23321(), this.instrument, this.mBPS, this.mVolume, this.method_5628());
                    this.soundController.start();
                });
            }
        }
    }

    protected void method_5693() {
    }

    public void method_36209() {
        if (this.soundController != null) {
            this.soundController.setStop();
        }
    }

    public void method_5773() {
        if (!this.method_37908().field_9236) {
            if (this.body == null || !this.isPlaying) {
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
            if (!this.isBodyHandLegit()) {
                this.isPlaying = false;
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
            if (this.blockInsPos != null && this.blockInstrument != null) {
                if (this.method_37908().method_8320(this.blockInsPos).method_26204() != this.blockInstrument) {
                    this.method_5650(class_1297.class_5529.field_26999);
                    return;
                }
                if (this.method_19538().method_1025(this.body.method_19538()) > 16.0) {
                    this.method_5650(class_1297.class_5529.field_26999);
                    return;
                }
            }
        }
        super.method_5773();
        if ((this.blockInsPos == null || this.blockInstrument == null) && this.body != null) {
            this.method_5814(this.body.method_23317(), this.body.method_23318(), this.body.method_23321());
            if (this.soundController != null) {
                this.soundController.setPos(this.method_23317(), this.method_23318(), this.method_23321());
            }
        }
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public class_1657 getBody() {
        return this.body;
    }
}

