/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.serverbound.SendNotesPartToServerPacket;

public class MusicManager {
    public static final Map<UUID, TempNotesBuffer> TEMP_NOTES_MAP = new HashMap<UUID, TempNotesBuffer>();

    public static MusicData getMusicData(UUID id, int ver, MinecraftServer server) {
        SavedDataMusic savedDataMusic = (SavedDataMusic)server.method_30002().method_17983().method_17924(SavedDataMusic::load, SavedDataMusic::new, "music_map");
        Map<UUID, MusicData> musicMap = savedDataMusic.getMusicMap();
        if (musicMap.containsKey(id)) {
            MusicData data = musicMap.get(id);
            if (data.version >= ver) {
                XercaMusic.LOGGER.debug("Music data found in server (id: {}, ver: {}) (getMusicData)", (Object)id, (Object)ver);
                return data;
            }
            XercaMusic.LOGGER.debug("Music data in server is too old (id: {}, data ver: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)data.version, (Object)ver);
        } else {
            XercaMusic.LOGGER.debug("Music data not found in server (id: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)ver);
        }
        return null;
    }

    public static void setMusicData(UUID id, int ver, ArrayList<NoteEvent> notes, MinecraftServer server) {
        SavedDataMusic savedDataMusic = (SavedDataMusic)server.method_30002().method_17983().method_17924(SavedDataMusic::load, SavedDataMusic::new, "music_map");
        Map<UUID, MusicData> musicMap = savedDataMusic.getMusicMap();
        musicMap.put(id, new MusicData(ver, notes));
        savedDataMusic.method_80();
    }

    public static ArrayList<NoteEvent> getFinishedNotesFromBuffer(UUID id) {
        if (TEMP_NOTES_MAP.containsKey(id)) {
            TempNotesBuffer buffer = TEMP_NOTES_MAP.get(id);
            if (buffer.isFinished()) {
                return buffer.joinParts();
            }
            XercaMusic.LOGGER.warn("Packet did not have notes, and temp buffer was not finished");
        } else {
            XercaMusic.LOGGER.warn("Packet did not have notes, and temp buffer was not found");
        }
        return null;
    }

    public static boolean addNotesPart(SendNotesPartToServerPacket pkt) {
        TempNotesBuffer buffer;
        if (TEMP_NOTES_MAP.containsKey(pkt.getUuid())) {
            buffer = TEMP_NOTES_MAP.get(pkt.getUuid());
            buffer.addPart(pkt.getPartId(), pkt.getNotes());
        } else {
            buffer = new TempNotesBuffer(pkt.getPartsCount());
            buffer.addPart(pkt.getPartId(), pkt.getNotes());
            TEMP_NOTES_MAP.put(pkt.getUuid(), buffer);
        }
        return buffer.isFinished();
    }

    public static class SavedDataMusic
    extends class_18 {
        private final Map<UUID, MusicData> musicMap;

        private SavedDataMusic(Map<UUID, MusicData> musicMap) {
            this.musicMap = musicMap;
        }

        public SavedDataMusic() {
            this(new HashMap<UUID, MusicData>());
        }

        public static SavedDataMusic load(class_2487 tag) {
            class_2520 musicTag = tag.method_10580("MusicDataList");
            if (musicTag instanceof class_2499) {
                class_2499 musicDataList = (class_2499)musicTag;
                HashMap<UUID, MusicData> musicDataMap = new HashMap<UUID, MusicData>();
                for (class_2520 nbt : musicDataList) {
                    if (!(nbt instanceof class_2487)) continue;
                    class_2487 musicData = (class_2487)nbt;
                    ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
                    NoteEvent.fillArrayFromNBT(notes, musicData);
                    musicDataMap.put(musicData.method_25926("id"), new MusicData(musicData.method_10550("ver"), notes));
                }
                return new SavedDataMusic(musicDataMap);
            }
            return new SavedDataMusic();
        }

        @NotNull
        public class_2487 method_75(@NotNull class_2487 tag) {
            class_2499 musicDataList = new class_2499();
            for (Map.Entry<UUID, MusicData> entry : this.musicMap.entrySet()) {
                class_2487 nbt = new class_2487();
                nbt.method_25927("id", entry.getKey());
                nbt.method_10569("ver", entry.getValue().version);
                NoteEvent.fillNBTFromArray(entry.getValue().notes, nbt);
                musicDataList.add((Object)nbt);
            }
            tag.method_10566("MusicDataList", (class_2520)musicDataList);
            return tag;
        }

        public Map<UUID, MusicData> getMusicMap() {
            return this.musicMap;
        }
    }

    public static class MusicData {
        public final int version;
        public final ArrayList<NoteEvent> notes;

        public MusicData(int version, ArrayList<NoteEvent> notes) {
            this.version = version;
            this.notes = notes;
        }
    }

    public static class TempNotesBuffer {
        final int partsCount;
        final boolean[] finishedParts;
        final List<List<NoteEvent>> notesParts;

        public TempNotesBuffer(int partsCount) {
            this.partsCount = partsCount;
            this.finishedParts = new boolean[partsCount];
            this.notesParts = new ArrayList<List<NoteEvent>>(partsCount);
            for (int i = 0; i < partsCount; ++i) {
                this.notesParts.add(new ArrayList());
            }
        }

        public void addPart(int partId, List<NoteEvent> part) {
            if (partId < this.partsCount && partId >= 0) {
                this.notesParts.set(partId, part);
                this.finishedParts[partId] = true;
            }
        }

        public boolean isFinished() {
            boolean result = true;
            for (boolean f : this.finishedParts) {
                result &= f;
            }
            return result;
        }

        public ArrayList<NoteEvent> joinParts() {
            ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>(this.partsCount * 5000);
            for (List<NoteEvent> notesPart : this.notesParts) {
                notes.addAll(notesPart);
            }
            return notes;
        }
    }
}

