/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.serverbound.MusicDataRequestPacket;

public class MusicManagerClient {
    static final Map<UUID, MusicManager.MusicData> musicMap = new HashMap<UUID, MusicManager.MusicData>();
    static final Map<UUID, Runnable> taskMap = new HashMap<UUID, Runnable>();
    static final String cacheDir = "music_sheets/.cache/";

    public static void load() {
        File[] directoryListing;
        File directory = new File(cacheDir);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if ((directoryListing = directory.listFiles()) != null) {
            for (File file : directoryListing) {
                String fileName = file.getName();
                try {
                    UUID id = UUID.fromString(fileName);
                    class_2487 tag = class_2507.method_30613((File)file);
                    if (tag.method_10545("id") && id.equals(tag.method_25926("id")) && tag.method_10545("ver") && tag.method_10545("notes")) {
                        int version = tag.method_10550("ver");
                        ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
                        NoteEvent.fillArrayFromNBT(notes, tag);
                        musicMap.put(id, new MusicManager.MusicData(version, notes));
                        continue;
                    }
                    file.delete();
                }
                catch (IOException | IllegalArgumentException e) {
                    file.delete();
                }
            }
        }
    }

    public static void checkMusicDataAndRun(UUID id, int ver, Runnable task) {
        if (musicMap.containsKey(id)) {
            MusicManager.MusicData data = musicMap.get(id);
            if (data.version >= ver) {
                XercaMusic.LOGGER.debug("Music data found in client (id: {}, requested ver: {}) (checkMusicDataAndRun)", (Object)id, (Object)ver);
                task.run();
                return;
            }
            XercaMusic.LOGGER.info("Music data in client is too old (id: {}, data ver: {}, requested ver: {}) (checkMusicDataAndRun)", (Object)id, (Object)data.version, (Object)ver);
        }
        XercaMusic.LOGGER.info("Requesting music data from server (id: {}, requested ver: {}) (checkMusicDataAndRun)", (Object)id, (Object)ver);
        taskMap.put(id, task);
        MusicDataRequestPacket packet = new MusicDataRequestPacket(id, ver);
        ClientStuff.sendToServer(packet);
    }

    public static MusicManager.MusicData getMusicData(UUID id, int ver) {
        if (musicMap.containsKey(id)) {
            MusicManager.MusicData data = musicMap.get(id);
            if (data.version >= ver) {
                XercaMusic.LOGGER.debug("Music data found in client (id: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)ver);
                return data;
            }
            XercaMusic.LOGGER.info("Music data in client is too old (id: {}, data ver: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)data.version, (Object)ver);
        }
        XercaMusic.LOGGER.info("Requesting music data from server (id: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)ver);
        MusicDataRequestPacket packet = new MusicDataRequestPacket(id, ver);
        ClientStuff.sendToServer(packet);
        return null;
    }

    public static void setMusicData(UUID id, int ver, ArrayList<NoteEvent> notes) {
        musicMap.put(id, new MusicManager.MusicData(ver, notes));
        String filename = id.toString();
        String filepath = "music_sheets/.cache//" + filename;
        File directory = new File(cacheDir);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        class_2487 tag = new class_2487();
        tag.method_25927("id", id);
        tag.method_10569("ver", ver);
        NoteEvent.fillNBTFromArray(notes, tag);
        try {
            class_2507.method_30614((class_2487)tag, (File)new File(filepath));
        }
        catch (IOException e) {
            XercaMusic.LOGGER.warn("Could not write music data to cache file: {}", (Object)filepath);
            e.printStackTrace();
        }
        if (taskMap.containsKey(id)) {
            Runnable task = taskMap.get(id);
            taskMap.remove(id);
            task.run();
        }
    }
}

