/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.client.MidiHandler;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.block.BlockInstrument;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.packets.serverbound.SingleNotePacket;

public class GuiInstrument
extends class_437 {
    private static final class_2960 insGuiTextures = new class_2960("xercamusic", "textures/gui/instrument_gui.png");
    private int guiBaseX = 45;
    private int guiBaseY = 80;
    private final boolean[] buttonPushStates;
    private final NoteSound[] noteSounds;
    private static int currentKeyboardOctave = 0;
    private static final int guiHeight = 201;
    private static final int guiWidth = 401;
    private static final int guiMarginWidth = 7;
    private static final int guiNoteWidth = 8;
    private static final int guiOctaveWidth = 97;
    private static final int guiOctaveHighlightY = 212;
    private static final int guiOctaveHighlightWidth = 98;
    private static final int guiOctaveHighlightHeight = 92;
    private static final int guiTopKeyboardBottom = 94;
    private static final int guiBottomKeyboardTop = 105;
    private static final int guiOctaveBlockX = 99;
    private static final int guiOctaveBlockY = 212;
    private static final int guiOctaveBlockWidth = 95;
    private static final int guiOctaveBlockHeight = 82;
    private int octaveButtonX;
    private final int octaveButtonY = 30;
    private final class_1657 player;
    private final IItemInstrument instrument;
    private final class_2338 blockInsPos;
    private final MidiHandler midiHandler;

    GuiInstrument(class_1657 player, IItemInstrument instrument, class_2561 title, @Nullable class_2338 blockInsPos) {
        super(title);
        this.player = player;
        this.instrument = instrument;
        this.buttonPushStates = new boolean[96];
        this.noteSounds = new NoteSound[96];
        this.midiHandler = new MidiHandler(this::playSound, this::stopSound);
        this.blockInsPos = blockInsPos;
        if (currentKeyboardOctave < instrument.getMinOctave()) {
            currentKeyboardOctave = instrument.getMinOctave();
        } else if (currentKeyboardOctave > instrument.getMaxOctave()) {
            currentKeyboardOctave = instrument.getMaxOctave();
        }
        this.midiHandler.currentOctave = currentKeyboardOctave;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        this.guiBaseX = (this.field_22789 - 401) / 2;
        this.guiBaseY = (this.field_22790 - 201) / 2;
        this.octaveButtonX = this.guiBaseX - 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.upButton"), button -> this.increaseOctave()).method_46434(this.octaveButtonX, 30, 10, 10).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"ins.octaveTooltip"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.downButton"), button -> this.decreaseOctave()).method_46434(this.octaveButtonX, 55, 10, 10).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"ins.octaveTooltip"))).method_46431());
    }

    public void method_25393() {
        super.method_25393();
        if (this.blockInsPos != null && this.field_22787 != null) {
            class_2248 class_22482 = this.player.method_37908().method_8320(this.blockInsPos).method_26204();
            if (class_22482 instanceof BlockInstrument) {
                BlockInstrument blockIns = (BlockInstrument)class_22482;
                if (blockIns.getItemInstrument() != this.instrument) {
                    this.field_22787.method_1507(null);
                }
            } else {
                this.field_22787.method_1507(null);
            }
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)insGuiTextures);
        guiGraphics.method_25291(insGuiTextures, this.guiBaseX, this.guiBaseY, 0, 0.0f, 0.0f, 401, 201, 512, 512);
        for (int i = 0; i < this.buttonPushStates.length; ++i) {
            if (!this.buttonPushStates[i]) continue;
            int pushedOctave = i / 12;
            int x = this.guiBaseX + 7 + i * 8 + pushedOctave;
            int y = this.guiBaseY + 11;
            if (pushedOctave > 3) {
                x -= 388;
                y = this.guiBaseY + 105 + 2;
            }
            guiGraphics.method_25291(insGuiTextures, x, y, 0, 402.0f, 11.0f, 7, 82, 512, 512);
        }
        int currentKeyboardOctaveDraw = Math.max(0, currentKeyboardOctave);
        int octaveHighlightX = this.guiBaseX + 7 + currentKeyboardOctaveDraw * 97 - 1;
        int octaveHighlightY = this.guiBaseY + 3;
        if (currentKeyboardOctave > 3) {
            octaveHighlightX -= 388;
            octaveHighlightY = this.guiBaseY + 105 - 6;
        }
        guiGraphics.method_25293(insGuiTextures, octaveHighlightX, octaveHighlightY, 0, 0, 0.0f, 212.0f, 98, 92, 512, 512);
        for (int i = 0; i < 8; ++i) {
            if (i >= this.instrument.getMinOctave() && i <= this.instrument.getMaxOctave()) continue;
            int x = this.guiBaseX + 7 + i * 97;
            int y = this.guiBaseY + 11;
            if (i > 3) {
                x -= 388;
                y = this.guiBaseY + 105 + 2;
            }
            guiGraphics.method_25293(insGuiTextures, x, y, 0, 0, 99.0f, 212.0f, 95, 82, 512, 512);
        }
        guiGraphics.method_25300(this.field_22793, "" + currentKeyboardOctave, this.octaveButtonX + 4, 44, -1);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private int noteIdFromPos(int mouseX, int mouseY) {
        int buttonBaseX = this.guiBaseX + 7;
        if (mouseX >= buttonBaseX && mouseX <= buttonBaseX + 401 - 14 && mouseY >= this.guiBaseY + 9 && mouseY <= this.guiBaseY + 201 - 10 && (mouseY < this.guiBaseY + 94 || mouseY > this.guiBaseY + 105)) {
            int octavePlus = mouseY < this.guiBaseY + 94 ? 0 : 4;
            int octave = octavePlus + (mouseX - buttonBaseX) / 97;
            int note = (mouseX - buttonBaseX) % 97 / 8;
            if (note < 12) {
                return octave * 12 + note;
            }
        }
        return -1;
    }

    private void playSound(int noteId) {
        this.playSound(new MidiHandler.MidiData(noteId, 0.8f));
    }

    private void playSound(MidiHandler.MidiData data) {
        int noteId = data.noteId();
        if (noteId >= 0 && noteId < this.buttonPushStates.length && !this.buttonPushStates[noteId]) {
            int note = IItemInstrument.idToNote(noteId);
            IItemInstrument.InsSound noteSound = this.instrument.getSound(note);
            if (noteSound == null) {
                return;
            }
            this.noteSounds[noteId] = ClientStuff.playNote(noteSound.sound, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), data.volume(), noteSound.pitch);
            this.player.method_37908().method_8406((class_2394)class_2398.field_11224, this.player.method_23317(), this.player.method_23318() + 2.2, this.player.method_23321(), (double)note / 24.0, 0.0, 0.0);
            this.buttonPushStates[noteId] = true;
            SingleNotePacket pack = new SingleNotePacket(note, this.instrument, false, data.volume());
            ClientStuff.sendToServer(pack);
        }
    }

    private void stopSound(int noteId) {
        if (noteId >= 0 && noteId < this.buttonPushStates.length && this.buttonPushStates[noteId] && this.noteSounds[noteId] != null) {
            this.noteSounds[noteId].stopSound();
            this.noteSounds[noteId] = null;
            this.buttonPushStates[noteId] = false;
            int note = IItemInstrument.idToNote(noteId);
            SingleNotePacket pack = new SingleNotePacket(note, this.instrument, true, 1.0f);
            ClientStuff.sendToServer(pack);
        }
    }

    private void stopAllSounds() {
        for (int noteId = 0; noteId < this.buttonPushStates.length; ++noteId) {
            this.stopSound(noteId);
        }
    }

    public boolean method_25402(double dmouseX, double dmouseY, int mouseButton) {
        int mouseX = (int)Math.round(dmouseX);
        int mouseY = (int)Math.round(dmouseY);
        int noteId = this.noteIdFromPos(mouseX, mouseY);
        this.playSound(noteId);
        return super.method_25402((double)mouseX, (double)mouseY, mouseButton);
    }

    public boolean method_25406(double dmouseX, double dmouseY, int mouseButton) {
        int mouseX = (int)Math.round(dmouseX);
        int mouseY = (int)Math.round(dmouseY);
        int noteId = this.noteIdFromPos(mouseX, mouseY);
        this.stopSound(noteId);
        return super.method_25406(dmouseX, dmouseY, mouseButton);
    }

    public boolean method_25403(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        int currentNoteId;
        int prevMouseY;
        int mouseX = (int)Math.round(posX);
        int mouseY = (int)Math.round(posY);
        int prevMouseX = (int)Math.round(posX - deltaX);
        int prevNoteId = this.noteIdFromPos(prevMouseX, prevMouseY = (int)Math.round(posY - deltaY));
        if (prevNoteId != (currentNoteId = this.noteIdFromPos(mouseX, mouseY))) {
            this.stopSound(prevNoteId);
            this.playSound(currentNoteId);
        }
        return super.method_25403(posX, posY, mouseButton, deltaX, deltaY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.method_25395(null);
        super.method_25404(keyCode, scanCode, modifiers);
        if (scanCode >= 16 && scanCode <= 27) {
            int noteId = scanCode - 16 + 12 * Math.max(0, currentKeyboardOctave);
            this.playSound(noteId);
        }
        if (keyCode == 65) {
            this.decreaseOctave();
        } else if (keyCode == 83) {
            this.increaseOctave();
        }
        return true;
    }

    private void decreaseOctave() {
        if (currentKeyboardOctave > -3) {
            this.midiHandler.currentOctave = --currentKeyboardOctave;
            this.stopAllSounds();
        }
    }

    private void increaseOctave() {
        if (currentKeyboardOctave < this.instrument.getMaxOctave()) {
            this.midiHandler.currentOctave = ++currentKeyboardOctave;
            this.stopAllSounds();
        }
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (scanCode >= 16 && scanCode <= 27) {
            int noteId = scanCode - 16 + 12 * Math.max(0, currentKeyboardOctave);
            this.stopSound(noteId);
        }
        return true;
    }

    public void method_25432() {
        this.midiHandler.closeDevices();
    }
}

