/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class BetterSlider
extends class_357 {
    protected final class_2561 prefix;
    protected final class_2561 suffix;
    protected final double minValue;
    protected final double maxValue;
    protected final double interval;
    protected final double stepSize;
    protected final boolean drawString;
    private final DecimalFormat format;
    private static final class_2960 SLIDER_LOCATION = new class_2960("textures/gui/slider.png");

    public BetterSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, double stepSize, boolean drawString) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.interval = maxValue - minValue;
        this.stepSize = Math.abs(stepSize);
        this.field_22753 = this.snapToNearest((currentValue - minValue) / this.interval);
        this.drawString = drawString;
        this.format = class_3532.method_20390((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        this.method_25346();
    }

    public BetterSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, drawString);
    }

    public double getValue() {
        return this.field_22753 * this.interval + this.minValue;
    }

    public void setValue(double newValue) {
        this.field_22753 = this.snapToNearest((newValue - this.minValue) / this.interval);
        this.method_25346();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private void setSliderValue(double newValue) {
        double oldValue = this.field_22753;
        this.field_22753 = this.snapToNearest(newValue);
        if (!class_3532.method_20390((double)oldValue, (double)this.field_22753)) {
            this.method_25344();
        }
        this.method_25346();
    }

    private double snapToNearest(double sliderValue) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350((double)sliderValue, (double)0.0, (double)1.0);
        }
        sliderValue = class_3532.method_16436((double)class_3532.method_15350((double)sliderValue, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        sliderValue = this.stepSize * (double)Math.round(sliderValue / this.stepSize);
        sliderValue = this.minValue > this.maxValue ? class_3532.method_15350((double)sliderValue, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)sliderValue, (double)this.minValue, (double)this.maxValue);
        return class_3532.method_33722((double)sliderValue, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void renderBg(@NotNull class_4587 stack) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)field_22757);
        BetterSlider.blitWithBorder(stack, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 0, 66, 8, this.field_22759, 200, 20, 2, 3, 2, 2, 0.0f);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int p_93658_, int p_93659_, float p_93660_) {
        if (this.field_22764) {
            this.renderBg(guiGraphics.method_51448());
            super.method_25394(guiGraphics, p_93658_, p_93659_, p_93660_);
        }
    }

    public void method_48579(@NotNull class_332 guiGraphics, int i, int j, float f) {
        class_310 minecraft = class_310.method_1551();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.method_49697(SLIDER_LOCATION, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 20, 4, 200, 20, 0, this.getTextureY());
        guiGraphics.method_49697(SLIDER_LOCATION, this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364(), 20, 4, 200, 20, 0, this.getHandleTextureY());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        this.method_49604(guiGraphics, minecraft.field_1772, 2, k | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    private int getTextureY() {
        int i = this.method_25370() ? 1 : 0;
        return i * 20;
    }

    private int getHandleTextureY() {
        int i = !this.field_22762 ? 2 : 3;
        return i * 20;
    }

    public static void blitWithBorder(class_4587 poseStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        BetterSlider.drawTexturedModalRect(poseStack, x, y, u, v, leftBorder, topBorder, zLevel);
        BetterSlider.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        BetterSlider.drawTexturedModalRect(poseStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        BetterSlider.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            BetterSlider.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            BetterSlider.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                BetterSlider.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            BetterSlider.drawTexturedModalRect(poseStack, x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            BetterSlider.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(class_4587 poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        class_289 tesselator = class_289.method_1348();
        class_287 wr = tesselator.method_1349();
        wr.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        wr.method_22918(matrix, (float)x, (float)(y + height), zLevel).method_22913((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)x, (float)y, zLevel).method_22913((float)u * 0.00390625f, (float)v * 0.00390625f).method_1344();
        tesselator.method_1350();
    }

    protected void method_25346() {
        if (this.drawString) {
            this.method_25355((class_2561)class_2561.method_43473().method_10852(this.prefix).method_27693(this.getValueString()).method_10852(this.suffix));
        } else {
            this.method_25355((class_2561)class_2561.method_43473());
        }
    }

    public void method_25344() {
    }
}

