/*
 * Decompiled with CFR 0.152.
 */
package de.mschae23.grindenchantments.impl;

import de.mschae23.grindenchantments.GrindEnchantments;
import de.mschae23.grindenchantments.GrindEnchantmentsMod;
import de.mschae23.grindenchantments.config.GrindEnchantmentsV2Config;
import de.mschae23.grindenchantments.event.ApplyLevelCostEvent;
import de.mschae23.grindenchantments.event.GrindstoneEvents;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import org.jetbrains.annotations.Nullable;

public class DisenchantOperation
implements GrindstoneEvents.CanInsert,
GrindstoneEvents.UpdateResult,
GrindstoneEvents.CanTakeResult,
GrindstoneEvents.TakeResult,
GrindstoneEvents.LevelCost {
    @Override
    public boolean canInsert(class_1799 stack, class_1799 other, int slotId) {
        return stack.method_7909() == class_1802.field_8529 && !other.method_31574(class_1802.field_8529);
    }

    @Override
    @Nullable
    public class_1799 onUpdateResult(class_1799 input1, class_1799 input2, class_1657 player) {
        if (!DisenchantOperation.isDisenchantOperation(input1, input2)) {
            return null;
        }
        class_1799 enchantedItemStack = input1.method_7942() ? input1 : input2;
        GrindEnchantmentsV2Config config = GrindEnchantmentsMod.getConfig();
        return DisenchantOperation.transferEnchantmentsToBook(enchantedItemStack, config.allowCurses());
    }

    @Override
    public boolean canTakeResult(class_1799 input1, class_1799 input2, class_1657 player) {
        if (DisenchantOperation.isDisenchantOperation(input1, input2)) {
            GrindEnchantmentsV2Config config = GrindEnchantmentsMod.getConfig();
            boolean stack1Book = input1.method_7909() == class_1802.field_8529;
            class_1799 enchantedItemStack = stack1Book ? input2 : input1;
            return DisenchantOperation.canTakeResult(input1, input2, () -> GrindEnchantments.getLevelCost(enchantedItemStack, config.disenchant().costFunction(), config.allowCurses()), player);
        }
        return true;
    }

    @Override
    public boolean onTakeResult(class_1799 input1, class_1799 input2, class_1799 resultStack, class_1657 player, class_1263 input) {
        class_1799 bookItemStack;
        if (!DisenchantOperation.isDisenchantOperation(input1, input2)) {
            return false;
        }
        GrindEnchantmentsV2Config config = GrindEnchantmentsMod.getConfig();
        boolean stack1Book = input1.method_7909() == class_1802.field_8529;
        class_1799 enchantedItemStack = stack1Book ? input2 : input1;
        class_1799 class_17992 = bookItemStack = stack1Book ? input1 : input2;
        if (!player.method_31549().field_7477) {
            int cost = DisenchantOperation.debugLevelCost("onTakeResult", GrindEnchantments.getLevelCost(enchantedItemStack, config.disenchant().costFunction(), config.allowCurses()));
            ((ApplyLevelCostEvent.ApplyLevelCost)ApplyLevelCostEvent.EVENT.invoker()).applyLevelCost(cost, player);
        }
        input.method_5447(stack1Book ? 1 : 0, config.disenchant().consumeItem() ? class_1799.field_8037 : DisenchantOperation.grind(enchantedItemStack, config.allowCurses()));
        if (bookItemStack.method_7947() == 1) {
            input.method_5447(stack1Book ? 0 : 1, class_1799.field_8037);
        } else {
            class_1799 bookNew = bookItemStack.method_7972();
            bookNew.method_7939(bookItemStack.method_7947() - 1);
            input.method_5447(stack1Book ? 0 : 1, bookNew);
        }
        return true;
    }

    @Override
    public int getLevelCost(class_1799 input1, class_1799 input2, class_1657 player) {
        if (DisenchantOperation.isDisenchantOperation(input1, input2)) {
            GrindEnchantmentsV2Config config = GrindEnchantmentsMod.getConfig();
            boolean stack1Book = input1.method_7909() == class_1802.field_8529;
            class_1799 enchantedItemStack = stack1Book ? input2 : input1;
            return DisenchantOperation.debugLevelCost("getLevelCost", GrindEnchantments.getLevelCost(enchantedItemStack, config.disenchant().costFunction(), config.allowCurses()));
        }
        return -1;
    }

    private static int debugLevelCost(String location, int cost) {
        return cost;
    }

    public static boolean isDisenchantOperation(class_1799 input1, class_1799 input2) {
        if (!GrindEnchantmentsMod.getConfig().disenchant().enabled()) {
            return false;
        }
        return input1.method_7942() && input2.method_7909() == class_1802.field_8529 || input2.method_7942() && input1.method_7909() == class_1802.field_8529;
    }

    public static boolean canTakeResult(class_1799 input1, class_1799 input2, IntSupplier cost, class_1657 player) {
        return player.method_31549().field_7477 || player.field_7520 >= cost.getAsInt();
    }

    public static class_1799 transferEnchantmentsToBook(class_1799 source, boolean allowCurses) {
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8598);
        Map<class_1887, Integer> map = GrindEnchantments.getEnchantments(source, allowCurses);
        if (map.isEmpty()) {
            return class_1799.field_8037;
        }
        for (Map.Entry<class_1887, Integer> entry : map.entrySet()) {
            class_1772.method_7807((class_1799)itemStack, (class_1889)new class_1889(entry.getKey(), entry.getValue().intValue()));
        }
        return itemStack;
    }

    private static class_1799 grind(class_1799 item, boolean allowCurses) {
        class_1799 itemStack = item.method_7972();
        itemStack.method_7983("Enchantments");
        itemStack.method_7983("StoredEnchantments");
        Stream<Object> enchantmentStream = class_1890.method_8222((class_1799)item).entrySet().stream();
        enchantmentStream = allowCurses ? Stream.empty() : enchantmentStream.filter(entry -> ((class_1887)entry.getKey()).method_8195());
        Map<class_1887, Integer> map = enchantmentStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        class_1890.method_8214(map, (class_1799)itemStack);
        itemStack.method_7927(0);
        if (itemStack.method_7909() == class_1802.field_8598 && map.size() == 0) {
            itemStack = new class_1799((class_1935)class_1802.field_8529);
            if (item.method_7938()) {
                itemStack.method_7977(item.method_7964());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemStack.method_7927(class_1706.method_20398((int)itemStack.method_7928()));
        }
        return itemStack;
    }
}

