/*
 * Decompiled with CFR 0.152.
 */
package de.mschae23.grindenchantments;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.mschae23.config.api.ConfigIo;
import de.mschae23.config.api.ModConfig;
import de.mschae23.grindenchantments.config.GrindEnchantmentsV2Config;
import de.mschae23.grindenchantments.cost.CostFunctionType;
import de.mschae23.grindenchantments.event.ApplyLevelCostEvent;
import de.mschae23.grindenchantments.event.GrindstoneEvents;
import de.mschae23.grindenchantments.impl.DisenchantOperation;
import de.mschae23.grindenchantments.impl.MoveOperation;
import de.mschae23.grindenchantments.registry.GrindEnchantmentsRegistries;
import io.github.fourmisain.taxfreelevels.TaxFreeLevels;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrindEnchantmentsMod
implements ModInitializer {
    public static final String MODID = "grindenchantments";
    public static final Logger LOGGER = LogManager.getLogger((String)"Grind Enchantments");
    public static final Path CONFIG_PATH = Paths.get("grindenchantments.json", new String[0]);
    private static final GrindEnchantmentsV2Config LATEST_CONFIG_DEFAULT = GrindEnchantmentsV2Config.DEFAULT;
    private static final int LATEST_CONFIG_VERSION = LATEST_CONFIG_DEFAULT.version();
    private static final Codec<ModConfig<GrindEnchantmentsV2Config>> CONFIG_CODEC = ModConfig.createCodec((int)LATEST_CONFIG_VERSION, version -> GrindEnchantmentsMod.getConfigType(GrindEnchantmentsV2Config.VERSIONS, version));
    private static GrindEnchantmentsV2Config CONFIG = LATEST_CONFIG_DEFAULT;

    public void onInitialize() {
        GrindEnchantmentsRegistries.init();
        CostFunctionType.init();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            CONFIG = (GrindEnchantmentsV2Config)ConfigIo.initializeConfig((Path)Paths.get("grindenchantments.json", new String[0]), (int)LATEST_CONFIG_VERSION, (ModConfig)LATEST_CONFIG_DEFAULT, CONFIG_CODEC, (DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)server.method_30611()), arg_0 -> ((Logger)LOGGER).info(arg_0), arg_0 -> ((Logger)LOGGER).error(arg_0));
        });
        DisenchantOperation disenchant = new DisenchantOperation();
        MoveOperation move = new MoveOperation();
        GrindstoneEvents.registerAll(disenchant);
        GrindstoneEvents.registerAll(move);
        ApplyLevelCostEvent.EVENT.register(ApplyLevelCostEvent.DEFAULT, (cost, player) -> {
            player.method_7316(-cost);
            return true;
        });
        if (FabricLoader.getInstance().isModLoaded("taxfreelevels")) {
            ApplyLevelCostEvent.EVENT.register(ApplyLevelCostEvent.MOD_COMPATIBILITY, (cost, player) -> {
                TaxFreeLevels.applyFlattenedXpCost((class_1657)player, (int)cost);
                return true;
            });
        }
    }

    public static GrindEnchantmentsV2Config getConfig() {
        return CONFIG;
    }

    public static <C extends ModConfig<C>> ModConfig.Type<C, ? extends ModConfig<C>> getConfigType(ModConfig.Type<C, ? extends ModConfig<C>>[] versions, int version) {
        for (int i = versions.length - 1; i >= 0; --i) {
            ModConfig.Type<C, ? extends ModConfig<C>> v = versions[i];
            if (version != v.version()) continue;
            return v;
        }
        return versions[versions.length - 1];
    }

    public static void initializeConfigOnClient() {
        class_7225.class_7874 wrapperLookup = class_7225.class_7874.method_46761(Stream.of(GrindEnchantmentsRegistries.COST_FUNCTION.method_46771()));
        CONFIG = (GrindEnchantmentsV2Config)ConfigIo.initializeConfig((Path)Paths.get("grindenchantments.json", new String[0]), (int)LATEST_CONFIG_VERSION, (ModConfig)LATEST_CONFIG_DEFAULT, CONFIG_CODEC, (DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)wrapperLookup), arg_0 -> ((Logger)LOGGER).info(arg_0), arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    public static void log(Level level, Object message) {
        LOGGER.log(level, "[Grind Enchantments] {}", message);
    }

    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }
}

