/*
 * Decompiled with CFR 0.152.
 */
package toni.chunkactivitytracker.data;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2818;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import toni.chunkactivitytracker.ChunkActivityTracker;
import toni.chunkactivitytracker.data.ChunkActivityInfo;
import toni.lib.networking.codecs.StreamCodec;

public class ChunkActivityMap
implements Serializable {
    public static ConcurrentHashMap<class_5321<class_1937>, ChunkActivityMap> instances = new ConcurrentHashMap();
    public static StreamCodec<ByteBuf, ChunkActivityMap> CODEC = new StreamCodec<ByteBuf, ChunkActivityMap>(){

        public ChunkActivityMap decode(ByteBuf buffer) {
            class_2540 buf = new class_2540(buffer);
            Map entries = buf.method_34067(class_2540::readLong, a -> (ChunkActivityInfo)ChunkActivityInfo.CODEC.decode(a));
            String dimension = buf.method_19772();
            return new ChunkActivityMap(entries, dimension);
        }

        public void encode(ByteBuf buffer, ChunkActivityMap map) {
            class_2540 buf = new class_2540(buffer);
            buf.method_34063(map.chunks, class_2540::writeLong, (a, b) -> ChunkActivityInfo.CODEC.encode(a, b));
            buf.method_10814(map.dimension);
        }
    };
    private final ConcurrentHashMap<Long, ChunkActivityInfo> chunks;
    private String dimension;

    public static void clear() {
        instances.clear();
        ChunkActivityTracker.LOGGER.info("Server stopping, clearing chunk activity tracking map.");
    }

    public static ChunkActivityMap getOrCreateChunkMap(class_5321<class_1937> level) {
        ChunkActivityMap map = instances.getOrDefault(level, null);
        if (map != null) {
            return map;
        }
        ChunkActivityMap ret = ChunkActivityMap.load(level);
        ret.save();
        instances.put(level, ret);
        return ret;
    }

    public static ChunkActivityInfo getChunkInfo(class_5321<class_1937> level, class_1923 chunkPos) {
        ChunkActivityMap map = ChunkActivityMap.getOrCreateChunkMap(level);
        return map.chunks.getOrDefault(chunkPos.method_8324(), null);
    }

    public static ChunkActivityInfo getOrCreateChunkInfo(class_2818 chunk) {
        class_5321 dimension = chunk.method_12200().method_27983();
        ChunkActivityInfo chunkInfo = ChunkActivityMap.getChunkInfo((class_5321<class_1937>)dimension, chunk.method_12004());
        if (chunkInfo != null) {
            return chunkInfo;
        }
        ChunkActivityMap map = ChunkActivityMap.getOrCreateChunkMap((class_5321<class_1937>)dimension);
        chunkInfo = new ChunkActivityInfo(chunk);
        map.chunks.put(chunk.method_12004().method_8324(), chunkInfo);
        return chunkInfo;
    }

    public static ChunkActivityInfo createChunkInfo(class_5321<class_1937> dimension, class_2818 chunk) {
        ChunkActivityMap map = ChunkActivityMap.getOrCreateChunkMap(dimension);
        ChunkActivityInfo chunkInfo = new ChunkActivityInfo(chunk);
        map.chunks.put(chunk.method_12004().method_8324(), chunkInfo);
        return chunkInfo;
    }

    public static ChunkActivityInfo createChunkInfo(class_5321<class_1937> level, class_1923 chunk) {
        ChunkActivityMap map = ChunkActivityMap.getOrCreateChunkMap(level);
        ChunkActivityInfo chunkInfo = new ChunkActivityInfo(new HashMap<UUID, Long>(), new HashMap<UUID, Integer>(), null);
        map.chunks.put(chunk.method_8324(), chunkInfo);
        return chunkInfo;
    }

    public ChunkActivityMap(Map<Long, ChunkActivityInfo> chunks, String dimension) {
        this.chunks = chunks != null ? new ConcurrentHashMap<Long, ChunkActivityInfo>(chunks) : new ConcurrentHashMap();
        this.dimension = dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        long startTime = System.currentTimeMillis();
        Path filePath = ChunkActivityMap.datafile(this.dimension);
        if (filePath == null) {
            ChunkActivityTracker.LOGGER.error("Could not get chunk activity data location!");
            return;
        }
        try (FileOutputStream fileOut = new FileOutputStream(filePath.toFile());
             GZIPOutputStream gzipOut = new GZIPOutputStream(fileOut);){
            ByteBuf buffer = Unpooled.buffer();
            try {
                CODEC.encode((Object)buffer, (Object)this);
                gzipOut.write(buffer.array(), buffer.readerIndex(), buffer.readableBytes());
                gzipOut.flush();
            }
            finally {
                buffer.release();
            }
        }
        catch (Exception e) {
            ChunkActivityTracker.LOGGER.error("Error when saving chunk activity info: " + e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        ChunkActivityTracker.LOGGER.info("Saving data for " + this.chunks.size() + " chunks for dimension '" + this.dimension + "' took " + (endTime - startTime) + " milliseconds");
    }

    /*
     * Exception decompiling
     */
    public static ChunkActivityMap load(class_5321<class_1937> dimension) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path datafile(String dimension) {
        Path dir = ChunkActivityTracker.getWorldPath(new class_5218("chunk_activity_info/"));
        if (dir == null) {
            return null;
        }
        dir.toFile().mkdirs();
        return ChunkActivityTracker.getWorldPath(new class_5218("chunk_activity_info/" + dimension + ".dat"));
    }

    @Generated
    public ConcurrentHashMap<Long, ChunkActivityInfo> getChunks() {
        return this.chunks;
    }

    @Generated
    public String getDimension() {
        return this.dimension;
    }
}

