/*
 * Decompiled with CFR 0.152.
 */
package toni.chunkactivitytracker.data;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.class_2540;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import toni.chunkactivitytracker.foundation.config.AllConfigs;
import toni.lib.networking.codecs.StreamCodec;

public class ChunkActivityInfo
implements Serializable {
    public static int CODEC_VERSION = 1;
    static StreamCodec<ByteBuf, ChunkActivityInfo> CODEC = new StreamCodec<ByteBuf, ChunkActivityInfo>(){

        public ChunkActivityInfo decode(ByteBuf buffer) {
            class_2540 buf = new class_2540(buffer);
            int verson = buf.readInt();
            Map time = buf.method_34067(key -> key.method_10790(), class_2540::readLong);
            Map blocks = buf.method_34067(key -> key.method_10790(), class_2540::readInt);
            boolean hasHeightMap = buf.readBoolean();
            if (hasHeightMap) {
                long[] height = buf.method_33134();
                return new ChunkActivityInfo(time, blocks, height);
            }
            return new ChunkActivityInfo(time, blocks, null);
        }

        public void encode(ByteBuf buffer, ChunkActivityInfo info) {
            class_2540 buf = new class_2540(buffer);
            buf.writeInt(CODEC_VERSION);
            buf.method_34063(info.playerTimeMap, (a, b) -> a.method_10797(b), class_2540::writeLong);
            buf.method_34063(info.blocksPlacedMap, (a, b) -> a.method_10797(b), class_2540::writeInt);
            if (info.initialHeightmap != null) {
                buf.writeBoolean(true);
                buf.method_10789(info.initialHeightmap);
            } else {
                buf.writeBoolean(false);
            }
        }
    };
    private final ConcurrentHashMap<UUID, Long> playerTimeMap;
    private final ConcurrentHashMap<UUID, Integer> blocksPlacedMap;
    private long[] initialHeightmap;

    public ChunkActivityInfo(Map<UUID, Long> playerTimeInSeconds, Map<UUID, Integer> blocksPlacedByPlayer, long[] initialHeightmap) {
        this.playerTimeMap = new ConcurrentHashMap<UUID, Long>(playerTimeInSeconds);
        this.blocksPlacedMap = new ConcurrentHashMap<UUID, Integer>(blocksPlacedByPlayer);
        this.initialHeightmap = initialHeightmap;
    }

    public ChunkActivityInfo(class_2818 chunk) {
        this.playerTimeMap = new ConcurrentHashMap();
        this.blocksPlacedMap = new ConcurrentHashMap();
        if (((Boolean)AllConfigs.server().storeHeightmaps.get()).booleanValue()) {
            class_2902 heightmap = chunk.method_12032(class_2902.class_2903.field_13203);
            this.initialHeightmap = heightmap.method_12598();
        }
    }

    public void updatePlayerTime(UUID player) {
        this.playerTimeMap.merge(player, 1L, Long::sum);
    }

    public Long getPlayerTime(UUID player) {
        return this.playerTimeMap.getOrDefault(player, 0L);
    }

    public void incrementBlocksPlaced(UUID player) {
        this.blocksPlacedMap.merge(player, 1, Integer::sum);
    }

    @Generated
    public ConcurrentHashMap<UUID, Long> getPlayerTimeMap() {
        return this.playerTimeMap;
    }

    @Generated
    public ConcurrentHashMap<UUID, Integer> getBlocksPlacedMap() {
        return this.blocksPlacedMap;
    }

    @Generated
    public long[] getInitialHeightmap() {
        return this.initialHeightmap;
    }
}

