/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.inventory;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.inventory.BackpackInventory;
import com.witchica.compactstorage.common.item.BackpackItem;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.InventoryOpenSource;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class BackpackInventoryHandlerFactory
implements class_3908 {
    private final Optional<class_1268> hand;
    public InventoryOpenSource openSource;
    public class_1799 backpackStack;

    public BackpackInventoryHandlerFactory(class_1657 player, InventoryOpenSource openSource, Optional<class_1268> hand) {
        this.openSource = openSource;
        this.hand = hand;
        this.backpackStack = BackpackInventoryHandlerFactory.findBackpackStack(player, openSource, hand);
    }

    public class_2561 method_5476() {
        return this.backpackStack.method_7964();
    }

    public static BackpackInventory getBackpackInventory(class_1657 player, InventoryOpenSource openSource, Optional<class_1268> hand) {
        class_1799 backpackStack = BackpackInventoryHandlerFactory.findBackpackStack(player, openSource, hand);
        return new BackpackInventory(player, openSource, backpackStack, hand);
    }

    public static class_1799 findBackpackStack(class_1657 player, InventoryOpenSource openSource, Optional<class_1268> hand) {
        if (openSource == InventoryOpenSource.BACKPACK_OPEN_HAND) {
            class_1799 stack = player.method_5998(hand.orElse(class_1268.field_5808));
            if (stack.method_7909() instanceof BackpackItem) {
                return stack;
            }
            return class_1799.field_8037;
        }
        class_1799 stack = CompactStoragePlatform.getAdditionalSlotBackpack(player).orElse(class_1799.field_8037);
        return stack;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        BackpackInventory backpackInventory = BackpackInventoryHandlerFactory.getBackpackInventory(player, this.openSource, this.hand);
        return new CompactChestScreenHandler(syncId, inv, this.writeToByteBuf(new class_2540(Unpooled.buffer())));
    }

    public class_2540 writeToByteBuf(class_2540 buf) {
        buf.writeInt(this.openSource.ordinal());
        buf.writeInt(this.hand.orElse(class_1268.field_5808).ordinal());
        return buf;
    }
}

