/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.client.init.ModClientRegistry;
import fuzs.strawstatues.client.model.StrawStatueArmorModel;
import fuzs.strawstatues.client.model.StrawStatueModel;
import fuzs.strawstatues.client.renderer.entity.layers.StrawStatueCapeLayer;
import fuzs.strawstatues.client.renderer.entity.layers.StrawStatueDeadmau5EarsLayer;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import net.minecraft.class_970;
import net.minecraft.class_976;
import net.minecraft.class_979;
import net.minecraft.class_989;
import org.jetbrains.annotations.Nullable;

public class StrawStatueRenderer
extends class_922<StrawStatue, StrawStatueModel> {
    public static final class_2960 STRAW_STATUE_LOCATION = StrawStatues.id("textures/entity/straw_statue.png");

    public StrawStatueRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new StrawStatueModel(context.method_32167(ModClientRegistry.STRAW_STATUE), false), 0.0f);
        this.method_4046((class_3887)new class_970((class_3883)this, new StrawStatueArmorModel(context.method_32167(ModClientRegistry.STRAW_STATUE_INNER_ARMOR)), new StrawStatueArmorModel(context.method_32167(ModClientRegistry.STRAW_STATUE_OUTER_ARMOR)), context.method_48481()));
        this.method_4046((class_3887)new class_989((class_3883)this, context.method_43338()));
        this.method_4046((class_3887)new class_979((class_3883)this, context.method_32170()));
        this.method_4046(new StrawStatueDeadmau5EarsLayer((class_3883<StrawStatue, StrawStatueModel>)this));
        this.method_4046(new StrawStatueCapeLayer((class_3883<StrawStatue, StrawStatueModel>)this));
        this.method_4046((class_3887)new class_976((class_3883)this, context.method_32170(), context.method_43338()));
    }

    public static Optional<class_2960> getPlayerProfileTexture(StrawStatue entity, MinecraftProfileTexture.Type type) {
        class_310 minecraft;
        Map map;
        GameProfile gameProfile = entity.getOwner().orElse(null);
        if (gameProfile != null && (map = (minecraft = class_310.method_1551()).method_1582().method_4654(gameProfile)).containsKey(type)) {
            return Optional.of(minecraft.method_1582().method_4656((MinecraftProfileTexture)map.get(type), type));
        }
        return Optional.empty();
    }

    public void render(StrawStatue entity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        this.setModelProperties(entity);
        super.method_4054((class_1309)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public class_243 getRenderOffset(StrawStatue entity, float partialTicks) {
        return entity.method_18276() ? new class_243(0.0, -0.125, 0.0) : super.method_23169((class_1297)entity, partialTicks);
    }

    private void setModelProperties(StrawStatue entity) {
        StrawStatueModel model = (StrawStatueModel)this.method_4038();
        model.method_2805(true);
        model.field_3394.field_3665 = entity.isModelPartShown(class_1664.field_7563);
        model.field_3483.field_3665 = entity.isModelPartShown(class_1664.field_7564);
        model.field_3482.field_3665 = entity.isModelPartShown(class_1664.field_7566);
        model.field_3479.field_3665 = entity.isModelPartShown(class_1664.field_7565);
        model.field_3484.field_3665 = model.slimLeftSleeve.field_3665 = entity.isModelPartShown(class_1664.field_7568);
        model.field_3486.field_3665 = model.slimRightSleeve.field_3665 = entity.isModelPartShown(class_1664.field_7570);
        model.field_3400 = entity.method_18276();
    }

    public class_2960 getTextureLocation(StrawStatue entity) {
        return StrawStatueRenderer.getPlayerProfileTexture(entity, MinecraftProfileTexture.Type.SKIN).orElse(STRAW_STATUE_LOCATION);
    }

    protected void scale(StrawStatue livingEntity, class_4587 matrixStack, float partialTickTime) {
        float modelScale = class_3532.method_16439((float)partialTickTime, (float)livingEntity.entityScaleO, (float)livingEntity.getEntityScale());
        modelScale /= 3.0f;
        matrixStack.method_22905(modelScale *= 0.9375f, modelScale, modelScale);
    }

    protected void setupRotations(StrawStatue entityLiving, class_4587 matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        float entityZRotation = class_3532.method_16439((float)partialTicks, (float)entityLiving.entityRotationsO.method_10258(), (float)entityLiving.getEntityZRotation());
        float entityXRotation = class_3532.method_16439((float)partialTicks, (float)entityLiving.entityRotationsO.method_10256(), (float)entityLiving.getEntityXRotation());
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f - entityZRotation));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - rotationYaw));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f - entityXRotation));
        float hurtAmount = (float)(entityLiving.method_37908().method_8510() - entityLiving.field_7112) + partialTicks;
        if (hurtAmount < 5.0f) {
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15374((float)(hurtAmount / 1.5f * (float)Math.PI)) * 3.0f));
        }
        if (StrawStatueRenderer.method_38563((class_1309)entityLiving)) {
            matrixStack.method_22904(0.0, (double)(entityLiving.method_17682() - 0.0625f), 0.0);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        }
    }

    protected boolean shouldShowName(StrawStatue entity) {
        double d = this.field_4676.method_23168((class_1297)entity);
        float f = entity.method_18276() ? 32.0f : 64.0f;
        return !(d >= (double)(f * f)) && entity.method_5807();
    }

    @Nullable
    protected class_1921 getRenderType(StrawStatue livingEntity, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (!livingEntity.method_6912()) {
            return super.method_24302((class_1309)livingEntity, bodyVisible, translucent, glowing);
        }
        class_2960 resourceLocation = this.getTextureLocation(livingEntity);
        if (translucent) {
            return class_1921.method_24294((class_2960)resourceLocation, (boolean)false);
        }
        return bodyVisible ? class_1921.method_24293((class_2960)resourceLocation, (boolean)false) : null;
    }
}

