/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1531;
import net.minecraft.class_4587;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;

public class StrawStatueModel
extends class_591<StrawStatue> {
    public final class_630 slimLeftArm;
    public final class_630 slimRightArm;
    public final class_630 slimLeftSleeve;
    public final class_630 slimRightSleeve;
    private final class_630 cloak;
    private boolean slim;

    public StrawStatueModel(class_630 modelPart, boolean slim) {
        super(modelPart, slim);
        this.slimLeftArm = modelPart.method_32086("slim_left_arm");
        this.slimRightArm = modelPart.method_32086("slim_right_arm");
        this.slimLeftSleeve = modelPart.method_32086("slim_left_sleeve");
        this.slimRightSleeve = modelPart.method_32086("slim_right_sleeve");
        this.cloak = modelPart.method_32086("cloak");
    }

    public static class_5607 createBodyLayer() {
        class_5609 meshDefinition = class_591.method_32028((class_5605)class_5605.field_27715, (boolean)false);
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("slim_left_arm", class_5606.method_32108().method_32101(32, 48).method_32098(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, class_5605.field_27715), class_5603.method_32090((float)5.0f, (float)2.5f, (float)0.0f));
        partDefinition.method_32117("slim_right_arm", class_5606.method_32108().method_32101(40, 16).method_32098(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, class_5605.field_27715), class_5603.method_32090((float)-5.0f, (float)2.5f, (float)0.0f));
        partDefinition.method_32117("slim_left_sleeve", class_5606.method_32108().method_32101(48, 48).method_32098(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, class_5605.field_27715.method_32094(0.25f)), class_5603.method_32090((float)5.0f, (float)2.5f, (float)0.0f));
        partDefinition.method_32117("slim_right_sleeve", class_5606.method_32108().method_32101(40, 32).method_32098(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, class_5605.field_27715.method_32094(0.25f)), class_5603.method_32090((float)-5.0f, (float)2.5f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<class_630> method_22946() {
        return Iterables.concat((Iterable)super.method_22946(), (Iterable)ImmutableList.of((Object)this.field_3394));
    }

    protected Iterable<class_630> method_22948() {
        return (Iterable)Stream.concat(StreamSupport.stream(super.method_22948().spliterator(), false).filter(modelPart -> modelPart != this.field_3394), Stream.of(this.slimLeftArm, this.slimRightArm, this.slimLeftSleeve, this.slimRightSleeve)).collect(ImmutableList.toImmutableList());
    }

    public void setupAnim(StrawStatue entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        StrawStatueModel.setupPoseAnim(this, entity);
        this.setupSlimAnim(entity);
        this.setupCloakAnim(entity);
        this.field_3394.method_17138(this.field_3398);
        this.field_3482.method_17138(this.field_3397);
        this.field_3479.method_17138(this.field_3392);
        this.field_3484.method_17138(this.field_27433);
        this.field_3486.method_17138(this.field_3401);
        this.slimLeftSleeve.method_17138(this.slimLeftArm);
        this.slimRightSleeve.method_17138(this.slimRightArm);
        this.field_3483.method_17138(this.field_3391);
        this.setupCrouchingAnimCape(entity);
    }

    private void setupSlimAnim(StrawStatue entity) {
        this.slimLeftArm.field_3665 = true;
        this.field_27433.field_3665 = true;
        this.slimRightArm.field_3665 = true;
        this.field_3401.field_3665 = true;
        this.slim = entity.slimArms();
        this.slimLeftArm.field_3654 = (float)Math.PI / 180 * entity.method_6930().method_10256();
        this.slimLeftArm.field_3675 = (float)Math.PI / 180 * entity.method_6930().method_10257();
        this.slimLeftArm.field_3674 = (float)Math.PI / 180 * entity.method_6930().method_10258();
        this.slimRightArm.field_3654 = (float)Math.PI / 180 * entity.method_6903().method_10256();
        this.slimRightArm.field_3675 = (float)Math.PI / 180 * entity.method_6903().method_10257();
        this.slimRightArm.field_3674 = (float)Math.PI / 180 * entity.method_6903().method_10258();
        if (this.slim) {
            this.field_3484.field_3665 = false;
            this.field_27433.field_3665 = false;
            this.field_3486.field_3665 = false;
            this.field_3401.field_3665 = false;
        } else {
            this.slimLeftSleeve.field_3665 = false;
            this.slimLeftArm.field_3665 = false;
            this.slimRightSleeve.field_3665 = false;
            this.slimRightArm.field_3665 = false;
        }
    }

    private void setupCloakAnim(StrawStatue entity) {
        this.cloak.field_3654 = (float)(-Math.PI) / 180 * entity.method_6923().method_10256();
        this.cloak.field_3675 = (float)Math.PI / 180 * entity.method_6923().method_10257();
        this.cloak.field_3674 = (float)(-Math.PI) / 180 * entity.method_6923().method_10258();
    }

    private void setupCrouchingAnimCape(StrawStatue entity) {
        if (entity.method_6118(class_1304.field_6174).method_7960()) {
            if (this.field_3400) {
                this.cloak.field_3655 = 1.4f;
                this.cloak.field_3656 = 1.85f;
            } else {
                this.cloak.field_3655 = 0.0f;
                this.cloak.field_3656 = 0.0f;
            }
        } else if (this.field_3400) {
            this.cloak.field_3655 = 0.3f;
            this.cloak.field_3656 = 0.8f;
        } else {
            this.cloak.field_3655 = -1.1f;
            this.cloak.field_3656 = -0.85f;
        }
    }

    public void method_2803(class_1306 side, class_4587 poseStack) {
        class_630 modelPart = this.method_2808(side);
        if (this.slim) {
            float f = 0.5f * (float)(side == class_1306.field_6183 ? 1 : -1);
            modelPart.field_3657 += f;
            modelPart.method_22703(poseStack);
            modelPart.field_3657 -= f;
        } else {
            modelPart.method_22703(poseStack);
        }
    }

    public static <T extends class_1531> void setupPoseAnim(class_572<T> model, T entity) {
        model.field_3398.field_3654 = (float)Math.PI / 180 * entity.method_6921().method_10256();
        model.field_3398.field_3675 = (float)Math.PI / 180 * entity.method_6921().method_10257();
        model.field_3398.field_3674 = (float)Math.PI / 180 * entity.method_6921().method_10258();
        model.field_27433.field_3654 = (float)Math.PI / 180 * entity.method_6930().method_10256();
        model.field_27433.field_3675 = (float)Math.PI / 180 * entity.method_6930().method_10257();
        model.field_27433.field_3674 = (float)Math.PI / 180 * entity.method_6930().method_10258();
        model.field_3401.field_3654 = (float)Math.PI / 180 * entity.method_6903().method_10256();
        model.field_3401.field_3675 = (float)Math.PI / 180 * entity.method_6903().method_10257();
        model.field_3401.field_3674 = (float)Math.PI / 180 * entity.method_6903().method_10258();
        model.field_3397.field_3654 = (float)Math.PI / 180 * entity.method_6917().method_10256();
        model.field_3397.field_3675 = (float)Math.PI / 180 * entity.method_6917().method_10257();
        model.field_3397.field_3674 = (float)Math.PI / 180 * entity.method_6917().method_10258();
        model.field_3392.field_3654 = (float)Math.PI / 180 * entity.method_6900().method_10256();
        model.field_3392.field_3675 = (float)Math.PI / 180 * entity.method_6900().method_10257();
        model.field_3392.field_3674 = (float)Math.PI / 180 * entity.method_6900().method_10258();
        StrawStatueModel.setupCrouchingAnim(model);
    }

    private static <T extends class_1531> void setupCrouchingAnim(class_572<T> model) {
        if (model.field_3400) {
            model.field_3391.field_3654 = 0.5f;
            model.field_3401.field_3654 += 0.4f;
            model.field_27433.field_3654 += 0.4f;
            model.field_3392.field_3655 = 4.0f;
            model.field_3397.field_3655 = 4.0f;
            model.field_3392.field_3656 = 12.2f;
            model.field_3397.field_3656 = 12.2f;
            model.field_3398.field_3656 = 4.2f;
            model.field_3391.field_3656 = 3.2f;
            model.field_27433.field_3656 = 5.2f;
            model.field_3401.field_3656 = 5.2f;
        } else {
            model.field_3391.field_3654 = 0.0f;
            model.field_3392.field_3655 = 0.1f;
            model.field_3397.field_3655 = 0.1f;
            model.field_3392.field_3656 = 12.0f;
            model.field_3397.field_3656 = 12.0f;
            model.field_3398.field_3656 = 0.0f;
            model.field_3391.field_3656 = 0.0f;
            model.field_27433.field_3656 = 2.0f;
            model.field_3401.field_3656 = 2.0f;
        }
    }
}

