/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.item;

import com.github.eterdelta.crittersandcompanions.platform.Services;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class PearlNecklaceItem
extends class_1792 {
    private final int level;

    private static Stream<class_1799> getEquipment(class_1657 player) {
        return Stream.of(player.method_31548().field_7547.stream(), Services.PLATFORM.getAdditionalEquipment(player)).flatMap(Function.identity());
    }

    public static Optional<PearlNecklaceItem> getWearing(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            return Optional.empty();
        }
        class_1657 player = (class_1657)entity;
        return PearlNecklaceItem.getEquipment(player).map(class_1799::method_7909).filter(it -> it instanceof PearlNecklaceItem).map(it -> (PearlNecklaceItem)((Object)it)).max(Comparator.comparing(PearlNecklaceItem::getLevel));
    }

    public PearlNecklaceItem(class_1792.class_1793 properties, int necklaceLevel) {
        super(properties);
        this.level = necklaceLevel;
    }

    private String percentage(int level, double base) {
        return String.format("%.0f", (double)(level * 100) * base);
    }

    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> components, class_1836 tooltipFlag) {
        components.add((class_2561)class_2561.method_43469((String)"pearl_necklace.level", (Object[])new Object[]{this.level}).method_27692(class_124.field_1063));
        components.add((class_2561)class_2561.method_43473());
        components.add((class_2561)class_2561.method_43469((String)"pearl_necklace.swim_speed", (Object[])new Object[]{this.percentage(this.level, (Double)Services.CONFIGS.common().necklaceSwimSpeed.get())}).method_27692(class_124.field_1080));
        components.add((class_2561)class_2561.method_43469((String)"pearl_necklace.drowned_range", (Object[])new Object[]{this.percentage(this.level, (Double)Services.CONFIGS.common().necklaceDrownedDebuff.get())}).method_27692(class_124.field_1080));
        if (this.level > 1) {
            components.add((class_2561)class_2561.method_43469((String)"pearl_necklace.guardian_range", (Object[])new Object[]{this.percentage(this.level, (Double)Services.CONFIGS.common().necklaceGuardianDebuff.get())}).method_27692(class_124.field_1080));
        }
    }

    public int getLevel() {
        return this.level;
    }
}

