/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import io.github.foundationgames.automobility.automobile.attachment.BaseAttachment;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public abstract class RearAttachment
extends BaseAttachment<RearAttachmentType<?>> {
    private float lastYaw;
    private float yaw;
    private float trackedYaw;
    private int yawLerpProgress;

    protected RearAttachment(RearAttachmentType<?> type, AutomobileEntity entity) {
        super(type, entity);
    }

    public final class_243 yawVec() {
        return new class_243(0.0, 0.0, 1.0).method_1024((float)Math.toRadians(180.0f - this.yaw()));
    }

    public final class_243 scaledYawVec() {
        return this.yawVec().method_1021((double)((RearAttachmentType)this.type).model().pivotDistPx() * 0.0625);
    }

    public final class_243 origin() {
        return this.automobile.getTailPos();
    }

    @Override
    public final class_243 pos() {
        return this.origin().method_1019(this.scaledYawVec());
    }

    public float yaw() {
        return this.yaw;
    }

    public float yaw(float delta) {
        return class_3532.method_17821((float)delta, (float)this.lastYaw, (float)this.yaw());
    }

    public void setYaw(float yaw) {
        float diff = class_3532.method_15393((float)(yaw - this.automobile.method_36454()));
        if (diff < -90.0f && diff > -180.0f) {
            yaw = this.automobile.method_36454() - 90.0f;
        } else if (diff > 90.0f && diff < 180.0f) {
            yaw = this.automobile.method_36454() + 90.0f;
        }
        this.yaw = yaw;
    }

    protected final void updateTrackedYaw(float yaw) {
        this.automobile.setTrackedRearAttachmentYaw(yaw);
    }

    public void onTrackedYawUpdated(float yaw) {
        this.trackedYaw = yaw;
        this.yawLerpProgress = this.automobile.method_5864().method_18388() + 1;
    }

    @Override
    protected final void updateTrackedAnimation(float animation) {
        this.automobile.setTrackedRearAttachmentAnimation(animation);
    }

    public final void pull(class_243 movement) {
        class_243 vec = this.scaledYawVec().method_1019(movement);
        this.setYaw(180.0f - (float)Math.toDegrees(Math.atan2(vec.field_1352, vec.field_1350)));
    }

    @Override
    public void tick() {
        this.lastYaw = this.yaw();
        this.rotationTrackingTick();
    }

    private void rotationTrackingTick() {
        if (!this.world().method_8608()) {
            this.yawLerpProgress = 0;
            this.updateTrackedYaw(this.yaw());
        } else if (this.yawLerpProgress > 0) {
            this.setYaw(this.yaw() + class_3532.method_15393((float)(this.trackedYaw - this.yaw())) / (float)this.yawLerpProgress);
            --this.yawLerpProgress;
        }
    }

    public boolean isRideable() {
        return false;
    }

    public double getPassengerHeightOffset() {
        return 0.5;
    }

    public boolean hasMenu() {
        return false;
    }

    @Nullable
    public class_3908 createMenu(class_3914 ctx) {
        return null;
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        nbt.method_10548("yaw", this.yaw());
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.setYaw(nbt.method_10583("yaw"));
    }

    public static RearAttachmentType<?> fromNbt(class_2487 nbt) {
        return RearAttachmentType.REGISTRY.get(class_2960.method_12829((String)nbt.method_10558("type")));
    }
}

