/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandPerformEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.latvian.mods.kubejs.bindings.event.LevelEvents;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.command.CommandRegistryEventJS;
import dev.latvian.mods.kubejs.command.KubeJSCommands;
import dev.latvian.mods.kubejs.level.SimpleLevelEventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.CommandEventJS;
import dev.latvian.mods.kubejs.server.ServerEventJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class KubeJSServerEventHandler {
    private static final class_5218 PERSISTENT_DATA = new class_5218("kubejs_persistent_data.nbt");

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(KubeJSServerEventHandler::serverBeforeStart);
        CommandRegistrationEvent.EVENT.register(KubeJSServerEventHandler::registerCommands);
        LifecycleEvent.SERVER_STARTING.register(KubeJSServerEventHandler::serverStarting);
        LifecycleEvent.SERVER_STOPPING.register(KubeJSServerEventHandler::serverStopping);
        LifecycleEvent.SERVER_STOPPED.register(KubeJSServerEventHandler::serverStopped);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(KubeJSServerEventHandler::serverLevelSaved);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(KubeJSServerEventHandler::serverLevelLoaded);
        CommandPerformEvent.EVENT.register(KubeJSServerEventHandler::command);
    }

    public static void serverBeforeStart(MinecraftServer server) {
        UtilsJS.staticServer = server;
        UtilsJS.staticRegistryAccess = server.method_30611();
        Path p = server.method_27050(PERSISTENT_DATA);
        if (Files.exists(p, new LinkOption[0])) {
            try {
                class_2487 tag = class_2507.method_30613((File)p.toFile());
                if (tag != null) {
                    class_2487 t = tag.method_10562("__restore_inventories");
                    if (!t.method_33133()) {
                        tag.method_10551("__restore_inventories");
                        Map playerMap = server.kjs$restoreInventories();
                        for (String key : t.method_10541()) {
                            class_2499 list = t.method_10554(key, 10);
                            Map map = playerMap.computeIfAbsent(UUID.fromString(key), k -> new HashMap());
                            for (class_2520 tag2 : list) {
                                short slot = ((class_2487)tag2).method_10568("Slot");
                                class_1799 stack = class_1799.method_7915((class_2487)((class_2487)tag2));
                                map.put(Integer.valueOf(slot), stack);
                            }
                        }
                    }
                    server.kjs$getPersistentData().method_10543(tag);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 selection) {
        KubeJSCommands.register(dispatcher);
        if (ServerEvents.COMMAND_REGISTRY.hasListeners()) {
            ServerEvents.COMMAND_REGISTRY.post(ScriptType.SERVER, new CommandRegistryEventJS(dispatcher, registry, selection));
        }
    }

    private static void serverStarting(MinecraftServer server) {
        ServerEvents.LOADED.post(ScriptType.SERVER, new ServerEventJS(server));
    }

    private static void serverStopping(MinecraftServer server) {
        ServerEvents.UNLOADED.post(ScriptType.SERVER, new ServerEventJS(server));
    }

    private static void serverStopped(MinecraftServer server) {
        UtilsJS.staticServer = null;
        UtilsJS.staticRegistryAccess = class_5455.field_40585;
    }

    private static void serverLevelLoaded(class_3218 level) {
        if (LevelEvents.LOADED.hasListeners()) {
            LevelEvents.LOADED.post(new SimpleLevelEventJS((class_1937)level), level.method_27983().method_29177());
        }
    }

    private static void serverLevelSaved(class_3218 level) {
        if (level.method_27983() == class_1937.field_25179) {
            class_2487 serverData = level.method_8503().kjs$getPersistentData().method_10553();
            Path p = level.method_8503().method_27050(PERSISTENT_DATA);
            Map playerMap = level.method_8503().kjs$restoreInventories();
            if (!playerMap.isEmpty()) {
                class_2487 nbt = new class_2487();
                for (Map.Entry entry : playerMap.entrySet()) {
                    class_2499 list = new class_2499();
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        class_2487 tag = new class_2487();
                        tag.method_10575("Slot", ((Integer)entry2.getKey()).shortValue());
                        ((class_1799)entry2.getValue()).method_7953(tag);
                        list.add((Object)tag);
                    }
                    nbt.method_10566(((UUID)entry.getKey()).toString(), (class_2520)list);
                }
                serverData.method_10566("__restore_inventories", (class_2520)nbt);
            }
            class_156.method_27958().execute(() -> {
                try {
                    class_2507.method_30614((class_2487)serverData, (File)p.toFile());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    public static EventResult command(CommandPerformEvent event) {
        if (ServerEvents.COMMAND.hasListeners()) {
            CommandEventJS e = new CommandEventJS(event);
            return ServerEvents.COMMAND.post(e, e.getCommandName()).arch();
        }
        return EventResult.pass();
    }
}

