/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.util.quest;

import bigchadguys.util.init.ModRewardTypes;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class AttributeReward
extends Reward {
    public static final Pattern IDENTIFIER_REGEX = Pattern.compile("^([a-z0-9._-]+:)?[a-z0-9._/-]+$");
    public static final BiMap<class_1322.class_1323, String> OPERATIONS = HashBiMap.create();
    private class_2960 attribute = new class_2960("generic.movement_speed");
    private String name = "Quest Reward";
    private double value = 0.2;
    private class_1322.class_1323 operation = class_1322.class_1323.field_6331;

    public AttributeReward(long id, Quest quest) {
        super(id, quest);
    }

    public RewardType getType() {
        return ModRewardTypes.ATTRIBUTE;
    }

    public void tick(class_1657 player, long completions) {
        if (this.operation == null) {
            return;
        }
        Random random = new Random(this.id);
        UUID uuid = new UUID(random.nextLong(), random.nextLong());
        class_7923.field_41190.method_17966(this.attribute).ifPresent(id -> {
            class_1324 attribute = player.method_6127().method_26842(id);
            if (attribute == null) {
                return;
            }
            attribute.method_6200(uuid);
            if (completions == 0L) {
                return;
            }
            if (this.operation == class_1322.class_1323.field_6328) {
                attribute.method_26835(new class_1322(uuid, this.name, this.value * (double)completions, this.operation));
            } else if (this.operation == class_1322.class_1323.field_6330) {
                attribute.method_26835(new class_1322(uuid, this.name, this.value * (double)completions, this.operation));
            } else if (this.operation == class_1322.class_1323.field_6331) {
                attribute.method_26835(new class_1322(uuid, this.name, Math.pow(1.0 + this.value, completions) - 1.0, this.operation));
            }
        });
    }

    public void claim(class_3222 player, boolean notify) {
        if (notify) {
            new DisplayRewardToastMessage(this.id, (class_2561)class_2561.method_43473().method_10852((class_2561)this.getNameText()).method_27693(": ").method_10852((class_2561)this.getValueText().method_27692(class_124.field_1060)), (Icon)Color4I.empty()).sendTo(player);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43473().method_10852((class_2561)this.getNameText()).method_27693(": ").method_10852((class_2561)this.getValueText().method_27692(class_124.field_1060));
    }

    @Environment(value=EnvType.CLIENT)
    public String getButtonText() {
        return this.getValueText().getString();
    }

    public class_5250 getNameText() {
        return class_7923.field_41190.method_17966(this.attribute).map(attribute -> class_2561.method_43471((String)attribute.method_26830())).orElseGet(() -> class_2561.method_43470((String)"Unknown"));
    }

    public class_5250 getValueText() {
        return switch (this.operation) {
            default -> throw new IncompatibleClassChangeError();
            case class_1322.class_1323.field_6328 -> class_2561.method_43473().method_27693((this.value < 0.0 ? "-" : "+") + this.simplify(Math.abs(this.value)));
            case class_1322.class_1323.field_6330, class_1322.class_1323.field_6331 -> class_2561.method_43473().method_27693((this.value < 0.0 ? "-" : "+") + this.simplify(this.value * 100.0) + "%");
        };
    }

    public Number simplify(double value) {
        if ((double)((long)value) == value) {
            return (long)value;
        }
        return value;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("attribute", this.attribute.toString());
        nbt.method_10582("name", this.name);
        nbt.method_10549("value", this.value);
        nbt.method_10582("operation", (String)OPERATIONS.get((Object)this.operation));
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.attribute = class_2960.method_12829((String)nbt.method_10558("attribute"));
        this.name = nbt.method_10558("name");
        this.value = nbt.method_10574("value");
        this.operation = (class_1322.class_1323)OPERATIONS.inverse().get((Object)nbt.method_10558("operation"));
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10814(this.attribute.toString());
        buffer.method_10814(this.name);
        buffer.writeDouble(this.value);
        buffer.method_10814((String)OPERATIONS.get((Object)this.operation));
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.attribute = class_2960.method_12829((String)buffer.method_19772());
        this.name = buffer.method_19772();
        this.value = buffer.readDouble();
        this.operation = (class_1322.class_1323)OPERATIONS.inverse().get((Object)buffer.method_19772());
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("attribute", this.attribute == null ? null : this.attribute.toString(), v -> {
            this.attribute = class_2960.method_12829((String)v);
        }, "", IDENTIFIER_REGEX).setNameKey("Attribute");
        config.addString("name", this.name, v -> {
            this.name = v;
        }, "Quest Reward").setNameKey("Name");
        config.addDouble("value", this.value, v -> {
            this.value = v;
        }, 0.2, -1000.0, 1000.0).setNameKey("Value");
        config.addEnum("operation", (Object)this.operation, v -> {
            this.operation = v;
        }, NameMap.of((Object)class_1322.class_1323.field_6328, (Object[])class_1322.class_1323.values()).id(arg_0 -> OPERATIONS.get(arg_0)).create()).setNameKey("Operation");
    }

    static {
        OPERATIONS.put((Object)class_1322.class_1323.field_6328, (Object)"add");
        OPERATIONS.put((Object)class_1322.class_1323.field_6330, (Object)"multiply_base");
        OPERATIONS.put((Object)class_1322.class_1323.field_6331, (Object)"multiply_total");
    }
}

