/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.util.mixin;

import bigchadguys.util.TeamDataProxy;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.QuestKey;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TeamData.class}, remap=false)
public class MixinTeamData
implements TeamDataProxy {
    @Shadow
    @Final
    private static Comparator<Object2LongMap.Entry<QuestKey>> OBJECT2LONG_COMPARATOR;
    @Shadow
    @Final
    private UUID teamId;
    @Unique
    private Object2LongOpenHashMap<QuestKey> repeatedCompletions = new Object2LongOpenHashMap();

    @Override
    public Object2LongOpenHashMap<QuestKey> getRepeatedCompletions() {
        return this.repeatedCompletions;
    }

    @Inject(method={"serializeNBT"}, at={@At(value="RETURN")}, remap=false)
    public void serializeNBT(CallbackInfoReturnable<SNBTCompoundTag> ci) {
        SNBTCompoundTag nbt = (SNBTCompoundTag)ci.getReturnValue();
        SNBTCompoundTag compound = new SNBTCompoundTag();
        this.repeatedCompletions.object2LongEntrySet().stream().sorted(OBJECT2LONG_COMPARATOR).forEach(entry -> ((class_2487)compound).method_10544(((QuestKey)entry.getKey()).toString(), entry.getLongValue()));
        ((class_2487)nbt).method_10566("repeated_completions", (class_2520)compound);
    }

    @Inject(method={"deserializeNBT"}, at={@At(value="RETURN")}, remap=false)
    public void deserializeNBT(SNBTCompoundTag nbt, CallbackInfo ci) {
        this.repeatedCompletions.clear();
        SNBTCompoundTag compound = nbt.getCompound("repeated_completions");
        for (String s : compound.method_10541()) {
            this.repeatedCompletions.put((Object)QuestKey.fromString((String)s), compound.method_10537(s));
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")}, remap=false)
    public void write(class_2540 buffer, boolean self, CallbackInfo ci) {
        buffer.method_10804(this.repeatedCompletions.size());
        for (Object2LongMap.Entry entry : this.repeatedCompletions.object2LongEntrySet()) {
            ((QuestKey)entry.getKey()).toNetwork(buffer);
            buffer.method_10791(entry.getLongValue());
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")}, remap=false)
    public void read(class_2540 buffer, boolean self, CallbackInfo ci) {
        int count = buffer.method_10816();
        for (int i = 0; i < count; ++i) {
            QuestKey key = QuestKey.fromNetwork((class_2540)buffer);
            this.repeatedCompletions.put((Object)key, buffer.method_10792());
        }
    }

    @Inject(method={"mergeData"}, at={@At(value="RETURN")}, remap=false)
    public void mergeData(TeamData from, CallbackInfo ci) {
        TeamDataProxy.of(from).getRepeatedCompletions().forEach((id, data) -> this.repeatedCompletions.merge(id, data, (oldVal, newVal) -> oldVal));
    }

    @Inject(method={"mergeClaimedRewards"}, at={@At(value="RETURN")}, remap=false)
    public void mergeClaimedRewards(TeamData from, CallbackInfo ci) {
        TeamDataProxy.of(from).getRepeatedCompletions().forEach((id, data) -> {
            if (id.uuid().equals(this.teamId)) {
                this.repeatedCompletions.put(id, data);
            }
        });
    }

    @Inject(method={"mergeClaimedRewards"}, at={@At(value="RETURN")}, remap=false)
    public void copyData(TeamData from, CallbackInfo ci) {
        this.repeatedCompletions.putAll(TeamDataProxy.of(from).getRepeatedCompletions());
    }
}

