/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.logbegone;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import mod.azure.logbegone.JavaUtilLog4jFilter;
import mod.azure.shadowed.moandjiezana.toml.Toml;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class LogBegoneMod
implements PreLaunchEntrypoint {
    public static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger((String)"logbegone");
    public static final Toml CONFIG = LogBegoneMod.getConfig();
    public static final JavaUtilLog4jFilter FILTER = new JavaUtilLog4jFilter();

    public void onPreLaunch() {
        System.setOut(new SystemPrintFilter(System.out));
        Logger.getLogger("").setFilter(FILTER);
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).addFilter((Filter)FILTER);
        ArrayList<LoggerConfig> foundOffshootLog4jLoggers = new ArrayList<LoggerConfig>();
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        Map map = logContext.getConfiguration().getLoggers();
        for (LoggerConfig logger : map.values()) {
            if (foundOffshootLog4jLoggers.contains(logger)) continue;
            logger.addFilter((Filter)FILTER);
            foundOffshootLog4jLoggers.add(logger);
        }
    }

    public static boolean shouldFilterMessage(String message) {
        Iterator stringIterator = CONFIG.getList("logbegone.phrases").iterator();
        Iterator regexIterator = CONFIG.getList("logbegone.regex").iterator();
        if (message != null) {
            String phrase;
            do {
                String regex;
                if (stringIterator.hasNext()) continue;
                do {
                    if (regexIterator.hasNext()) continue;
                    return false;
                } while (!message.matches(regex = (String)regexIterator.next()));
                return true;
            } while (!message.contains(phrase = (String)stringIterator.next()));
        }
        return true;
    }

    private static Toml getConfig() {
        File config = new File(FabricLoader.getInstance().getConfigDir() + "/logbegone.toml");
        if (!config.exists()) {
            try {
                Files.copy(LogBegoneMod.class.getResourceAsStream("/assets/logbegone/config.toml"), config.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred when creating a new config", (Throwable)e);
            }
        }
        return new Toml().read(config);
    }

    public final class SystemPrintFilter
    extends PrintStream {
        public SystemPrintFilter(PrintStream stream) {
            super(stream);
        }

        @Override
        public void println(String x) {
            if (!LogBegoneMod.shouldFilterMessage(x)) {
                super.println(x);
            }
        }

        @Override
        public void print(String s) {
            if (!LogBegoneMod.shouldFilterMessage(s)) {
                super.print(s);
            }
        }
    }
}

