/*
 * Decompiled with CFR 0.152.
 */
package com.rafacasari.mod.cobbledex.api;

import com.cobblemon.mod.common.pokemon.FormData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.rafacasari.mod.cobbledex.api.classes.DiscoveryRegister;
import com.rafacasari.mod.cobbledex.utils.MiscUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B)\u0012 \b\u0002\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007JC\u0010\u0011\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R/\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/rafacasari/mod/cobbledex/api/CobbledexCoopDiscovery;", "", "", "", "Lcom/rafacasari/mod/cobbledex/api/classes/DiscoveryRegister;", "registers", "<init>", "(Ljava/util/Map;)V", "species", "form", "", "isShiny", "Lcom/rafacasari/mod/cobbledex/api/classes/DiscoveryRegister$RegisterType;", "status", "Lkotlin/Function1;", "", "update", "addOrUpdate", "(Ljava/lang/String;Ljava/lang/String;ZLcom/rafacasari/mod/cobbledex/api/classes/DiscoveryRegister$RegisterType;Lkotlin/jvm/functions/Function1;)Z", "showdownId", "getRegister", "(Ljava/lang/String;)Ljava/util/Map;", "Ljava/util/Map;", "getRegisters", "()Ljava/util/Map;", "Companion", "common"})
public final class CobbledexCoopDiscovery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Map<String, DiscoveryRegister>> registers;
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    @Nullable
    private static CobbledexCoopDiscovery discovery;
    @NotNull
    private static String filePath;

    public CobbledexCoopDiscovery(@NotNull Map<String, Map<String, DiscoveryRegister>> registers) {
        Intrinsics.checkNotNullParameter(registers, (String)"registers");
        this.registers = registers;
    }

    public /* synthetic */ CobbledexCoopDiscovery(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, Map<String, DiscoveryRegister>> getRegisters() {
        return this.registers;
    }

    private final Map<String, DiscoveryRegister> getRegister(String showdownId) {
        return this.registers.get(showdownId);
    }

    public final boolean addOrUpdate(@NotNull String species2, @NotNull String form2, boolean isShiny, @NotNull DiscoveryRegister.RegisterType status, @Nullable Function1<? super DiscoveryRegister, Unit> update) {
        block6: {
            Long caughtTimestamp;
            Intrinsics.checkNotNullParameter((Object)species2, (String)"species");
            Intrinsics.checkNotNullParameter((Object)form2, (String)"form");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Map<String, DiscoveryRegister> currentRegister = this.getRegister(species2);
            long discoverTimestamp = System.currentTimeMillis();
            Long l = caughtTimestamp = status == DiscoveryRegister.RegisterType.CAUGHT ? Long.valueOf(discoverTimestamp) : null;
            if (currentRegister != null) {
                DiscoveryRegister formRegister = currentRegister.get(form2);
                if (formRegister != null) {
                    if (!formRegister.isShiny() && isShiny) {
                        formRegister.setShiny(true);
                    }
                    if (formRegister.getStatus() == DiscoveryRegister.RegisterType.SEEN && status == DiscoveryRegister.RegisterType.CAUGHT) {
                        formRegister.setStatus(DiscoveryRegister.RegisterType.CAUGHT);
                        formRegister.setCaughtTimestamp(caughtTimestamp);
                    }
                    Function1<? super DiscoveryRegister, Unit> function1 = update;
                    if (function1 != null) {
                        function1.invoke((Object)formRegister);
                    }
                    return false;
                }
                DiscoveryRegister newRegister = new DiscoveryRegister(isShiny, status, discoverTimestamp, caughtTimestamp);
                currentRegister.put(form2, newRegister);
                Function1<? super DiscoveryRegister, Unit> function1 = update;
                if (function1 != null) {
                    function1.invoke((Object)newRegister);
                }
                return true;
            }
            DiscoveryRegister newRegister = new DiscoveryRegister(isShiny, status, discoverTimestamp, caughtTimestamp);
            Map<String, Map<String, DiscoveryRegister>> map = this.registers;
            Object object = new Pair[]{TuplesKt.to((Object)form2, (Object)newRegister)};
            object = MapsKt.mutableMapOf((Pair[])object);
            map.put(species2, (Map<String, DiscoveryRegister>)object);
            Function1<? super DiscoveryRegister, Unit> function1 = update;
            if (function1 == null) break block6;
            function1.invoke((Object)newRegister);
        }
        return true;
    }

    public CobbledexCoopDiscovery() {
        this(null, 1, null);
    }

    static {
        filePath = "";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJE\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n\u00a2\u0006\u0004\b\u000e\u0010\u0013J=\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n\u00a2\u0006\u0004\b\u0014\u0010\u000fJE\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\f\u00a2\u0006\u0004\b\u001c\u0010\u0003R\u001c\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/rafacasari/mod/cobbledex/api/CobbledexCoopDiscovery$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/FormData;", "form", "", "isShiny", "Lcom/rafacasari/mod/cobbledex/api/classes/DiscoveryRegister$RegisterType;", "status", "Lkotlin/Function1;", "Lcom/rafacasari/mod/cobbledex/api/classes/DiscoveryRegister;", "", "update", "addOrUpdateCoop", "(Lcom/cobblemon/mod/common/pokemon/FormData;ZLcom/rafacasari/mod/cobbledex/api/classes/DiscoveryRegister$RegisterType;Lkotlin/jvm/functions/Function1;)Z", "", "speciesShowdownId", "formOnlyShowdownId", "(Ljava/lang/String;Ljava/lang/String;ZLcom/rafacasari/mod/cobbledex/api/classes/DiscoveryRegister$RegisterType;Lkotlin/jvm/functions/Function1;)Z", "addOrUpdateCoopWithoutSaving", "addOrUpdateWithoutSaving", "Lcom/rafacasari/mod/cobbledex/api/CobbledexCoopDiscovery;", "getDiscovery", "()Lcom/rafacasari/mod/cobbledex/api/CobbledexCoopDiscovery;", "path", "load", "(Ljava/lang/String;)V", "save", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "discovery", "Lcom/rafacasari/mod/cobbledex/api/CobbledexCoopDiscovery;", "filePath", "Ljava/lang/String;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CobbledexCoopDiscovery getDiscovery() {
            return discovery;
        }

        public final void load(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            filePath = path;
            if (((CharSequence)filePath).length() == 0) {
                MiscUtils.INSTANCE.logError("Failed to load Cobbledex COOP Discovery! filePath is empty!");
                return;
            }
            MiscUtils.INSTANCE.logInfo("Loading CobbledexCoopDiscovery at \"" + filePath + "\"...");
            File configFile = new File(path);
            configFile.getParentFile().mkdirs();
            if (configFile.exists()) {
                try {
                    FileReader fileReader = new FileReader(configFile);
                    discovery = (CobbledexCoopDiscovery)GSON.fromJson((Reader)fileReader, CobbledexCoopDiscovery.class);
                    fileReader.close();
                }
                catch (Exception error) {
                    MiscUtils.INSTANCE.logError("COOP Cobbledex Discovery failed to load, using default file instead!");
                    discovery = new CobbledexCoopDiscovery(null, 1, null);
                    error.printStackTrace();
                }
            } else {
                discovery = new CobbledexCoopDiscovery(null, 1, null);
            }
            this.save();
        }

        public final void save() {
            if (((CharSequence)filePath).length() == 0) {
                MiscUtils.INSTANCE.logWarn("Tried to save CobbledexCoopDiscovery without a valid filePath");
                return;
            }
            CobbledexCoopDiscovery discoveryRegister = this.getDiscovery();
            if (discoveryRegister == null) {
                MiscUtils.INSTANCE.logWarn("Tried to save CobbledexCoopDiscovery but discover variable was null (or not initialized)");
                return;
            }
            MiscUtils.INSTANCE.logDebug("Saving " + discoveryRegister.getRegisters().size() + " entries to " + filePath);
            try {
                FileWriter fileWriter = new FileWriter(new File(filePath));
                GSON.toJson((Object)discoveryRegister, (Appendable)fileWriter);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {
                MiscUtils.INSTANCE.logError("Failed to save the CobbledexCoopDiscovery! Stack trace:");
                exception.printStackTrace();
            }
        }

        public final boolean addOrUpdateWithoutSaving(@NotNull String speciesShowdownId, @NotNull String formOnlyShowdownId, boolean isShiny, @NotNull DiscoveryRegister.RegisterType status, @Nullable Function1<? super DiscoveryRegister, Unit> update) {
            Intrinsics.checkNotNullParameter((Object)speciesShowdownId, (String)"speciesShowdownId");
            Intrinsics.checkNotNullParameter((Object)formOnlyShowdownId, (String)"formOnlyShowdownId");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            CobbledexCoopDiscovery data = this.getDiscovery();
            boolean returnValue = false;
            if (data != null) {
                returnValue = data.addOrUpdate(speciesShowdownId, formOnlyShowdownId, isShiny, status, update);
            }
            return returnValue;
        }

        public static /* synthetic */ boolean addOrUpdateWithoutSaving$default(Companion companion, String string, String string2, boolean bl, DiscoveryRegister.RegisterType registerType, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = null;
            }
            return companion.addOrUpdateWithoutSaving(string, string2, bl, registerType, (Function1<? super DiscoveryRegister, Unit>)function1);
        }

        public final boolean addOrUpdateCoop(@NotNull String speciesShowdownId, @NotNull String formOnlyShowdownId, boolean isShiny, @NotNull DiscoveryRegister.RegisterType status, @Nullable Function1<? super DiscoveryRegister, Unit> update) {
            Intrinsics.checkNotNullParameter((Object)speciesShowdownId, (String)"speciesShowdownId");
            Intrinsics.checkNotNullParameter((Object)formOnlyShowdownId, (String)"formOnlyShowdownId");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            boolean returnValue = this.addOrUpdateWithoutSaving(speciesShowdownId, formOnlyShowdownId, isShiny, status, update);
            this.save();
            return returnValue;
        }

        public static /* synthetic */ boolean addOrUpdateCoop$default(Companion companion, String string, String string2, boolean bl, DiscoveryRegister.RegisterType registerType, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = null;
            }
            return companion.addOrUpdateCoop(string, string2, bl, registerType, (Function1<? super DiscoveryRegister, Unit>)function1);
        }

        public final boolean addOrUpdateCoopWithoutSaving(@NotNull FormData form2, boolean isShiny, @NotNull DiscoveryRegister.RegisterType status, @Nullable Function1<? super DiscoveryRegister, Unit> update) {
            Intrinsics.checkNotNullParameter((Object)form2, (String)"form");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return this.addOrUpdateWithoutSaving(form2.getSpecies().showdownId(), form2.formOnlyShowdownId(), isShiny, status, update);
        }

        public static /* synthetic */ boolean addOrUpdateCoopWithoutSaving$default(Companion companion, FormData formData, boolean bl, DiscoveryRegister.RegisterType registerType, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = null;
            }
            return companion.addOrUpdateCoopWithoutSaving(formData, bl, registerType, (Function1<? super DiscoveryRegister, Unit>)function1);
        }

        public final boolean addOrUpdateCoop(@NotNull FormData form2, boolean isShiny, @NotNull DiscoveryRegister.RegisterType status, @Nullable Function1<? super DiscoveryRegister, Unit> update) {
            Intrinsics.checkNotNullParameter((Object)form2, (String)"form");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return this.addOrUpdateCoop(form2.getSpecies().showdownId(), form2.formOnlyShowdownId(), isShiny, status, update);
        }

        public static /* synthetic */ boolean addOrUpdateCoop$default(Companion companion, FormData formData, boolean bl, DiscoveryRegister.RegisterType registerType, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = null;
            }
            return companion.addOrUpdateCoop(formData, bl, registerType, (Function1<? super DiscoveryRegister, Unit>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

