/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.compat;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.platform.IPlatformContextService;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.util.InputUtils;

public class LegacyMigrationHandler {
    private static boolean gameOptionsSaveNeeded = false;
    private static boolean notifyDeprecatedResourcePack = false;

    public static void migrateConfig(String configExtension) {
        Path legacyConfigPath = IPlatformContextService.INSTANCE.resolveConfigDir("ping-wheel" + configExtension);
        Path newConfigPath = IPlatformContextService.INSTANCE.resolveConfigDir("pingwheel" + configExtension);
        if (!Files.exists(legacyConfigPath, new LinkOption[0])) {
            return;
        }
        try {
            Files.move(legacyConfigPath, newConfigPath, StandardCopyOption.REPLACE_EXISTING);
            Global.LOGGER.info("Renamed legacy config: %s -> %s".formatted(legacyConfigPath, newConfigPath));
        }
        catch (IOException e) {
            Global.LOGGER.error("Failed to rename legacy config: %s".formatted(e));
        }
    }

    public static void migrateKeyMappings() {
        Path optionsPath = IPlatformContextService.INSTANCE.resolveGameDir("options.txt");
        if (!Files.exists(optionsPath, new LinkOption[0])) {
            Global.LOGGER.warn("Unable to find game options for migration routine");
            return;
        }
        try {
            List<String> lines = Files.readAllLines(optionsPath);
            for (String line : lines) {
                if (!line.contains("ping-wheel")) continue;
                String keyString = line.split(":")[1];
                class_3675.class_306 keyKey = class_3675.method_15981((String)keyString);
                if (line.contains("ping-location")) {
                    InputUtils.KEY_BINDING_PING.method_1422(keyKey);
                    Global.LOGGER.info("Migrated KEY_BINDING_PING: %s".formatted(keyKey));
                } else if (line.contains("open-settings")) {
                    InputUtils.KEY_BINDING_SETTINGS.method_1422(keyKey);
                    Global.LOGGER.info("Migrated KEY_BINDING_SETTINGS: %s".formatted(keyKey));
                }
                gameOptionsSaveNeeded = true;
            }
        }
        catch (IOException e) {
            Global.LOGGER.error("Failed to read options.txt to transfer legacy keybinds: %s".formatted(e));
        }
    }

    public static void onTick() {
        if (CommonClient.Game == null) {
            return;
        }
        if (gameOptionsSaveNeeded) {
            CommonClient.Game.field_1690.method_1640();
            gameOptionsSaveNeeded = false;
        }
        if (notifyDeprecatedResourcePack && CommonClient.Game.field_1724 != null) {
            class_5250 msg = class_2561.method_43470((String)"a resource pack is using the old mod-id, please update ");
            msg.method_10852((class_2561)class_2561.method_43470((String)"\"assets/ping-wheel\"").method_27692(class_124.field_1080));
            msg.method_27693(" to ");
            msg.method_10852((class_2561)class_2561.method_43470((String)"\"assets/pingwheel\"").method_27692(class_124.field_1080));
            CommonClient.Game.field_1724.method_43496((class_2561)LanguageUtils.withModPrefix(msg));
            notifyDeprecatedResourcePack = false;
        }
    }

    public static void checkResources(class_3300 resourceManager) {
        List<class_2960> legacyTextures = List.of(new class_2960("ping-wheel", "ping"), new class_2960("ping-wheel", "textures/ping.png"), new class_2960("ping-wheel", "textures/arrow.png"));
        notifyDeprecatedResourcePack = false;
        for (class_2960 resource : legacyTextures) {
            notifyDeprecatedResourcePack |= !resourceManager.method_14489(resource).isEmpty();
        }
    }
}

