/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.config.RespawnConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1702;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class EffectComponent {
    private final List<class_1293> effects;
    private final int resetHp;
    private final int resetHunger;
    private final float resetSaturation;

    public EffectComponent(class_3222 player) {
        YigdConfig config = YigdConfig.getConfig();
        RespawnConfig rConfig = config.respawnConfig;
        this.effects = new ArrayList<class_1293>();
        this.loadEffectsFromConfig(rConfig);
        this.resetHp = rConfig.respawnHealth;
        class_1702 hungerManager = player.method_7344();
        this.resetHunger = !rConfig.resetHunger ? hungerManager.method_7586() : rConfig.respawnHunger;
        this.resetSaturation = !rConfig.resetSaturation ? hungerManager.method_7589() : rConfig.respawnSaturation;
    }

    public EffectComponent(List<class_1293> effects, int resetHp, int resetHunger, float resetSaturation) {
        this.effects = effects;
        this.resetHp = resetHp;
        this.resetHunger = resetHunger;
        this.resetSaturation = resetSaturation;
    }

    public void applyToPlayer(class_3222 player) {
        if (this.resetHp > 0) {
            player.method_6033((float)this.resetHp);
        }
        class_1702 hungerManager = player.method_7344();
        if (this.resetHunger >= 0) {
            hungerManager.method_7580(this.resetHunger);
        }
        if (this.resetSaturation >= 0.0f) {
            hungerManager.method_7581(this.resetSaturation);
        }
        for (class_1293 effect : this.effects) {
            player.method_6092(effect);
        }
    }

    public class_2487 toNbt() {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10569("hp", this.resetHp);
        nbtCompound.method_10569("hunger", this.resetHunger);
        nbtCompound.method_10548("saturation", this.resetSaturation);
        class_2499 nbtEffects = new class_2499();
        for (class_1293 instance : this.effects) {
            class_2487 effectNbt = new class_2487();
            instance.method_5582(effectNbt);
            nbtEffects.add((Object)effectNbt);
        }
        nbtCompound.method_10566("effects", (class_2520)nbtEffects);
        return nbtCompound;
    }

    private void loadEffectsFromConfig(RespawnConfig rConfig) {
        for (RespawnConfig.EffectConfig effect : rConfig.respawnEffects) {
            class_1291 statusEffect = (class_1291)class_7923.field_41174.method_10223(new class_2960(effect.effectName));
            if (statusEffect == null) continue;
            class_1293 effectInstance = new class_1293(statusEffect, effect.effectTime, effect.effectLevel - 1, false, effect.showBubbles);
            this.effects.add(effectInstance);
        }
    }

    public static EffectComponent fromNbt(class_2487 nbt) {
        int resetHp = nbt.method_10550("hp");
        int resetHunger = nbt.method_10550("hunger");
        float resetSaturation = nbt.method_10583("saturation");
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        class_2499 effectsNbt = nbt.method_10554("effects", 10);
        for (class_2520 e : effectsNbt) {
            class_2487 compound = (class_2487)e;
            class_1293 instance = class_1293.method_5583((class_2487)compound);
            effects.add(instance);
        }
        return new EffectComponent(effects, resetHp, resetHunger, resetSaturation);
    }
}

