/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BigPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1345;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Deer
extends NaturalistAnimal
implements NaturalistGeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int panicTicks = 0;
    private int eatAnimationTick;
    private class_1345 eatBlockGoal;
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.deer.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.deer.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.deer.run");
    protected static final RawAnimation BABY_RUN = RawAnimation.begin().thenLoop("animation.sf_nba.deer.baby_run");
    protected static final RawAnimation EAT = RawAnimation.begin().thenLoop("animation.sf_nba.deer.eat");

    public Deer(class_1299<? extends NaturalistAnimal> entityType, @NotNull class_1937 level) {
        super(entityType, level);
        this.method_49477(2.0f);
    }

    protected class_1330 method_5963() {
        SmartBodyHelper helper = new SmartBodyHelper((class_1308)this);
        helper.bodyLagMoving = 0.7f;
        helper.bodyLagStill = 0.2f;
        return helper;
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new MMPathNavigatorGround((class_1308)this, level);
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return (class_1296)NaturalistEntityTypes.DEER.get().method_5883((class_1937)level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, (double)0.2f);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BigPanicGoal((class_1314)this, 1.6));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8279}), true));
        this.field_6201.method_6277(4, (class_1352)new class_1338((class_1314)this, class_1657.class, 8.0f, 1.5, 2.0, livingEntity -> class_1301.field_6156.test(livingEntity) && !livingEntity.method_21751()));
        this.field_6201.method_6277(4, (class_1352)new class_1338((class_1314)this, class_1588.class, 4.0f, 1.5, 2.0));
        this.field_6201.method_6277(4, (class_1352)new class_1338((class_1314)this, class_1429.class, 10.0f, 1.5, 2.0, livingEntity -> livingEntity.method_5864().method_20210(NaturalistTags.EntityTypes.DEER_PREDATORS)));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.5));
        this.eatBlockGoal = new class_1345((class_1308)this);
        this.field_6201.method_6277(6, (class_1352)this.eatBlockGoal);
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return this.method_6109() ? NaturalistSoundEvents.DEER_HURT_BABY.get() : NaturalistSoundEvents.DEER_HURT.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_6109() ? NaturalistSoundEvents.DEER_AMBIENT_BABY.get() : NaturalistSoundEvents.DEER_AMBIENT.get();
    }

    public float method_6017() {
        return this.method_6109() ? super.method_6017() * 0.65f : super.method_6017();
    }

    public boolean method_6481(class_1799 pStack) {
        return pStack.method_31574(class_1802.field_8279);
    }

    public void method_6007() {
        if (this.method_37908().field_9236) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.method_6007();
    }

    public void method_5711(byte pId) {
        if (pId == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.method_5711(pId);
        }
    }

    public boolean isEating() {
        return this.eatAnimationTick > 0;
    }

    public void method_5983() {
        if (this.method_6109()) {
            this.method_5615(60);
        }
    }

    public void method_5958() {
        super.method_5958();
        this.method_5728(this.method_5962().method_6241() && this.method_5962().method_6242() >= 1.5);
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        boolean lastHurt = super.method_5643(pSource, pAmount);
        if (lastHurt) {
            int ticks;
            this.panicTicks = ticks = 100 + this.field_5974.method_43048(100);
            List deers = this.method_37908().method_18467(Deer.class, this.method_5829().method_1009(8.0, 4.0, 8.0));
            for (Deer deer : deers) {
                deer.panicTicks = ticks;
            }
        }
        return lastHurt;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.panicTicks >= 0) {
                --this.panicTicks;
            }
            if (this.panicTicks == 0 && this.method_6065() != null) {
                this.method_6015(null);
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected <E extends Deer> PlayState predicate(@NotNull AnimationState<E> event) {
        if (this.method_18798().method_37268() > 1.0E-6) {
            if (this.method_5624()) {
                if (this.method_6109()) {
                    event.getController().setAnimation(BABY_RUN);
                    event.getController().setAnimationSpeed(1.0);
                } else {
                    event.getController().setAnimation(RUN);
                    event.getController().setAnimationSpeed(2.3);
                }
            } else {
                event.getController().setAnimation(WALK);
                if (this.method_6109()) {
                    event.getController().setAnimationSpeed(1.2);
                } else {
                    event.getController().setAnimationSpeed(1.0);
                }
            }
        } else {
            event.getController().setAnimation(IDLE);
            if (this.method_6109()) {
                event.getController().setAnimationSpeed(1.5);
            } else {
                event.getController().setAnimationSpeed(1.0);
            }
        }
        return PlayState.CONTINUE;
    }

    protected <E extends Deer> PlayState eatPredicate(@NotNull AnimationState<E> event) {
        if (this.isEating()) {
            event.getController().setAnimation(EAT);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "eat_controller", 5, this::eatPredicate)});
    }
}

