/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.example.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_572;
import software.bernie.example.client.renderer.armor.GeckoArmorRenderer;
import software.bernie.example.registry.ItemRegistry;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public final class GeckoArmorItem
extends class_1738
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer(this);

    public GeckoArmorItem(class_1741 armorMaterial, class_1738.class_8051 type, class_1792.class_1793 properties) {
        super(armorMaterial, type, properties);
    }

    @Override
    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoArmorRenderer<?> renderer;

            @Override
            public class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (this.renderer == null) {
                    this.renderer = new GeckoArmorRenderer();
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<GeckoArmorItem>(this, 20, state -> {
            state.getController().setAnimation(DefaultAnimations.IDLE);
            class_1297 entity = state.getData(DataTickets.ENTITY);
            if (entity instanceof class_1531) {
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (class_1799 stack : entity.method_5661()) {
                if (stack.method_7960()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.method_7909());
            }
            boolean isFullSet = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new GeckoArmorItem[]{ItemRegistry.GECKO_ARMOR_BOOTS, ItemRegistry.GECKO_ARMOR_LEGGINGS, ItemRegistry.GECKO_ARMOR_CHESTPLATE, ItemRegistry.GECKO_ARMOR_HELMET}));
            return isFullSet ? PlayState.CONTINUE : PlayState.STOP;
        }));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

